/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.StatisticsBuildFlowManager;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationCacheStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFinishMetrics;
import org.jetbrains.kotlin.gradle.plugin.statistics.ExecutedTaskMetrics;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatisticsUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsBeanService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsConfiguration;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsLoggerService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinTaskExecutionMetrics;
import org.jetbrains.kotlin.gradle.plugin.statistics.MetricContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.NonSynchronizedMetricsContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.UsesBuildFusService;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifierKt;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0012\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0015\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ!\u0010\u001b\u001a\u00020\u00122\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildFailed", "", "buildId", "", "fusMetricsConsumer", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/NonSynchronizedMetricsContainer;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "projectEvaluatedTime", "", "close", "", "getFusMetricsConsumer", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "getFusMetricsConsumer$kotlin_gradle_plugin_common", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "recordBuildFinished", "recordBuildFinished$kotlin_gradle_plugin_common", "reportFusMetrics", "reportAction", "Lkotlin/Function1;", "reportFusMetrics$kotlin_gradle_plugin_common", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildFusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildFusService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1#2:207\n1855#3,2:208\n*S KotlinDebug\n*F\n+ 1 BuildFusService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService\n*L\n176#1:208,2\n*E\n"})
public abstract class BuildFusService
implements BuildService<Parameters>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean buildFailed;
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final String buildId;
    @NotNull
    private final NonSynchronizedMetricsContainer fusMetricsConsumer;
    private final long projectEvaluatedTime;
    @NotNull
    private static final String serviceName = Reflection.getOrCreateKotlinClass(BuildFusService.class).getSimpleName() + '_' + BuildFusService.class.getClassLoader().hashCode();
    private static long buildStartTime = System.currentTimeMillis();

    public BuildFusService() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.buildId = string;
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Initialize " + this.getClass().getSimpleName());
        KotlinBuildStatsBeanService.Companion.recordBuildStart$kotlin_gradle_plugin_common(this.buildId);
        this.fusMetricsConsumer = new NonSynchronizedMetricsContainer();
        this.projectEvaluatedTime = System.currentTimeMillis();
    }

    @NotNull
    public final StatisticsValuesConsumer getFusMetricsConsumer$kotlin_gradle_plugin_common() {
        return this.fusMetricsConsumer;
    }

    public final void reportFusMetrics$kotlin_gradle_plugin_common(@NotNull Function1<? super StatisticsValuesConsumer, Unit> reportAction) {
        Intrinsics.checkNotNullParameter(reportAction, (String)"reportAction");
        reportAction.invoke((Object)this.fusMetricsConsumer);
    }

    public synchronized void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            TaskExecutionResult taskExecutionResult;
            if (((TaskFinishEvent)event).getResult() instanceof TaskFailureResult) {
                this.buildFailed = true;
            }
            String string = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.taskPath");
            TaskExecutionResult taskExecutionResult2 = taskExecutionResult = TaskExecutionResults.INSTANCE.get(string);
            if (taskExecutionResult2 != null) {
                TaskExecutionResult taskExecutionResult3;
                TaskExecutionResult it = taskExecutionResult3 = taskExecutionResult2;
                boolean bl = false;
                KotlinTaskExecutionMetrics.INSTANCE.collectMetrics(it, (TaskFinishEvent)event, this.fusMetricsConsumer);
            }
        }
        ExecutedTaskMetrics.INSTANCE.collectMetrics$kotlin_gradle_plugin_common(event, this.fusMetricsConsumer);
    }

    @Override
    public void close() {
        if (!((Boolean)((Parameters)this.getParameters()).getUseBuildFinishFlowAction().get()).booleanValue()) {
            this.recordBuildFinished$kotlin_gradle_plugin_common(this.buildFailed);
        }
        KotlinBuildStatsBeanService.Companion.closeServices();
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Close " + this.getClass().getSimpleName());
    }

    public final void recordBuildFinished$kotlin_gradle_plugin_common(boolean buildFailed) {
        block2: {
            KotlinBuildStatsConfiguration kotlinBuildStatsConfiguration;
            Logger logger = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
            BuildFinishMetrics.INSTANCE.collectMetrics(logger, buildFailed, buildStartTime, this.projectEvaluatedTime, this.fusMetricsConsumer);
            Object object = ((Parameters)this.getParameters()).getConfigurationMetrics().orElse((Object)CollectionsKt.emptyList()).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.configuration\u2026orElse(emptyList()).get()");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetricContainer it = (MetricContainer)element$iv;
                boolean bl = false;
                it.addToConsumer(this.fusMetricsConsumer);
            }
            MetricContainer metricContainer = (MetricContainer)((Parameters)this.getParameters()).getGeneralConfigurationMetrics().getOrNull();
            if (metricContainer != null) {
                metricContainer.addToConsumer(this.fusMetricsConsumer);
            }
            KotlinBuildStatsConfiguration kotlinBuildStatsConfiguration2 = (KotlinBuildStatsConfiguration)((Parameters)this.getParameters()).getBuildStatisticsConfiguration().getOrNull();
            if (kotlinBuildStatsConfiguration2 == null) break block2;
            KotlinBuildStatsConfiguration it = kotlinBuildStatsConfiguration = kotlinBuildStatsConfiguration2;
            boolean bl = false;
            KotlinBuildStatsLoggerService loggerService = new KotlinBuildStatsLoggerService(it);
            loggerService.initSessionLogger(this.buildId);
            loggerService.reportBuildFinished$kotlin_gradle_plugin_common(this.fusMetricsConsumer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Companion;", "", "()V", "buildStartTime", "", "serviceName", "", "getServiceName$kotlin_gradle_plugin_common", "()Ljava/lang/String;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "project", "Lorg/gradle/api/Project;", "pluginVersion", "registerIfAbsentImpl", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getServiceName$kotlin_gradle_plugin_common() {
            return serviceName;
        }

        @NotNull
        public final Provider<BuildFusService> registerIfAbsent(@NotNull Project project, @NotNull String pluginVersion) {
            Provider<BuildFusService> provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
            Provider<BuildFusService> serviceProvider = provider = this.registerIfAbsentImpl(project, pluginVersion);
            boolean bl = false;
            String string = UsesBuildFusService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesBuildFusService::class.java.name");
            SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<BuildFusService> $serviceProvider;
                {
                    this.$project = $project;
                    this.$serviceProvider = $serviceProvider;
                    super(0);
                }

                public final void invoke() {
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                    TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                    boolean $i$f$withType = false;
                    TaskCollection taskCollection = $this$withType$iv.withType(UsesBuildFusService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                    taskCollection.configureEach(new Action(this.$serviceProvider){
                        final /* synthetic */ Provider<BuildFusService> $serviceProvider;
                        {
                            this.$serviceProvider = $serviceProvider;
                        }

                        public final void execute(UsesBuildFusService task2) {
                            task2.getBuildFusService().value(this.$serviceProvider).disallowChanges();
                            task2.usesService(this.$serviceProvider);
                        }
                    });
                }
            }));
            return provider;
        }

        private final Provider<BuildFusService> registerIfAbsentImpl(Project project, String pluginVersion) {
            Provider provider;
            boolean isProjectIsolationEnabled2 = ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project);
            boolean isConfigurationCacheRequested = ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheRequested(project);
            boolean isProjectIsolationRequested = ProjectIsolationStartParameterAccessorKt.isProjectIsolationRequested(project);
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(this.getServiceName$kotlin_gradle_plugin_common());
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider2 = it.getService();
                Intrinsics.checkNotNull((Object)provider2, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusService>");
                return provider2;
            }
            KotlinBuildStatsBeanService.Companion.initStatsService$kotlin_gradle_plugin_common(project);
            List<BuildReportType> buildReportOutputs = ConfigureReporingKt.reportingSettings(project).getBuildReportOutputs();
            boolean useClasspathSnapshot = PropertiesProvider.Companion.invoke(project).getUseClasspathSnapshot();
            Gradle gradle = project.getGradle();
            Provider buildService = provider = gradle.getSharedServices().registerIfAbsent(this.getServiceName$kotlin_gradle_plugin_common(), BuildFusService.class, new Action(project, gradle, buildReportOutputs, useClasspathSnapshot, pluginVersion, isProjectIsolationEnabled2, isProjectIsolationRequested, isConfigurationCacheRequested){
                final /* synthetic */ Project $project;
                final /* synthetic */ Gradle $gradle;
                final /* synthetic */ List<BuildReportType> $buildReportOutputs;
                final /* synthetic */ boolean $useClasspathSnapshot;
                final /* synthetic */ String $pluginVersion;
                final /* synthetic */ boolean $isProjectIsolationEnabled;
                final /* synthetic */ boolean $isProjectIsolationRequested;
                final /* synthetic */ boolean $isConfigurationCacheRequested;
                {
                    this.$project = $project;
                    this.$gradle = $gradle;
                    this.$buildReportOutputs = $buildReportOutputs;
                    this.$useClasspathSnapshot = $useClasspathSnapshot;
                    this.$pluginVersion = $pluginVersion;
                    this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                    this.$isProjectIsolationRequested = $isProjectIsolationRequested;
                    this.$isConfigurationCacheRequested = $isConfigurationCacheRequested;
                }

                public final void execute(BuildServiceSpec<Parameters> spec) {
                    ((Parameters)spec.getParameters()).getGeneralConfigurationMetrics().set(this.$project.provider(new Callable(this.$project, this.$gradle, this.$buildReportOutputs, this.$useClasspathSnapshot, this.$pluginVersion, this.$isProjectIsolationEnabled, this.$isProjectIsolationRequested, this.$isConfigurationCacheRequested){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Gradle $gradle;
                        final /* synthetic */ List<BuildReportType> $buildReportOutputs;
                        final /* synthetic */ boolean $useClasspathSnapshot;
                        final /* synthetic */ String $pluginVersion;
                        final /* synthetic */ boolean $isProjectIsolationEnabled;
                        final /* synthetic */ boolean $isProjectIsolationRequested;
                        final /* synthetic */ boolean $isConfigurationCacheRequested;
                        {
                            this.$project = $project;
                            this.$gradle = $gradle;
                            this.$buildReportOutputs = $buildReportOutputs;
                            this.$useClasspathSnapshot = $useClasspathSnapshot;
                            this.$pluginVersion = $pluginVersion;
                            this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                            this.$isProjectIsolationRequested = $isProjectIsolationRequested;
                            this.$isConfigurationCacheRequested = $isConfigurationCacheRequested;
                        }

                        public final MetricContainer call() {
                            Gradle gradle = this.$gradle;
                            Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
                            return KotlinBuildStatisticsUtilsKt.collectGeneralConfigurationTimeMetrics(this.$project, gradle, this.$buildReportOutputs, this.$useClasspathSnapshot, this.$pluginVersion, this.$isProjectIsolationEnabled, this.$isProjectIsolationRequested, this.$isConfigurationCacheRequested);
                        }
                    }));
                    ((Parameters)spec.getParameters()).getUseBuildFinishFlowAction().set((Object)(GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) >= 0 ? 1 : 0));
                    ((Parameters)spec.getParameters()).getBuildStatisticsConfiguration().set((Object)new KotlinBuildStatsConfiguration(this.$project));
                    ((Parameters)spec.getParameters()).getConfigurationMetrics().add((Object)new MetricContainer());
                }
            });
            boolean bl = false;
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"7.4")) >= 0 || !ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheEnabled(project) || !Intrinsics.areEqual((Object)CurrentBuildIdentifierKt.currentBuildId(project).getName(), (Object)"buildSrc")) {
                BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(buildService);
            }
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) >= 0) {
                StatisticsBuildFlowManager.Companion.getInstance(project).subscribeForBuildResult();
            }
            Provider provider3 = provider;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"project: Project,\n      \u2026          }\n            }");
            return provider3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildStatisticsConfiguration", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsConfiguration;", "getBuildStatisticsConfiguration", "()Lorg/gradle/api/provider/Property;", "configurationMetrics", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "getConfigurationMetrics", "()Lorg/gradle/api/provider/ListProperty;", "generalConfigurationMetrics", "getGeneralConfigurationMetrics", "useBuildFinishFlowAction", "", "getUseBuildFinishFlowAction", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<MetricContainer> getGeneralConfigurationMetrics();

        @NotNull
        public ListProperty<MetricContainer> getConfigurationMetrics();

        @NotNull
        public Property<Boolean> getUseBuildFinishFlowAction();

        @NotNull
        public Property<KotlinBuildStatsConfiguration> getBuildStatisticsConfiguration();
    }
}

