/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.AbstractIterator;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
abstract class MultiEdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<E, ?> outEdgeToNode;
    private final Object targetNode;

    MultiEdgesConnecting(Map<E, ?> outEdgeToNode, Object targetNode) {
        this.outEdgeToNode = Preconditions.checkNotNull(outEdgeToNode);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final Iterator<Map.Entry<E, ?>> entries2 = this.outEdgeToNode.entrySet().iterator();
        return new AbstractIterator<E>(){

            @Override
            @CheckForNull
            protected E computeNext() {
                while (entries2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)entries2.next();
                    if (!MultiEdgesConnecting.this.targetNode.equals(entry2.getValue())) continue;
                    return entry2.getKey();
                }
                return this.endOfData();
            }
        };
    }

    @Override
    public boolean contains(@CheckForNull Object edge) {
        return this.targetNode.equals(this.outEdgeToNode.get(edge));
    }
}

