/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010)\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u0016\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0096\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/utils/SmartSet;", "T", "Lkotlin/collections/AbstractMutableSet;", "<init>", "()V", "data", "", "size", "", "getSize", "()I", "setSize", "(I)V", "iterator", "", "add", "", "element", "(Ljava/lang/Object;)Z", "clear", "", "contains", "Companion", "SingletonIterator", "ArrayIterator", "util.runtime"})
@SourceDebugExtension(value={"SMAP\nSmartSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartSet.kt\norg/jetbrains/kotlin/utils/SmartSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class SmartSet<T>
extends AbstractMutableSet<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object data;
    private int size;
    private static final int ARRAY_THRESHOLD = 5;

    private SmartSet() {
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size() == 0) {
            iterator2 = Collections.emptySet().iterator();
        } else if (this.size() == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size() < 5) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            iterator2 = new ArrayIterator<Object>((Object[])object);
        } else {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<T of org.jetbrains.kotlin.utils.SmartSet>");
            iterator2 = TypeIntrinsics.asMutableSet((Object)object).iterator();
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(T element) {
        if (this.size() == 0) {
            this.data = element;
        } else if (this.size() == 1) {
            if (Intrinsics.areEqual((Object)this.data, element)) {
                return false;
            }
            Object[] objectArray = new Object[]{this.data, element};
            this.data = objectArray;
        } else if (this.size() < 5) {
            Object[] objectArray;
            SmartSet smartSet;
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            Object[] arr = (Object[])object;
            if (ArraysKt.contains((Object[])arr, element)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (this.size() == 4) {
                void $this$add_u24lambda_u240;
                Object[] objectArray2;
                Object[] objectArray3 = objectArray2 = SetsKt.linkedSetOf((Object[])Arrays.copyOf(arr, arr.length));
                SmartSet smartSet3 = smartSet2;
                boolean bl = false;
                $this$add_u24lambda_u240.add(element);
                smartSet = smartSet3;
                objectArray = objectArray2;
            } else {
                Object[] objectArray4;
                Object[] objectArray5 = Arrays.copyOf(arr, this.size() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"copyOf(...)");
                Object[] $this$add_u24lambda_u240 = objectArray4 = objectArray5;
                SmartSet smartSet4 = smartSet2;
                boolean bl = false;
                $this$add_u24lambda_u241[((void)$this$add_u24lambda_u241).length - 1] = element;
                smartSet = smartSet4;
                objectArray = objectArray4;
            }
            smartSet.data = objectArray;
        } else {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<T of org.jetbrains.kotlin.utils.SmartSet>");
            Set set2 = TypeIntrinsics.asMutableSet((Object)object);
            if (!set2.add(element)) {
                return false;
            }
        }
        int n = this.size();
        this.setSize(n + 1);
        return true;
    }

    public void clear() {
        this.data = null;
        this.setSize(0);
    }

    public boolean contains(Object element) {
        boolean bl;
        if (this.size() == 0) {
            bl = false;
        } else if (this.size() == 1) {
            bl = Intrinsics.areEqual((Object)this.data, (Object)element);
        } else if (this.size() < 5) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            bl = ArraysKt.contains((Object[])((Object[])object), (Object)element);
        } else {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Set<T of org.jetbrains.kotlin.utils.SmartSet>");
            bl = ((Set)object).contains(element);
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create(@NotNull Collection<? extends T> set2) {
        return Companion.create(set2);
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\u000e\u0010\u000b\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/utils/SmartSet$ArrayIterator;", "T", "", "array", "", "<init>", "([Ljava/lang/Object;)V", "arrayIterator", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "util.runtime"})
    private static final class ArrayIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        @NotNull
        private final Iterator<T> arrayIterator;

        public ArrayIterator(@NotNull T[] array2) {
            Intrinsics.checkNotNullParameter(array2, (String)"array");
            this.arrayIterator = ArrayIteratorKt.iterator((Object[])array2);
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            return this.arrayIterator.next();
        }

        @NotNull
        public Void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\bH\u0007J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/utils/SmartSet$Companion;", "", "<init>", "()V", "ARRAY_THRESHOLD", "", "create", "Lorg/jetbrains/kotlin/gradle/internal/utils/SmartSet;", "T", "set", "", "util.runtime"})
    @SourceDebugExtension(value={"SMAP\nSmartSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartSet.kt\norg/jetbrains/kotlin/utils/SmartSet$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create(@NotNull Collection<? extends T> set2) {
            SmartSet smartSet;
            Intrinsics.checkNotNullParameter(set2, (String)"set");
            SmartSet $this$create_u24lambda_u240 = smartSet = new SmartSet(null);
            boolean bl = false;
            $this$create_u24lambda_u240.addAll(set2);
            return smartSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0007\u001a\u00020\bH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/utils/SmartSet$SingletonIterator;", "T", "", "element", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "util.runtime"})
    private static final class SingletonIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final T element;
        private boolean hasNext;

        public SingletonIterator(T element) {
            this.element = element;
            this.hasNext = true;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @NotNull
        public Void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

