/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.rmi.RemoteException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.gradle.internal.tasks.TaskWithLocalState;
import org.jetbrains.kotlin.gradle.internal.tasks.TaskWithLocalStateKt;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.tasks.CompilationErrorException;
import org.jetbrains.kotlin.gradle.tasks.DaemonCrashedException;
import org.jetbrains.kotlin.gradle.tasks.FailedCompilationException;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilerExecutionStrategy;
import org.jetbrains.kotlin.gradle.tasks.OOMErrorException;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a>\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0018\u0010\t\u001a\u00020\n*\u00020\u001c2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"kotlinDaemonCrashedMessage", "", "kotlinDaemonOOMHelperMessage", "kotlinInProcessOOMHelperMessage", "kotlinOutOfProcessOOMHelperMessage", "OOMErrorException", "Lorg/jetbrains/kotlin/gradle/tasks/OOMErrorException;", "executionStrategy", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;", "cleanOutputsAndLocalState", "", "outputFiles", "", "Ljava/io/File;", "log", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "reason", "throwExceptionIfCompilationFailed", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "wrapAndRethrowCompilationException", "", "e", "", "Lorg/jetbrains/kotlin/gradle/internal/tasks/TaskWithLocalState;", "hasOOMCause", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\ntasksUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 tasksUtils.kt\norg/jetbrains/kotlin/gradle/tasks/TasksUtilsKt\n+ 2 gradleLoggingUtils.kt\norg/jetbrains/kotlin/gradle/logging/GradleLoggingUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,113:1\n52#2,2:114\n55#2:117\n1#3:116\n31#4,5:118\n*S KotlinDebug\n*F\n+ 1 tasksUtils.kt\norg/jetbrains/kotlin/gradle/tasks/TasksUtilsKt\n*L\n93#1:114,2\n93#1:117\n98#1:118,5\n*E\n"})
public final class TasksUtilsKt {
    @NotNull
    public static final String kotlinDaemonOOMHelperMessage = "Not enough memory to run compilation. Try to increase it via 'gradle.properties':\nkotlin.daemon.jvmargs=-Xmx<size>";
    @NotNull
    public static final String kotlinInProcessOOMHelperMessage = "Not enough memory to run compilation.  Try to increase it via 'gradle.properties':\norg.gradle.jvmargs=-Xmx<size>";
    @NotNull
    public static final String kotlinOutOfProcessOOMHelperMessage = "Not enough memory to run compilation.";
    @NotNull
    private static final String kotlinDaemonCrashedMessage = "Connection to the Kotlin daemon has been unexpectedly lost. This might be caused by the daemon being killed by another process or the operating system, or by JVM crash.";

    public static final void throwExceptionIfCompilationFailed(@NotNull ExitCode exitCode, @NotNull KotlinCompilerExecutionStrategy executionStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)exitCode), (String)"exitCode");
        Intrinsics.checkNotNullParameter((Object)executionStrategy, (String)"executionStrategy");
        switch (WhenMappings.$EnumSwitchMapping$0[exitCode.ordinal()]) {
            case 1: {
                throw new CompilationErrorException("Compilation error. See log for more details");
            }
            case 2: {
                throw new FailedCompilationException("Internal compiler error. See log for more details", null, 2, null);
            }
            case 3: {
                throw new FailedCompilationException("Script execution error. See log for more details", null, 2, null);
            }
            case 4: {
                throw TasksUtilsKt.OOMErrorException(executionStrategy);
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected exit code: " + (Object)((Object)exitCode));
            }
        }
    }

    public static final boolean hasOOMCause(@NotNull Throwable $this$hasOOMCause) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasOOMCause, (String)"<this>");
        if ($this$hasOOMCause.getCause() instanceof OutOfMemoryError) {
            bl = true;
        } else {
            Throwable throwable = $this$hasOOMCause.getCause();
            bl = throwable != null ? TasksUtilsKt.hasOOMCause(throwable) : false;
        }
        return bl;
    }

    @NotNull
    public static final Void wrapAndRethrowCompilationException(@NotNull KotlinCompilerExecutionStrategy executionStrategy, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)executionStrategy, (String)"executionStrategy");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof OutOfMemoryError || TasksUtilsKt.hasOOMCause(e)) {
            throw TasksUtilsKt.OOMErrorException(executionStrategy);
        }
        if (e instanceof RemoteException) {
            throw new DaemonCrashedException(e);
        }
        throw e;
    }

    private static final OOMErrorException OOMErrorException(KotlinCompilerExecutionStrategy executionStrategy) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$1[executionStrategy.ordinal()]) {
            case 1: {
                string2 = kotlinDaemonOOMHelperMessage;
                break;
            }
            case 2: {
                string2 = kotlinInProcessOOMHelperMessage;
                break;
            }
            case 3: {
                string2 = kotlinOutOfProcessOOMHelperMessage;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String exceptionMessage = string2;
        return new OOMErrorException(exceptionMessage);
    }

    public static final void cleanOutputsAndLocalState(@NotNull TaskWithLocalState $this$cleanOutputsAndLocalState, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanOutputsAndLocalState, (String)"<this>");
        Logger logger = $this$cleanOutputsAndLocalState.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleKotlinLogger log = new GradleKotlinLogger(logger, null, 2, null);
        Iterable iterable = TaskWithLocalStateKt.allOutputFiles($this$cleanOutputsAndLocalState);
        KotlinLogger kotlinLogger = log;
        Object object = $this$cleanOutputsAndLocalState.getMetrics().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"metrics.get()");
        TasksUtilsKt.cleanOutputsAndLocalState(iterable, kotlinLogger, (BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>)((BuildMetricsReporter)object), reason);
    }

    public static /* synthetic */ void cleanOutputsAndLocalState$default(TaskWithLocalState taskWithLocalState, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        TasksUtilsKt.cleanOutputsAndLocalState(taskWithLocalState, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void cleanOutputsAndLocalState(@NotNull Iterable<? extends File> outputFiles, @NotNull KotlinLogger log, @NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> metrics, @Nullable String reason) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter(log, (String)"log");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> $this$kotlinDebug$iv = log;
        boolean $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            String string2;
            String string3;
            StringBuilder stringBuilder = new StringBuilder().append("[KOTLIN] ");
            BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter = $this$kotlinDebug$iv;
            boolean bl = false;
            String string4 = reason;
            if (string4 != null) {
                String it = string4;
                boolean bl2 = false;
                string3 = " (" + it + ')';
            } else {
                string3 = string2 = null;
            }
            if (string3 == null) {
                string2 = "";
            }
            String string5 = string2;
            String string6 = "Cleaning output" + string5 + ':';
            buildMetricsReporter.debug(stringBuilder.append(string6).toString());
        }
        $this$kotlinDebug$iv = metrics;
        BuildTime time$iv = (BuildTime)GradleBuildTime.CLEAR_OUTPUT;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            for (File file2 : outputFiles) {
                if (file2.isDirectory()) {
                    log.debug("Deleting contents of output directory: " + file2);
                    FileUtilsKt.deleteDirectoryContents(file2);
                    continue;
                }
                if (!file2.isFile()) continue;
                log.debug("Deleting output file: " + file2);
                FileUtilsKt.deleteRecursivelyOrThrow(file2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    public static /* synthetic */ void cleanOutputsAndLocalState$default(Iterable iterable, KotlinLogger kotlinLogger, BuildMetricsReporter buildMetricsReporter, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        TasksUtilsKt.cleanOutputsAndLocalState(iterable, kotlinLogger, (BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>)buildMetricsReporter, string2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExitCode.values().length];
            try {
                nArray[ExitCode.COMPILATION_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.INTERNAL_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.SCRIPT_EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.OOM_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.OK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KotlinCompilerExecutionStrategy.values().length];
            try {
                nArray[KotlinCompilerExecutionStrategy.DAEMON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinCompilerExecutionStrategy.IN_PROCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinCompilerExecutionStrategy.OUT_OF_PROCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

