/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.J2ktIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Joiner;
import org.jetbrains.kotlin.com.google.common.base.Optional;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.base.Predicate;
import org.jetbrains.kotlin.com.google.common.base.Splitter;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.graph.SuccessorsFunction;
import org.jetbrains.kotlin.com.google.common.graph.Traverser;
import org.jetbrains.kotlin.com.google.common.hash.HashCode;
import org.jetbrains.kotlin.com.google.common.hash.HashFunction;
import org.jetbrains.kotlin.com.google.common.io.ByteProcessor;
import org.jetbrains.kotlin.com.google.common.io.ByteSink;
import org.jetbrains.kotlin.com.google.common.io.ByteSource;
import org.jetbrains.kotlin.com.google.common.io.ByteStreams;
import org.jetbrains.kotlin.com.google.common.io.CharSink;
import org.jetbrains.kotlin.com.google.common.io.CharSource;
import org.jetbrains.kotlin.com.google.common.io.Closer;
import org.jetbrains.kotlin.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.io.FileWriteMode;
import org.jetbrains.kotlin.com.google.common.io.LineProcessor;
import org.jetbrains.kotlin.com.google.common.io.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.io.TempFileCreator;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.InlineMe;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        @Override
        public Iterable<File> successors(File file2) {
            File[] files2;
            if (file2.isDirectory() && (files2 = file2.listFiles()) != null) {
                return Collections.unmodifiableList(Arrays.asList(files2));
            }
            return ImmutableList.of();
        }
    };

    private Files() {
    }

    public static BufferedReader newReader(File file2, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkNotNull(charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), charset));
    }

    public static BufferedWriter newWriter(File file2, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), charset));
    }

    public static ByteSource asByteSource(File file2) {
        return new FileByteSource(file2);
    }

    public static ByteSink asByteSink(File file2, FileWriteMode ... modes) {
        return new FileByteSink(file2, modes);
    }

    public static CharSource asCharSource(File file2, Charset charset) {
        return Files.asByteSource(file2).asCharSource(charset);
    }

    public static CharSink asCharSink(File file2, Charset charset, FileWriteMode ... modes) {
        return Files.asByteSink(file2, modes).asCharSink(charset);
    }

    public static byte[] toByteArray(File file2) throws IOException {
        return Files.asByteSource(file2).read();
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSource(file, charset).read()", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    public static String toString(File file2, Charset charset) throws IOException {
        return Files.asCharSource(file2, charset).read();
    }

    public static void write(byte[] from2, File to) throws IOException {
        Files.asByteSink(to, new FileWriteMode[0]).write(from2);
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSink(to, charset).write(from)", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    public static void write(CharSequence from2, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, new FileWriteMode[0]).write(from2);
    }

    public static void copy(File from2, OutputStream to) throws IOException {
        Files.asByteSource(from2).copyTo(to);
    }

    public static void copy(File from2, File to) throws IOException {
        Preconditions.checkArgument(!from2.equals(to), "Source %s and destination %s must be different", (Object)from2, (Object)to);
        Files.asByteSource(from2).copyTo(Files.asByteSink(to, new FileWriteMode[0]));
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSource(from, charset).copyTo(to)", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    public static void copy(File from2, Charset charset, Appendable to) throws IOException {
        Files.asCharSource(from2, charset).copyTo(to);
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from)", imports={"org.jetbrains.kotlin.com.google.common.io.FileWriteMode", "org.jetbrains.kotlin.com.google.common.io.Files"})
    public static void append(CharSequence from2, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from2);
    }

    public static boolean equal(File file1, File file2) throws IOException {
        Preconditions.checkNotNull(file1);
        Preconditions.checkNotNull(file2);
        if (file1 == file2 || file1.equals(file2)) {
            return true;
        }
        long len1 = file1.length();
        long len2 = file2.length();
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return Files.asByteSource(file1).contentEquals(Files.asByteSource(file2));
    }

    @Deprecated
    @Beta
    public static File createTempDir() {
        return TempFileCreator.INSTANCE.createTempDir();
    }

    public static void touch(File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        if (!file2.createNewFile() && !file2.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to update modification time of " + file2);
        }
    }

    public static void createParentDirs(File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        File parent = file2.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file2);
        }
    }

    public static void move(File from2, File to) throws IOException {
        Preconditions.checkNotNull(from2);
        Preconditions.checkNotNull(to);
        Preconditions.checkArgument(!from2.equals(to), "Source %s and destination %s must be different", (Object)from2, (Object)to);
        if (!from2.renameTo(to)) {
            Files.copy(from2, to);
            if (!from2.delete()) {
                if (!to.delete()) {
                    throw new IOException("Unable to delete " + to);
                }
                throw new IOException("Unable to delete " + from2);
            }
        }
    }

    @Deprecated
    @CheckForNull
    @InlineMe(replacement="Files.asCharSource(file, charset).readFirstLine()", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    public static String readFirstLine(File file2, Charset charset) throws IOException {
        return Files.asCharSource(file2, charset).readFirstLine();
    }

    public static List<String> readLines(File file2, Charset charset) throws IOException {
        return Files.asCharSource(file2, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    @Deprecated
    @ParametricNullness
    @InlineMe(replacement="Files.asCharSource(file, charset).readLines(callback)", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    @CanIgnoreReturnValue
    public static <T> T readLines(File file2, Charset charset, LineProcessor<T> callback) throws IOException {
        return Files.asCharSource(file2, charset).readLines(callback);
    }

    @Deprecated
    @ParametricNullness
    @InlineMe(replacement="Files.asByteSource(file).read(processor)", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    @CanIgnoreReturnValue
    public static <T> T readBytes(File file2, ByteProcessor<T> processor) throws IOException {
        return Files.asByteSource(file2).read(processor);
    }

    @Deprecated
    @InlineMe(replacement="Files.asByteSource(file).hash(hashFunction)", imports={"org.jetbrains.kotlin.com.google.common.io.Files"})
    public static HashCode hash(File file2, HashFunction hashFunction) throws IOException {
        return Files.asByteSource(file2).hash(hashFunction);
    }

    public static MappedByteBuffer map(File file2) throws IOException {
        Preconditions.checkNotNull(file2);
        return Files.map(file2, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedByteBuffer map(File file2, FileChannel.MapMode mode) throws IOException {
        return Files.mapInternal(file2, mode, -1L);
    }

    public static MappedByteBuffer map(File file2, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkArgument(size >= 0L, "size (%s) may not be negative", size);
        return Files.mapInternal(file2, mode, size);
    }

    private static MappedByteBuffer mapInternal(File file2, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkNotNull(file2);
        Preconditions.checkNotNull(mode);
        try (Closer closer = Closer.create();){
            RandomAccessFile raf = closer.register(new RandomAccessFile(file2, mode == FileChannel.MapMode.READ_ONLY ? "r" : "rw"));
            FileChannel channel = closer.register(raf.getChannel());
            MappedByteBuffer mappedByteBuffer = channel.map(mode, 0L, size == -1L ? channel.size() : size);
            return mappedByteBuffer;
        }
    }

    public static String simplifyPath(String pathname) {
        Preconditions.checkNotNull(pathname);
        if (pathname.length() == 0) {
            return ".";
        }
        Iterable<String> components2 = Splitter.on('/').omitEmptyStrings().split(pathname);
        ArrayList<String> path = new ArrayList<String>();
        Iterator<String> iterator2 = components2.iterator();
        block8: while (iterator2.hasNext()) {
            String component;
            switch (component = iterator2.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (path.size() > 0 && !((String)path.get(path.size() - 1)).equals("..")) {
                        path.remove(path.size() - 1);
                        continue block8;
                    }
                    path.add("..");
                    continue block8;
                }
            }
            path.add(component);
        }
        String result2 = Joiner.on('/').join(path);
        if (pathname.charAt(0) == '/') {
            result2 = "/" + result2;
        }
        while (result2.startsWith("/../")) {
            result2 = result2.substring(3);
        }
        if (result2.equals("/..")) {
            result2 = "/";
        } else if ("".equals(result2)) {
            result2 = ".";
        }
        return result2;
    }

    public static String getFileExtension(String fullName) {
        Preconditions.checkNotNull(fullName);
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(String file2) {
        Preconditions.checkNotNull(file2);
        String fileName = new File(file2).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    private static enum FilePredicate implements Predicate<File>
    {
        IS_DIRECTORY{

            @Override
            public boolean apply(File file2) {
                return file2.isDirectory();
            }

            public String toString() {
                return "Files.isDirectory()";
            }
        }
        ,
        IS_FILE{

            @Override
            public boolean apply(File file2) {
                return file2.isFile();
            }

            public String toString() {
                return "Files.isFile()";
            }
        };

    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file2, FileWriteMode ... modes) {
            this.file = Preconditions.checkNotNull(file2);
            this.modes = ImmutableSet.copyOf(modes);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            return "Files.asByteSink(" + this.file + ", " + this.modes + ")";
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file2) {
            this.file = Preconditions.checkNotNull(file2);
        }

        @Override
        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public long size() throws IOException {
            if (!this.file.isFile()) {
                throw new FileNotFoundException(this.file.toString());
            }
            return this.file.length();
        }

        @Override
        public byte[] read() throws IOException {
            try (Closer closer = Closer.create();){
                FileInputStream in = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray(in, in.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            return "Files.asByteSource(" + this.file + ")";
        }
    }
}

