/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.zip;

import java.math.BigInteger;

public final class ZipUInt64 {
    private static final int BYTE_1 = 1;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private static final int BYTE_2 = 2;
    private static final int BYTE_2_MASK = 0xFF0000;
    private static final int BYTE_2_SHIFT = 16;
    private static final int BYTE_3 = 3;
    private static final long BYTE_3_MASK = 0xFF000000L;
    private static final int BYTE_3_SHIFT = 24;
    private static final int BYTE_4 = 4;
    private static final long BYTE_4_MASK = 0xFF00000000L;
    private static final int BYTE_4_SHIFT = 32;
    private static final int BYTE_5 = 5;
    private static final long BYTE_5_MASK = 0xFF0000000000L;
    private static final int BYTE_5_SHIFT = 40;
    private static final int BYTE_6 = 6;
    private static final long BYTE_6_MASK = 0xFF000000000000L;
    private static final int BYTE_6_SHIFT = 48;
    private static final int BYTE_7 = 7;
    private static final long BYTE_7_MASK = 0x7F00000000000000L;
    private static final int BYTE_7_SHIFT = 56;
    private static final int LEFTMOST_BIT_SHIFT = 63;
    private static final byte LEFTMOST_BIT = -128;
    static final int BYTE_MASK = 255;
    private final BigInteger value;

    public ZipUInt64(long value2) {
        this(BigInteger.valueOf(value2));
    }

    public ZipUInt64(BigInteger value2) {
        this.value = value2;
    }

    public ZipUInt64(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipUInt64(byte[] bytes, int offset) {
        this.value = ZipUInt64.getValue(bytes, offset);
    }

    public byte[] getBytes() {
        return ZipUInt64.getBytes(this.value);
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static byte[] getBytes(long value2) {
        return ZipUInt64.getBytes(BigInteger.valueOf(value2));
    }

    public static byte[] getBytes(BigInteger value2) {
        byte[] result2 = new byte[8];
        long val = value2.longValue();
        result2[0] = (byte)(val & 0xFFL);
        result2[1] = (byte)((val & 0xFF00L) >> 8);
        result2[2] = (byte)((val & 0xFF0000L) >> 16);
        result2[3] = (byte)((val & 0xFF000000L) >> 24);
        result2[4] = (byte)((val & 0xFF00000000L) >> 32);
        result2[5] = (byte)((val & 0xFF0000000000L) >> 40);
        result2[6] = (byte)((val & 0xFF000000000000L) >> 48);
        result2[7] = (byte)((val & 0x7F00000000000000L) >> 56);
        if (value2.testBit(63)) {
            result2[7] = (byte)(result2[7] | 0xFFFFFF80);
        }
        return result2;
    }

    public static long getLongValue(byte[] bytes, int offset) {
        return ZipUInt64.getValue(bytes, offset).longValue();
    }

    public static BigInteger getValue(byte[] bytes, int offset) {
        long value2 = (long)bytes[offset + 7] << 56 & 0x7F00000000000000L;
        value2 += (long)bytes[offset + 6] << 48 & 0xFF000000000000L;
        value2 += (long)bytes[offset + 5] << 40 & 0xFF0000000000L;
        value2 += (long)bytes[offset + 4] << 32 & 0xFF00000000L;
        value2 += (long)bytes[offset + 3] << 24 & 0xFF000000L;
        value2 += (long)bytes[offset + 2] << 16 & 0xFF0000L;
        value2 += (long)bytes[offset + 1] << 8 & 0xFF00L;
        BigInteger val = BigInteger.valueOf(value2 += (long)bytes[offset] & 0xFFL);
        return (bytes[offset + 7] & 0xFFFFFF80) == -128 ? val.setBit(63) : val;
    }

    public static long getLongValue(byte[] bytes) {
        return ZipUInt64.getLongValue(bytes, 0);
    }

    public static BigInteger getValue(byte[] bytes) {
        return ZipUInt64.getValue(bytes, 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipUInt64)) {
            return false;
        }
        return this.value.equals(((ZipUInt64)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ZipInt64: " + this.value;
    }
}

