/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/GradleCompatibilityCheck;", "", "()V", "minSupportedGradleVersion", "Lorg/gradle/util/GradleVersion;", "kotlin.jvm.PlatformType", "minSupportedGradleVersionString", "", "runGradleCompatibilityCheck", "", "Lorg/gradle/api/Project;", "gradleVersionProvider", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/GradleCompatibilityCheck$CurrentGradleVersionProvider;", "CurrentGradleVersionProvider", "DefaultCurrentGradleVersionProvider", "kotlin-gradle-plugin_common"})
public final class GradleCompatibilityCheck {
    @NotNull
    public static final GradleCompatibilityCheck INSTANCE = new GradleCompatibilityCheck();
    @NotNull
    public static final String minSupportedGradleVersionString = "7.6.3";
    private static final GradleVersion minSupportedGradleVersion = GradleVersion.version((String)"7.6.3");

    private GradleCompatibilityCheck() {
    }

    public final void runGradleCompatibilityCheck(@NotNull Project $this$runGradleCompatibilityCheck, @NotNull CurrentGradleVersionProvider gradleVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$runGradleCompatibilityCheck, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gradleVersionProvider, (String)"gradleVersionProvider");
        GradleVersion currentVersion = gradleVersionProvider.get();
        if (gradleVersionProvider.get().compareTo(minSupportedGradleVersion) < 0) {
            GradleVersion gradleVersion = minSupportedGradleVersion;
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"minSupportedGradleVersion");
            KotlinToolingDiagnosticsCollectorKt.reportDiagnosticOncePerBuild$default($this$runGradleCompatibilityCheck, KotlinToolingDiagnostics.IncompatibleGradleVersionTooLowFatalError.INSTANCE.invoke(currentVersion, gradleVersion), null, 2, null);
        }
    }

    public static /* synthetic */ void runGradleCompatibilityCheck$default(GradleCompatibilityCheck gradleCompatibilityCheck, Project project, CurrentGradleVersionProvider currentGradleVersionProvider, int n, Object object) {
        if ((n & 1) != 0) {
            currentGradleVersionProvider = DefaultCurrentGradleVersionProvider.INSTANCE;
        }
        gradleCompatibilityCheck.runGradleCompatibilityCheck(project, currentGradleVersionProvider);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/GradleCompatibilityCheck$CurrentGradleVersionProvider;", "", "get", "Lorg/gradle/util/GradleVersion;", "kotlin-gradle-plugin_common"})
    public static interface CurrentGradleVersionProvider {
        @NotNull
        public GradleVersion get();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/GradleCompatibilityCheck$DefaultCurrentGradleVersionProvider;", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/GradleCompatibilityCheck$CurrentGradleVersionProvider;", "()V", "get", "Lorg/gradle/util/GradleVersion;", "kotlin-gradle-plugin_common"})
    public static final class DefaultCurrentGradleVersionProvider
    implements CurrentGradleVersionProvider {
        @NotNull
        public static final DefaultCurrentGradleVersionProvider INSTANCE = new DefaultCurrentGradleVersionProvider();

        private DefaultCurrentGradleVersionProvider() {
        }

        @Override
        @NotNull
        public GradleVersion get() {
            GradleVersion gradleVersion = GradleVersion.current();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"current()");
            return gradleVersion;
        }
    }
}

