/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.RenderReportedDiagnosticsKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptions;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptionsKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnosticsParameters;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J.\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u00052\f\b\u0002\u0010\u0018\u001a\u00060\bj\u0002`\u000eJ.\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u00052\f\b\u0002\u0010\u0018\u001a\u00060\bj\u0002`\u000eJ6\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u00052\f\b\u0002\u0010\u0018\u001a\u00060\bj\u0002`\u000eJ\u0006\u0010\u001f\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\b\u0012\u00060\bj\u0002`\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\bj\u0002`\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "isTransparent", "", "rawDiagnosticsFromProject", "", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/GradleProjectPath;", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "reportedIds", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticId;", "getDiagnosticsForProject", "", "project", "Lorg/gradle/api/Project;", "handleDiagnostic", "", "diagnostic", "report", "reportOnce", "key", "task", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnostics;", "from", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnosticsParameters;", "logger", "Lorg/gradle/api/logging/Logger;", "switchToTransparentMode", "kotlin-gradle-plugin_common"})
public abstract class KotlinToolingDiagnosticsCollector
implements BuildService<BuildServiceParameters.None> {
    private volatile boolean isTransparent;
    @NotNull
    private final Map<String, List<ToolingDiagnostic>> rawDiagnosticsFromProject = new ConcurrentHashMap();
    @NotNull
    private final Set<String> reportedIds;

    public KotlinToolingDiagnosticsCollector() {
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(ConcurrentHashMap())");
        this.reportedIds = set2;
    }

    @NotNull
    public final Collection<ToolingDiagnostic> getDiagnosticsForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<ToolingDiagnostic> list = this.rawDiagnosticsFromProject.get(project.getPath());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    public final void report(@NotNull Project project, @NotNull ToolingDiagnostic diagnostic, boolean reportOnce, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.reportedIds.add(key) || !reportOnce) {
            this.handleDiagnostic(project, diagnostic);
        }
    }

    public static /* synthetic */ void report$default(KotlinToolingDiagnosticsCollector kotlinToolingDiagnosticsCollector, Project project, ToolingDiagnostic toolingDiagnostic, boolean bl, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = toolingDiagnostic.getId();
        }
        kotlinToolingDiagnosticsCollector.report(project, toolingDiagnostic, bl, string2);
    }

    public final void report(@NotNull UsesKotlinToolingDiagnostics task2, @NotNull ToolingDiagnostic diagnostic, boolean reportOnce, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        UsesKotlinToolingDiagnosticsParameters usesKotlinToolingDiagnosticsParameters = task2;
        Logger logger = task2.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"task.logger");
        this.report(usesKotlinToolingDiagnosticsParameters, logger, diagnostic, reportOnce, key);
    }

    public static /* synthetic */ void report$default(KotlinToolingDiagnosticsCollector kotlinToolingDiagnosticsCollector, UsesKotlinToolingDiagnostics usesKotlinToolingDiagnostics, ToolingDiagnostic toolingDiagnostic, boolean bl, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = toolingDiagnostic.getId();
        }
        kotlinToolingDiagnosticsCollector.report(usesKotlinToolingDiagnostics, toolingDiagnostic, bl, string2);
    }

    public final void report(@NotNull UsesKotlinToolingDiagnosticsParameters from2, @NotNull Logger logger, @NotNull ToolingDiagnostic diagnostic, boolean reportOnce, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.reportedIds.add(key) || !reportOnce) {
            ToolingDiagnosticRenderingOptions options = (ToolingDiagnosticRenderingOptions)from2.getDiagnosticRenderingOptions().get();
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"options");
            if (!ToolingDiagnosticRenderingOptionsKt.isSuppressed(diagnostic, options)) {
                RenderReportedDiagnosticsKt.renderReportedDiagnostic(diagnostic, logger, options);
            }
        }
    }

    public static /* synthetic */ void report$default(KotlinToolingDiagnosticsCollector kotlinToolingDiagnosticsCollector, UsesKotlinToolingDiagnosticsParameters usesKotlinToolingDiagnosticsParameters, Logger logger, ToolingDiagnostic toolingDiagnostic, boolean bl, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string2 = toolingDiagnostic.getId();
        }
        kotlinToolingDiagnosticsCollector.report(usesKotlinToolingDiagnosticsParameters, logger, toolingDiagnostic, bl, string2);
    }

    public final void switchToTransparentMode() {
        this.isTransparent = true;
    }

    private final void handleDiagnostic(Project project, ToolingDiagnostic diagnostic) {
        ToolingDiagnosticRenderingOptions options = ToolingDiagnosticRenderingOptions.Companion.forProject(project);
        if (ToolingDiagnosticRenderingOptionsKt.isSuppressed(diagnostic, options)) {
            return;
        }
        if (this.isTransparent) {
            Logger logger = project.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
            RenderReportedDiagnosticsKt.renderReportedDiagnostic(diagnostic, logger, options);
            return;
        }
        this.rawDiagnosticsFromProject.compute(project.getPath(), new BiFunction(diagnostic){
            final /* synthetic */ ToolingDiagnostic $diagnostic;
            {
                this.$diagnostic = $diagnostic;
            }

            public final List<ToolingDiagnostic> apply(String string2, List<ToolingDiagnostic> previousListIfAny) {
                List<ToolingDiagnostic> list;
                Intrinsics.checkNotNullParameter((Object)string2, (String)"<anonymous parameter 0>");
                List<ToolingDiagnostic> list2 = previousListIfAny;
                if (list2 != null) {
                    List<ToolingDiagnostic> list3 = list2;
                    ToolingDiagnostic toolingDiagnostic = this.$diagnostic;
                    List<ToolingDiagnostic> $this$apply_u24lambda_u240 = list3;
                    boolean bl = false;
                    $this$apply_u24lambda_u240.add(toolingDiagnostic);
                    list = list3;
                } else {
                    Object[] objectArray = new ToolingDiagnostic[]{this.$diagnostic};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                }
                return list;
            }
        });
        if (diagnostic.getSeverity() == ToolingDiagnostic.Severity.FATAL) {
            throw RenderReportedDiagnosticsKt.createAnExceptionForFatalDiagnostic(diagnostic, options);
        }
    }
}

