/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmDependency;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJsonKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"FILE_VERSION_PREFIX", "", "directoryNpmDependency", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmDependency;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "scope", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmDependency$Scope;", "name", "directory", "Ljava/io/File;", "fileVersion", "moduleName", "isFileVersion", "", "kotlin-gradle-plugin_common"})
public final class NpmDependencyKt {
    @NotNull
    public static final String FILE_VERSION_PREFIX = "file:";

    @NotNull
    public static final NpmDependency directoryNpmDependency(@NotNull ObjectFactory objectFactory, @NotNull NpmDependency.Scope scope, @NotNull String name2, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!directory.isDirectory()) {
            boolean bl = false;
            String string2 = "Dependency on local path should point on directory but " + directory + " found";
            throw new IllegalStateException(string2.toString());
        }
        return new NpmDependency(objectFactory, scope, name2, NpmDependencyKt.fileVersion(directory));
    }

    public static final boolean isFileVersion(@NotNull String $this$isFileVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileVersion, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isFileVersion, (String)FILE_VERSION_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String fileVersion(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return FILE_VERSION_PREFIX + directory.getCanonicalPath();
    }

    @NotNull
    public static final String moduleName(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File packageJson2 = FilesKt.resolve((File)directory, (String)"package.json");
        if (packageJson2.isFile()) {
            PackageJson packageJson3 = PackageJsonKt.fromSrcPackageJson(packageJson2);
            Intrinsics.checkNotNull((Object)packageJson3);
            return packageJson3.getName();
        }
        String string2 = directory.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"directory.name");
        return string2;
    }
}

