/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.annotations.J2ktIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.BiMap;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMap;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingMapEntry;
import org.jetbrains.kotlin.com.google.common.collect.ForwardingSet;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.NullnessCasts;
import org.jetbrains.kotlin.com.google.common.collect.ParametricNullness;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.concurrent.LazyInit;
import org.jetbrains.kotlin.com.google.j2objc.annotations.RetainedWith;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Map<K, V> delegate;
    @RetainedWith
    transient AbstractBiMap<V, K> inverse;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySet;
    @LazyInit
    @CheckForNull
    private transient Set<V> valueSet;
    @LazyInit
    @CheckForNull
    private transient Set<Map.Entry<K, V>> entrySet;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    AbstractBiMap(Map<K, V> forward, Map<V, K> backward) {
        this.setDelegates(forward, backward);
    }

    private AbstractBiMap(Map<K, V> backward, AbstractBiMap<V, K> forward) {
        this.delegate = backward;
        this.inverse = forward;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    K checkKey(@ParametricNullness K key) {
        return key;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    V checkValue(@ParametricNullness V value2) {
        return value2;
    }

    void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        Preconditions.checkState(this.delegate == null);
        Preconditions.checkState(this.inverse == null);
        Preconditions.checkArgument(forward.isEmpty());
        Preconditions.checkArgument(backward.isEmpty());
        Preconditions.checkArgument(forward != backward);
        this.delegate = forward;
        this.inverse = this.makeInverse(backward);
    }

    AbstractBiMap<V, K> makeInverse(Map<V, K> backward) {
        return new Inverse<V, K>(backward, this);
    }

    void setInverse(AbstractBiMap<V, K> inverse) {
        this.inverse = inverse;
    }

    @Override
    public boolean containsValue(@CheckForNull Object value2) {
        return this.inverse.containsKey(value2);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K key, @ParametricNullness V value2) {
        return this.putInBothMaps(key, value2, false);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V forcePut(@ParametricNullness K key, @ParametricNullness V value2) {
        return this.putInBothMaps(key, value2, true);
    }

    @CheckForNull
    private V putInBothMaps(@ParametricNullness K key, @ParametricNullness V value2, boolean force) {
        this.checkKey(key);
        this.checkValue(value2);
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equal(value2, this.get(key))) {
            return value2;
        }
        if (force) {
            this.inverse().remove(value2);
        } else {
            Preconditions.checkArgument(!this.containsValue(value2), "value already present: %s", value2);
        }
        V oldValue = this.delegate.put(key, value2);
        this.updateInverseMap(key, containedKey, oldValue, value2);
        return oldValue;
    }

    private void updateInverseMap(@ParametricNullness K key, boolean containedKey, @CheckForNull V oldValue, @ParametricNullness V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(NullnessCasts.uncheckedCastNullableTToT(oldValue));
        }
        this.inverse.delegate.put(newValue, key);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object key) {
        return this.containsKey(key) ? (V)this.removeFromBothMaps(key) : null;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    private V removeFromBothMaps(@CheckForNull Object key) {
        V oldValue = NullnessCasts.uncheckedCastNullableTToT(this.delegate.remove(key));
        this.removeFromInverseMap(oldValue);
        return oldValue;
    }

    private void removeFromInverseMap(@ParametricNullness V oldValue) {
        this.inverse.delegate.remove(oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry2 : map.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.delegate.replaceAll(function);
        this.inverse.delegate.clear();
        Map.Entry<K, V> broken = null;
        Iterator<Map.Entry<K, V>> itr = this.delegate.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<K, V> entry2 = itr.next();
            K k = entry2.getKey();
            V v = entry2.getValue();
            V conflict = this.inverse.delegate.putIfAbsent(v, k);
            if (conflict == null) continue;
            broken = entry2;
            itr.remove();
        }
        if (broken != null) {
            throw new IllegalArgumentException("value already present: " + broken.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public Set<K> keySet() {
        KeySet result2 = this.keySet;
        return result2 == null ? (this.keySet = new KeySet()) : result2;
    }

    @Override
    public Set<V> values() {
        ValueSet result2 = this.valueSet;
        return result2 == null ? (this.valueSet = new ValueSet()) : result2;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet result2 = this.entrySet;
        return result2 == null ? (this.entrySet = new EntrySet()) : result2;
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        final Iterator<Map.Entry<K, V>> iterator2 = this.delegate.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){
            @CheckForNull
            Map.Entry<K, V> entry;
            final /* synthetic */ AbstractBiMap this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)iterator2.next();
                return this.this$0.new BiMapEntry(this.entry);
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("no calls to next() since the last call to remove()");
                }
                Object value2 = this.entry.getValue();
                iterator2.remove();
                this.this$0.removeFromInverseMap(value2);
                this.entry = null;
            }
        };
    }

    static class Inverse<K, V>
    extends AbstractBiMap<K, V> {
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        Inverse(Map<K, V> backward, AbstractBiMap<V, K> forward) {
            super(backward, forward);
        }

        @Override
        @ParametricNullness
        K checkKey(@ParametricNullness K key) {
            return this.inverse.checkValue(key);
        }

        @Override
        @ParametricNullness
        V checkValue(@ParametricNullness V value2) {
            return this.inverse.checkKey(value2);
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(this.inverse());
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.setInverse((AbstractBiMap)java.util.Objects.requireNonNull(stream.readObject()));
        }

        @GwtIncompatible
        @J2ktIncompatible
        Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class KeySet
    extends ForwardingSet<K> {
        private KeySet() {
        }

        @Override
        protected Set<K> delegate() {
            return AbstractBiMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(@CheckForNull Object key) {
            if (!this.contains(key)) {
                return false;
            }
            AbstractBiMap.this.removeFromBothMaps(key);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> keysToRemove) {
            return this.standardRemoveAll(keysToRemove);
        }

        @Override
        public boolean retainAll(Collection<?> keysToRetain) {
            return this.standardRetainAll(keysToRetain);
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(AbstractBiMap.this.entrySet().iterator());
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = AbstractBiMap.this.inverse.keySet();
        }

        @Override
        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(AbstractBiMap.this.entrySet().iterator());
        }

        @Override
        public @Nullable Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array2) {
            return this.standardToArray(array2);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.this.delegate.entrySet();
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(@CheckForNull Object object) {
            if (!this.esDelegate.contains(object) || !(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry2 = (Map.Entry)object;
            AbstractBiMap.this.inverse.delegate.remove(entry2.getValue());
            this.esDelegate.remove(entry2);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractBiMap.this.entrySetIterator();
        }

        @Override
        public @Nullable Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array2) {
            return this.standardToArray(array2);
        }

        @Override
        public boolean contains(@CheckForNull Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.standardContainsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.standardRemoveAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.standardRetainAll(c);
        }
    }

    class BiMapEntry
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        BiMapEntry(Map.Entry<K, V> delegate2) {
            this.delegate = delegate2;
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public V setValue(V value2) {
            AbstractBiMap.this.checkValue(value2);
            Preconditions.checkState(AbstractBiMap.this.entrySet().contains(this), "entry no longer in map");
            if (Objects.equal(value2, this.getValue())) {
                return value2;
            }
            Preconditions.checkArgument(!AbstractBiMap.this.containsValue(value2), "value already present: %s", value2);
            Object oldValue = this.delegate.setValue(value2);
            Preconditions.checkState(Objects.equal(value2, AbstractBiMap.this.get(this.getKey())), "entry no longer in map");
            AbstractBiMap.this.updateInverseMap(this.getKey(), true, oldValue, value2);
            return oldValue;
        }
    }
}

