/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.execution.Platform;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;

public final class CommandLineUtil {
    private static final char INESCAPABLE_QUOTE = '\uefef';
    private static final Pattern WIN_BACKSLASHES_PRECEDING_QUOTE = Pattern.compile("(\\\\+)(?=\"|$)");
    private static final Pattern WIN_CARET_SPECIAL = Pattern.compile("[&<>()@^|!%]");
    private static final Pattern WIN_QUOTE_SPECIAL = Pattern.compile("[ \t\"*?\\[{}~()']");
    private static final Pattern WIN_QUIET_COMMAND = Pattern.compile("((?:@\\s*)++)(.*)", 2);
    private static final String SHELL_WHITELIST_CHARACTERS = "-._/@=";
    private static final char Q = '\"';
    private static final String QQ = "\"\"";

    @NotNull
    public static String specialQuote(@NotNull String parameter) {
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(0);
        }
        String string2 = CommandLineUtil.quote(parameter, '\uefef');
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull @NotNull List<@NotNull String> command) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(2);
        }
        assert (!command.isEmpty());
        return CommandLineUtil.toCommandLine(command.get(0), command.subList(1, command.size()));
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull @NotNull List<@NotNull String> parameters) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            CommandLineUtil.$$$reportNull$$$0(4);
        }
        return CommandLineUtil.toCommandLine(command, parameters, Platform.current());
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull @NotNull List<@NotNull String> parameters, @NotNull Platform platform) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            CommandLineUtil.$$$reportNull$$$0(6);
        }
        if (platform == null) {
            CommandLineUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> commandLine = new ArrayList<String>(parameters.size() + 1);
        commandLine.add(FileUtilRt.toSystemDependentName(command, platform.fileSeparator));
        if (platform != Platform.WINDOWS) {
            for (String parameter : parameters) {
                if (CommandLineUtil.isQuoted(parameter, '\uefef')) {
                    parameter = CommandLineUtil.quote(StringUtilRt.unquoteString(parameter, '\uefef'), '\"');
                }
                commandLine.add(parameter);
            }
        } else {
            CommandLineUtil.addToWindowsCommandLine(command, parameters, commandLine);
        }
        ArrayList<String> arrayList = commandLine;
        if (arrayList == null) {
            CommandLineUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void addToWindowsCommandLine(@NotNull String command, @NotNull @NotNull List<@NotNull String> parameters, @NotNull @NotNull List<? super @NotNull String> commandLine) {
        if (command == null) {
            CommandLineUtil.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            CommandLineUtil.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            CommandLineUtil.$$$reportNull$$$0(11);
        }
        boolean isCmdParam = CommandLineUtil.isWinShell(command);
        int cmdInvocationDepth = CommandLineUtil.isWinShellScript(command) ? 2 : (isCmdParam ? 1 : 0);
        QuoteFlag quoteFlag = new QuoteFlag(false);
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            boolean inescapableQuoting;
            String parameter = parameters.get(i2);
            boolean bl = inescapableQuoting = !(parameter = StringUtilRt.unquoteString(parameter, '\uefef')).equals(parameters.get(i2));
            if (parameter.isEmpty()) {
                commandLine.add(QQ);
                continue;
            }
            if (isCmdParam && parameter.startsWith("/") && parameter.length() == 2) {
                commandLine.add(parameter);
                continue;
            }
            String parameterPrefix = "";
            if (isCmdParam) {
                Matcher m = WIN_QUIET_COMMAND.matcher(parameter);
                if (m.matches()) {
                    parameterPrefix = m.group(1);
                    parameter = m.group(2);
                }
                if (parameter.equalsIgnoreCase("echo")) {
                    String parametersJoin = String.join((CharSequence)" ", parameters.subList(i2, parameters.size()));
                    quoteFlag.toggle();
                    parameter = CommandLineUtil.escapeParameter(parametersJoin, quoteFlag, cmdInvocationDepth, false);
                    commandLine.add(parameter);
                    break;
                }
                if (!parameter.equalsIgnoreCase("call") && ((isCmdParam = CommandLineUtil.isWinShell(parameter)) || CommandLineUtil.isWinShellScript(parameter))) {
                    ++cmdInvocationDepth;
                }
            }
            parameter = cmdInvocationDepth > 0 && !isCmdParam || inescapableQuoting ? CommandLineUtil.escapeParameter(parameter, quoteFlag, cmdInvocationDepth, !inescapableQuoting) : CommandLineUtil.backslashEscapeQuotes(parameter);
            commandLine.add(parameterPrefix.isEmpty() ? parameter : parameterPrefix + parameter);
        }
    }

    private static String escapeParameter(String s, QuoteFlag quoteFlag, int cmdInvocationDepth, boolean escapeQuotingInside) {
        String escapingCarets = StringUtil.repeatSymbol('^', (1 << cmdInvocationDepth) - 1);
        return escapeQuotingInside ? CommandLineUtil.quoteEscape(s, quoteFlag, escapingCarets) : CommandLineUtil.caretEscape(s, quoteFlag, escapingCarets);
    }

    private static String caretEscape(String s, QuoteFlag quoteFlag, String escapingCarets) {
        StringBuilder sb = new StringBuilder().append('\"');
        quoteFlag.toggle();
        int lastPos = 0;
        Matcher m = WIN_CARET_SPECIAL.matcher(s);
        while (m.find()) {
            quoteFlag.update(s, lastPos, m.start());
            sb.append(s, lastPos, m.start());
            if (!quoteFlag.enabled) {
                sb.append(escapingCarets);
            }
            sb.append(m.group());
            lastPos = m.end();
        }
        quoteFlag.update(s, lastPos, s.length());
        sb.append(s, lastPos, s.length());
        quoteFlag.toggle();
        return sb.append('\"').toString();
    }

    private static String quoteEscape(String s, QuoteFlag quoteFlag, String escapingCarets) {
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        Matcher m = WIN_CARET_SPECIAL.matcher(s);
        while (m.find()) {
            quoteFlag.update(s, lastPos, m.start());
            CommandLineUtil.appendQuoted(sb, s.substring(lastPos, m.start()));
            String specialText = m.group();
            boolean isCaret = specialText.equals("^");
            if (isCaret) {
                specialText = escapingCarets + specialText;
            }
            if (isCaret == quoteFlag.enabled) {
                CommandLineUtil.appendQuoted(sb, specialText);
            } else {
                sb.append(specialText);
            }
            lastPos = m.end();
        }
        quoteFlag.update(s, lastPos, s.length());
        CommandLineUtil.appendQuoted(sb, s.substring(lastPos));
        if (!CommandLineUtil.isQuoted(sb, '\"') && StringUtil.indexOfAny(sb, " \t") >= 0) {
            if (sb.charAt(0) != '\"') {
                sb.insert(0, QQ);
            }
            if (sb.charAt(sb.length() - 1) != '\"') {
                sb.append(QQ);
            }
        }
        return sb.toString();
    }

    private static void appendQuoted(StringBuilder sb, String s) {
        int numTrailingBackslashes;
        if (s.isEmpty()) {
            return;
        }
        if (WIN_CARET_SPECIAL.matcher(s = CommandLineUtil.backslashEscapeQuotes(s)).find()) {
            s = CommandLineUtil.quote(s, '\"');
        }
        if ((numTrailingBackslashes = CommandLineUtil.removeClosingQuote(sb)) < 0) {
            sb.append(s);
        } else {
            if (WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s = StringUtilRt.unquoteString(s, '\"')).matches()) {
                StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes);
            }
            sb.append(s).append('\"');
        }
    }

    private static String backslashEscapeQuotes(String s) {
        assert (!s.isEmpty());
        String result2 = WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s).replaceAll("$1$1").replace("\"", "\\\"");
        if (!result2.equals(s) || WIN_QUOTE_SPECIAL.matcher(s).find()) {
            result2 = CommandLineUtil.quote(result2, '\"');
        }
        return result2;
    }

    private static int removeClosingQuote(StringBuilder sb) {
        if (sb.length() < 2 || sb.charAt(sb.length() - 1) != '\"') {
            return -1;
        }
        sb.setLength(sb.length() - 1);
        int numTrailingBackslashes = sb.length() - StringUtil.trimTrailing(sb, '\\').length();
        StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2);
        if (numTrailingBackslashes % 2 == 1) {
            StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2 + 1);
            sb.append('\"');
            return -1;
        }
        return numTrailingBackslashes / 2;
    }

    @NotNull
    public static String getWinShellName() {
        return "cmd.exe";
    }

    private static boolean isWinShell(@NonNls String command) {
        return "cmd".equalsIgnoreCase(command) || "cmd.exe".equalsIgnoreCase(command);
    }

    private static boolean isWinShellScript(@NonNls String command) {
        return CommandLineUtil.endsWithIgnoreCase(command, ".cmd") || CommandLineUtil.endsWithIgnoreCase(command, ".bat");
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static String quote(String s, char ch) {
        return !CommandLineUtil.isQuoted(s, ch) ? ch + s + ch : s;
    }

    private static boolean isQuoted(CharSequence s, char ch) {
        return s.length() >= 2 && s.charAt(0) == ch && s.charAt(s.length() - 1) == ch;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeParameterOnWindows(@NotNull String parameter, boolean isWinShell) {
        String result2;
        String s;
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(12);
        }
        if ((s = StringUtil.convertLineSeparators(parameter, "")).isEmpty()) {
            return QQ;
        }
        boolean hadLineBreaks = !s.equals(parameter);
        String string2 = result2 = isWinShell ? CommandLineUtil.escapeParameter(s, new QuoteFlag(hadLineBreaks), 1, true) : CommandLineUtil.backslashEscapeQuotes(s);
        if (hadLineBreaks) {
            result2 = CommandLineUtil.quote(result2, '\"');
        }
        String string3 = result2;
        if (string3 == null) {
            CommandLineUtil.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    public static String extractPresentableName(@NotNull String commandLine) {
        List<Object> args2;
        String execName;
        String executable2;
        List<String> words;
        if (commandLine == null) {
            CommandLineUtil.$$$reportNull$$$0(14);
        }
        if ((words = StringUtil.splitHonorQuotes(executable2 = commandLine.trim(), ' ')).isEmpty()) {
            execName = executable2;
            args2 = Collections.emptyList();
        } else {
            execName = words.get(0);
            args2 = words.subList(1, words.size());
        }
        boolean verbose = Logger.getInstance(CommandLineUtil.class).isDebugEnabled();
        String string2 = verbose ? StringUtil.shortenPathWithEllipsis(execName + " " + String.join((CharSequence)" ", args2), 250) : new File(StringUtil.unquoteString(execName)).getName();
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public static boolean hasWinShellSpecialChars(@NotNull String parameter) {
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(16);
        }
        return WIN_CARET_SPECIAL.matcher(parameter).find();
    }

    @NotNull
    public static String posixQuote(@NotNull String argument) {
        if (argument == null) {
            CommandLineUtil.$$$reportNull$$$0(17);
        }
        String string2 = CommandLineUtil.shouldWrapWithQuotes(argument) ? "'" + StringUtil.replace(argument, "'", "'\"'\"'") + "'" : argument;
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(18);
        }
        return string2;
    }

    private static boolean shouldWrapWithQuotes(@NotNull CharSequence argument) {
        if (argument == null) {
            CommandLineUtil.$$$reportNull$$$0(19);
        }
        if (argument.length() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < argument.length(); ++i2) {
            char c = argument.charAt(i2);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || StringUtil.containsChar(SHELL_WHITELIST_CHARACTERS, c)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/execution/CommandLineUtil";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/execution/CommandLineUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "specialQuote";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeParameterOnWindows";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "posixQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specialQuote";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toCommandLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToWindowsCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escapeParameterOnWindows";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasWinShellSpecialChars";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "posixQuote";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldWrapWithQuotes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class QuoteFlag {
        private boolean enabled;

        private QuoteFlag(boolean value2) {
            this.enabled = value2;
        }

        public void toggle() {
            this.enabled = !this.enabled;
        }

        public void update(CharSequence s, int start2, int end) {
            this.enabled ^= StringUtil.countChars(s, '\"', start2, end, false) % 2 != 0;
        }
    }
}

