/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;

public final class CompositeDisposable
implements Disposable {
    private final List<Disposable> myDisposables = new ArrayList<Disposable>();
    private boolean disposed;
    private boolean isDisposing;

    public void add(@NotNull Disposable disposable) {
        if (disposable == null) {
            CompositeDisposable.$$$reportNull$$$0(0);
        }
        assert (!this.disposed) : "Already disposed";
        this.myDisposables.add(disposable);
    }

    public void remove(@NotNull Disposable disposable) {
        if (disposable == null) {
            CompositeDisposable.$$$reportNull$$$0(1);
        }
        if (!this.isDisposing) {
            for (int i2 = this.myDisposables.size() - 1; i2 >= 0; --i2) {
                Disposable d = this.myDisposables.get(i2);
                if (d != disposable) continue;
                this.myDisposables.remove(i2);
            }
        }
    }

    @Override
    public void dispose() {
        this.isDisposing = true;
        for (int i2 = this.myDisposables.size() - 1; i2 >= 0; --i2) {
            Disposable disposable = this.myDisposables.get(i2);
            Disposer.dispose(disposable);
        }
        this.isDisposing = false;
        this.myDisposables.clear();
        this.disposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "disposable";
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/CompositeDisposable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

