/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.ZipUtil;

public final class MemoryDumpHelper {
    private static final String HOT_SPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Object ourMXBean;
    private static final Method ourDumpHeap;

    public static boolean memoryDumpAvailable() {
        try {
            return ourMXBean != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static synchronized void captureMemoryDump(@NotNull String dumpPath) throws Exception {
        if (dumpPath == null) {
            MemoryDumpHelper.$$$reportNull$$$0(0);
        }
        ourDumpHeap.invoke(ourMXBean, dumpPath, true);
    }

    public static void captureMemoryDumpZipped(@NotNull String zipPath) throws Exception {
        if (zipPath == null) {
            MemoryDumpHelper.$$$reportNull$$$0(1);
        }
        MemoryDumpHelper.captureMemoryDumpZipped(Paths.get(zipPath, new String[0]));
    }

    public static synchronized void captureMemoryDumpZipped(@NotNull Path zipFile) throws Exception {
        if (zipFile == null) {
            MemoryDumpHelper.$$$reportNull$$$0(2);
        }
        File tempFile = new File(FileUtilRt.getTempDirectory(), "heapDump." + UUID.randomUUID() + ".hprof");
        try {
            MemoryDumpHelper.captureMemoryDump(tempFile.getPath());
            ZipUtil.compressFile(tempFile, zipFile.toFile());
        }
        finally {
            FileUtil.delete(tempFile);
        }
    }

    static {
        Method dumpHeap;
        Object mxBean;
        try {
            Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            mxBean = AccessController.doPrivileged(() -> {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> s = server.queryNames(new ObjectName(HOT_SPOT_BEAN_NAME), null);
                Iterator<ObjectName> itr = s.iterator();
                if (itr.hasNext()) {
                    ObjectName name = itr.next();
                    return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                }
                return null;
            });
            dumpHeap = mxBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Throwable t) {
            Logger.getInstance(MemoryDumpHelper.class).info(t.getMessage());
            mxBean = null;
            dumpHeap = null;
        }
        ourMXBean = mxBean;
        ourDumpHeap = dumpHeap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/MemoryDumpHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "captureMemoryDump";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "captureMemoryDumpZipped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

