/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl.forward;

import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.ByteArraySequence;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.forward.ForwardIndex;
import org.jetbrains.kotlin.com.intellij.util.io.ByteSequenceDataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.EnumeratorIntegerDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.MeasurableIndexStore;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMap;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMap;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapBuilder;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;

public final class PersistentMapBasedForwardIndex
implements ForwardIndex,
MeasurableIndexStore {
    @NotNull
    private volatile PersistentMap<Integer, ByteArraySequence> myPersistentMap;
    @NotNull
    private final Path myMapFile;
    private final boolean myUseChunks;
    private final boolean myReadOnly;
    @Nullable
    private final StorageLockContext myStorageLockContext;

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean isReadOnly) throws IOException {
        if (mapFile == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(0);
        }
        this(mapFile, true, isReadOnly, null);
    }

    public PersistentMapBasedForwardIndex(@NotNull Path mapFile, boolean useChunks, boolean isReadOnly, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (mapFile == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(1);
        }
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(mapFile, useChunks, isReadOnly, storageLockContext);
        this.myStorageLockContext = storageLockContext;
        this.myMapFile = mapFile;
        this.myUseChunks = useChunks;
        this.myReadOnly = isReadOnly;
    }

    @Override
    @Nullable
    public ByteArraySequence get(@NotNull Integer key) throws IOException {
        if (key == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(2);
        }
        return (ByteArraySequence)this.myPersistentMap.get(key);
    }

    @Override
    public void put(@NotNull Integer key, @Nullable ByteArraySequence value2) throws IOException {
        if (key == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            this.myPersistentMap.remove(key);
        } else {
            this.myPersistentMap.put(key, value2);
        }
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public boolean isDirty() {
        return this.myPersistentMap.isDirty();
    }

    @Override
    public int keysCountApproximately() {
        return MeasurableIndexStore.keysCountApproximatelyIfPossible(this.myPersistentMap);
    }

    @Override
    public void clear() throws IOException {
        this.myPersistentMap.closeAndClean();
        this.myPersistentMap = PersistentMapBasedForwardIndex.createMap(this.myMapFile, this.myUseChunks, this.myReadOnly, this.myStorageLockContext);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }

    public boolean containsMapping(int key) throws IOException {
        return this.myPersistentMap.containsMapping(key);
    }

    public PersistentMap<Integer, ByteArraySequence> getUnderlyingMap() {
        return this.myPersistentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PersistentMap<Integer, ByteArraySequence> createMap(@NotNull Path file2, boolean useChunks, boolean isReadOnly, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (file2 == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(4);
        }
        assert (PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() == null || storageLockContext == null);
        PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(storageLockContext);
        PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = PersistentMapBuilder.newBuilder(file2, EnumeratorIntegerDescriptor.INSTANCE, ByteSequenceDataExternalizer.INSTANCE).hasChunks(useChunks).withReadonly(isReadOnly).build();
        PersistentHashMap<Integer, ByteArraySequence> persistentHashMap2 = persistentHashMap;
        if (persistentHashMap2 == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(5);
        }
        return persistentHashMap2;
        finally {
            PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/forward/PersistentMapBasedForwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/forward/PersistentMapBasedForwardIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

