/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.ir.linkage.partial;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.internal.ir.linkage.partial.PartialLinkageLogLevel;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/linkage/partial/PartialLinkageLogger;", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "logLevel", "Lorg/jetbrains/kotlin/gradle/internal/ir/linkage/partial/PartialLinkageLogLevel;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogLevel;)V", "getMessageCollector", "()Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getLogLevel", "()Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogLevel;", "irLoggerSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "log", "", "message", "", "location", "Lorg/jetbrains/kotlin/gradle/internal/ir/linkage/partial/PartialLinkageLogger$Location;", "Location", "ir.tree"})
public final class PartialLinkageLogger {
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final PartialLinkageLogLevel logLevel;
    @NotNull
    private final CompilerMessageSeverity irLoggerSeverity;

    public PartialLinkageLogger(@NotNull MessageCollector messageCollector, @NotNull PartialLinkageLogLevel logLevel) {
        CompilerMessageSeverity compilerMessageSeverity;
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        this.messageCollector = messageCollector;
        this.logLevel = logLevel;
        switch (WhenMappings.$EnumSwitchMapping$0[this.logLevel.ordinal()]) {
            case 1: {
                compilerMessageSeverity = CompilerMessageSeverity.INFO;
                break;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 3: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.irLoggerSeverity = compilerMessageSeverity;
    }

    @NotNull
    public final MessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    @NotNull
    public final PartialLinkageLogLevel getLogLevel() {
        return this.logLevel;
    }

    public final void log(@NotNull String message2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        String string2 = location.render().append(": ").append(message2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.messageCollector.report(this.irLoggerSeverity, string2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/linkage/partial/PartialLinkageLogger$Location;", "", "moduleName", "", "filePath", "lineNumber", "", "columnNumber", "<init>", "(Ljava/lang/String;Ljava/lang/String;II)V", "getModuleName", "()Ljava/lang/String;", "getFilePath", "getLineNumber", "()I", "getColumnNumber", "render", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "ir.tree"})
    public static final class Location {
        @NotNull
        private final String moduleName;
        @NotNull
        private final String filePath;
        private final int lineNumber;
        private final int columnNumber;

        public Location(@NotNull String moduleName, @NotNull String filePath, int lineNumber, int columnNumber) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.moduleName = moduleName;
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int getColumnNumber() {
            return this.columnNumber;
        }

        @NotNull
        public final StringBuilder render() {
            StringBuilder stringBuilder;
            StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$render_u24lambda_u240.append(this.moduleName);
            if (((CharSequence)this.filePath).length() > 0) {
                $this$render_u24lambda_u240.append(" @ ").append(this.filePath);
                if (this.lineNumber != -1 && this.columnNumber != -1) {
                    $this$render_u24lambda_u240.append(':').append(this.lineNumber).append(':').append(this.columnNumber);
                }
            }
            return stringBuilder;
        }

        @NotNull
        public String toString() {
            String string2 = this.render().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PartialLinkageLogLevel.values().length];
            try {
                nArray[PartialLinkageLogLevel.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PartialLinkageLogLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PartialLinkageLogLevel.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

