/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.ir.util;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFile;
import org.jetbrains.kotlin.gradle.internal.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.gradle.internal.ir.util.IdSignatureRendererKt;
import org.jetbrains.kotlin.gradle.internal.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\n\u001a\u001b\u001c\u001d\u001e\u001f !\"#B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0000H&J\b\u0010\t\u001a\u00020\u0000H&J\b\u0010\n\u001a\u00020\u000bH&J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u0010\u001a\u00020\u000fJ\n\u0010\u0011\u001a\u00020\u0005*\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006\u0082\u0001\t$\r%&'()*+\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "", "<init>", "()V", "isPubliclyVisible", "", "()Z", "isPackageSignature", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "asPublic", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$CommonSignature;", "render", "", "toString", "test", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$Flags;", "flags", "", "hasTopLevel", "getHasTopLevel", "isLocal", "visibleCrossFile", "getVisibleCrossFile", "Flags", "CommonSignature", "CompositeSignature", "AccessorSignature", "FileSignature", "LocalSignature", "SpecialFakeOverrideSignature", "FileLocalSignature", "ScopeLocalDeclaration", "LoweredDeclarationSignature", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$AccessorSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$CompositeSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$FileLocalSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$FileSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$LocalSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$LoweredDeclarationSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$ScopeLocalDeclaration;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$SpecialFakeOverrideSignature;", "ir.tree"})
public abstract class IdSignature {
    private IdSignature() {
    }

    public abstract boolean isPubliclyVisible();

    public boolean isPackageSignature() {
        return false;
    }

    @NotNull
    public abstract IdSignature topLevelSignature();

    @NotNull
    public abstract IdSignature nearestPublicSig();

    @NotNull
    public abstract FqName packageFqName();

    @Nullable
    public CommonSignature asPublic() {
        return null;
    }

    @Deprecated(message="Rendering of signatures has been extracted to IdSignatureRenderer.render()", replaceWith=@ReplaceWith(expression="render()", imports={"org.jetbrains.kotlin.gradle.internal.ir.util.render"}), level=DeprecationLevel.HIDDEN)
    public final /* synthetic */ String render() {
        return IdSignatureRendererKt.render$default(this, null, 1, null);
    }

    @NotNull
    public final String toString() {
        return IdSignatureRendererKt.render$default(this, null, 1, null);
    }

    public final boolean test(@NotNull Flags $this$test) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$test), (String)"<this>");
        return $this$test.decode(this.flags());
    }

    protected long flags() {
        return 0L;
    }

    public boolean getHasTopLevel() {
        return !this.isPackageSignature();
    }

    public boolean isLocal() {
        return !this.isPubliclyVisible();
    }

    public boolean getVisibleCrossFile() {
        return true;
    }

    public /* synthetic */ IdSignature(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0013\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$AccessorSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "propertySignature", "accessorSignature", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$CommonSignature;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;)V", "getPropertySignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getAccessorSignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "isPubliclyVisible", "", "()Z", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "flags", "", "asPublic", "equals", "other", "", "hashCode", "", "ir.tree"})
    public static final class AccessorSignature
    extends IdSignature {
        @NotNull
        private final IdSignature propertySignature;
        @NotNull
        private final CommonSignature accessorSignature;
        private final int hashCode;

        public AccessorSignature(@NotNull IdSignature propertySignature, @NotNull CommonSignature accessorSignature) {
            Intrinsics.checkNotNullParameter((Object)propertySignature, (String)"propertySignature");
            Intrinsics.checkNotNullParameter((Object)accessorSignature, (String)"accessorSignature");
            super(null);
            this.propertySignature = propertySignature;
            this.accessorSignature = accessorSignature;
            this.hashCode = this.accessorSignature.hashCode();
        }

        @NotNull
        public final IdSignature getPropertySignature() {
            return this.propertySignature;
        }

        @NotNull
        public final CommonSignature getAccessorSignature() {
            return this.accessorSignature;
        }

        @Override
        public boolean isPubliclyVisible() {
            return true;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            return this.propertySignature.topLevelSignature();
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.propertySignature.packageFqName();
        }

        @Override
        protected long flags() {
            return this.accessorSignature.getMask();
        }

        @Override
        @NotNull
        public CommonSignature asPublic() {
            return this.accessorSignature;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof AccessorSignature ? Intrinsics.areEqual((Object)this.accessorSignature, (Object)((AccessorSignature)other).accessorSignature) : Intrinsics.areEqual((Object)this.accessorSignature, (Object)other);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nB+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0002\u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020\u0001H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020\u0000H\u0016J\b\u0010&\u001a\u00020\u0006H\u0014J\b\u0010'\u001a\u00020\u0000H\u0016J\u0013\u0010(\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$CommonSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "packageFqName", "", "declarationFqName", "id", "", "mask", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;JLjava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;J)V", "getPackageFqName", "()Ljava/lang/String;", "getDeclarationFqName", "getId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getMask", "()J", "getDescription", "isPubliclyVisible", "", "()Z", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "shortName", "getShortName", "firstNameSegment", "getFirstNameSegment", "nameSegments", "", "getNameSegments", "()Ljava/util/List;", "adaptMask", "old", "topLevelSignature", "isPackageSignature", "nearestPublicSig", "flags", "asPublic", "equals", "other", "", "hashCode", "", "ir.tree"})
    @SourceDebugExtension(value={"SMAP\nIdSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignature.kt\norg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,655:1\n1803#2,3:656\n*S KotlinDebug\n*F\n+ 1 IdSignature.kt\norg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature\n*L\n308#1:656,3\n*E\n"})
    public static final class CommonSignature
    extends IdSignature {
        @NotNull
        private final String packageFqName;
        @NotNull
        private final String declarationFqName;
        @Nullable
        private final Long id;
        private final long mask;
        @Nullable
        private final String description;
        private final int hashCode;

        public CommonSignature(@NotNull String packageFqName, @NotNull String declarationFqName, @Nullable Long id, long mask, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)declarationFqName, (String)"declarationFqName");
            super(null);
            this.packageFqName = packageFqName;
            this.declarationFqName = declarationFqName;
            this.id = id;
            this.mask = mask;
            this.description = description;
            Long l = this.id;
            this.hashCode = ((this.packageFqName.hashCode() * 31 + this.declarationFqName.hashCode()) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + Long.hashCode(this.mask);
        }

        @NotNull
        public final String getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final String getDeclarationFqName() {
            return this.declarationFqName;
        }

        @Nullable
        public final Long getId() {
            return this.id;
        }

        public final long getMask() {
            return this.mask;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @Deprecated(message="When constructing 'CommonSignature', you need to set 'description' to the mangled name from which 'id' was computed, or to null if it's not applicable", level=DeprecationLevel.WARNING)
        public CommonSignature(@NotNull String packageFqName, @NotNull String declarationFqName, @Nullable Long id, long mask) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)declarationFqName, (String)"declarationFqName");
            this(packageFqName, declarationFqName, id, mask, null);
        }

        @Override
        public boolean isPubliclyVisible() {
            return true;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return new FqName(this.packageFqName);
        }

        @NotNull
        public final String getShortName() {
            return StringsKt.substringAfterLast$default((String)this.declarationFqName, (char)'.', null, (int)2, null);
        }

        @NotNull
        public final String getFirstNameSegment() {
            return StringsKt.substringBefore$default((String)this.declarationFqName, (char)'.', null, (int)2, null);
        }

        @NotNull
        public final List<String> getNameSegments() {
            char[] cArray = new char[]{'.'};
            return StringsKt.split$default((CharSequence)this.declarationFqName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        /*
         * WARNING - void declaration
         */
        private final long adaptMask(long old) {
            void $this$fold$iv;
            void initial$iv;
            Iterable iterable = Flags.getEntries();
            long l = 0L;
            long l2 = old;
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void f;
                Flags flags = (Flags)((Object)element$iv);
                void a = accumulator$iv;
                boolean bl = false;
                accumulator$iv = !f.getRecursive() ? a | old & 1L << f.ordinal() : a;
            }
            void var17_12 = accumulator$iv;
            return l2 ^ var17_12;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            if (((CharSequence)this.declarationFqName).length() == 0) {
                boolean bl;
                boolean bl2 = bl = this.id == null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return this;
            }
            List<String> nameSegments = this.getNameSegments();
            long adaptedMask = this.adaptMask(this.mask);
            if (nameSegments.size() == 1 && this.mask == adaptedMask) {
                return this;
            }
            return new CommonSignature(this.packageFqName, (String)CollectionsKt.first(nameSegments), null, adaptedMask, null);
        }

        @Override
        public boolean isPackageSignature() {
            return this.id == null && ((CharSequence)this.declarationFqName).length() == 0;
        }

        @Override
        @NotNull
        public CommonSignature nearestPublicSig() {
            return this;
        }

        @Override
        protected long flags() {
            return this.mask;
        }

        @Override
        @NotNull
        public CommonSignature asPublic() {
            return this;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof CommonSignature && Intrinsics.areEqual((Object)this.packageFqName, (Object)((CommonSignature)other).packageFqName) && Intrinsics.areEqual((Object)this.declarationFqName, (Object)((CommonSignature)other).declarationFqName) && Intrinsics.areEqual((Object)this.id, (Object)((CommonSignature)other).id) && this.mask == ((CommonSignature)other).mask;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\u0001H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$CompositeSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "container", "inner", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/ir/util/IdSignature;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getInner", "isPubliclyVisible", "", "()Z", "isLocal", "visibleCrossFile", "getVisibleCrossFile", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "equals", "other", "", "hashCode", "", "ir.tree"})
    public static final class CompositeSignature
    extends IdSignature {
        @NotNull
        private final IdSignature container;
        @NotNull
        private final IdSignature inner;

        public CompositeSignature(@NotNull IdSignature container, @NotNull IdSignature inner) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            super(null);
            this.container = container;
            this.inner = inner;
        }

        @NotNull
        public final IdSignature getContainer() {
            return this.container;
        }

        @NotNull
        public final IdSignature getInner() {
            return this.inner;
        }

        @Override
        public boolean isPubliclyVisible() {
            return true;
        }

        @Override
        public boolean isLocal() {
            return this.inner.isLocal();
        }

        @Override
        public boolean getVisibleCrossFile() {
            return this.container.getVisibleCrossFile();
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            return this.container instanceof FileSignature ? (IdSignature)new CompositeSignature(this.container, this.inner.topLevelSignature()) : this.container.topLevelSignature();
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this.container instanceof FileSignature ? this.inner.nearestPublicSig() : this.container.nearestPublicSig();
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.container instanceof FileSignature ? this.inner.packageFqName() : this.container.packageFqName();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof CompositeSignature && Intrinsics.areEqual((Object)this.container, (Object)((CompositeSignature)other).container) && Intrinsics.areEqual((Object)this.inner, (Object)((CompositeSignature)other).inner);
        }

        public int hashCode() {
            return this.container.hashCode() * 31 + this.inner.hashCode();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\u0013\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$FileLocalSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "container", "id", "", "description", "", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;JLjava/lang/String;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getId", "()J", "getDescription", "()Ljava/lang/String;", "isPubliclyVisible", "", "()Z", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "visibleCrossFile", "getVisibleCrossFile", "topLevelSignature", "nearestPublicSig", "equals", "other", "", "hashCode", "", "ir.tree"})
    public static final class FileLocalSignature
    extends IdSignature {
        @NotNull
        private final IdSignature container;
        private final long id;
        @Nullable
        private final String description;
        private final int hashCode;

        public FileLocalSignature(@NotNull IdSignature container, long id, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            super(null);
            this.container = container;
            this.id = id;
            this.description = description;
            this.hashCode = this.container.hashCode() * 31 + Long.hashCode(this.id);
        }

        public /* synthetic */ FileLocalSignature(IdSignature idSignature, long l, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(idSignature, l, string2);
        }

        @NotNull
        public final IdSignature getContainer() {
            return this.container;
        }

        public final long getId() {
            return this.id;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @Override
        public boolean isPubliclyVisible() {
            return false;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.container.packageFqName();
        }

        @Override
        public boolean getVisibleCrossFile() {
            return false;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            IdSignature topLevelContainer = this.container.topLevelSignature();
            if (topLevelContainer == this.container && topLevelContainer instanceof CommonSignature && ((CharSequence)((CommonSignature)topLevelContainer).getDeclarationFqName()).length() == 0) {
                return this;
            }
            return topLevelContainer;
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this.container.nearestPublicSig();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof FileLocalSignature && this.id == ((FileLocalSignature)other).id && Intrinsics.areEqual((Object)this.container, (Object)((FileLocalSignature)other).container);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0001H\u0016J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$FileSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "id", "", "fqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "fileName", "", "<init>", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "fileSymbol", "Lorg/jetbrains/kotlin/gradle/internal/ir/symbols/IrFileSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;)V", "getFileName", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "isPubliclyVisible", "()Z", "visibleCrossFile", "getVisibleCrossFile", "isPackageSignature", "topLevelSignature", "nearestPublicSig", "packageFqName", "hasTopLevel", "getHasTopLevel", "ir.tree"})
    public static final class FileSignature
    extends IdSignature {
        @NotNull
        private final Object id;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final String fileName;

        public FileSignature(@NotNull Object id, @NotNull FqName fqName, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            super(null);
            this.id = id;
            this.fqName = fqName;
            this.fileName = fileName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public FileSignature(@NotNull IrFileSymbol fileSymbol) {
            Intrinsics.checkNotNullParameter((Object)fileSymbol, (String)"fileSymbol");
            this(fileSymbol, ((IrFile)fileSymbol.getOwner()).getPackageFqName(), ((IrFile)fileSymbol.getOwner()).getFileEntry().getName());
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof FileSignature && Intrinsics.areEqual((Object)this.id, (Object)((FileSignature)other).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public boolean isPubliclyVisible() {
            return true;
        }

        @Override
        public boolean getVisibleCrossFile() {
            return false;
        }

        @Override
        public boolean isPackageSignature() {
            return true;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            return this;
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            throw new IllegalStateException(("Should not reach here (" + this + ')').toString());
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.fqName;
        }

        @Override
        public boolean getHasTopLevel() {
            return false;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$Flags;", "", "recursive", "", "<init>", "(Ljava/lang/String;IZ)V", "getRecursive", "()Z", "IS_EXPECT", "IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY", "IS_NATIVE_INTEROP_LIBRARY", "IS_SYNTHETIC_JAVA_PROPERTY", "encode", "", "isSet", "decode", "flags", "ir.tree"})
    public static final class Flags
    extends Enum<Flags> {
        private final boolean recursive;
        public static final /* enum */ Flags IS_EXPECT = new Flags(true);
        public static final /* enum */ Flags IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY = new Flags(false);
        public static final /* enum */ Flags IS_NATIVE_INTEROP_LIBRARY = new Flags(true);
        public static final /* enum */ Flags IS_SYNTHETIC_JAVA_PROPERTY = new Flags(false);
        private static final /* synthetic */ Flags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Flags(boolean recursive) {
            this.recursive = recursive;
        }

        public final boolean getRecursive() {
            return this.recursive;
        }

        public final long encode(boolean isSet) {
            return isSet ? 1L << this.ordinal() : 0L;
        }

        public final boolean decode(long flags) {
            return (flags & 1L << this.ordinal()) != 0L;
        }

        public static Flags[] values() {
            return (Flags[])$VALUES.clone();
        }

        public static Flags valueOf(String value2) {
            return Enum.valueOf(Flags.class, value2);
        }

        @NotNull
        public static EnumEntries<Flags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = flagsArray = new Flags[]{Flags.IS_EXPECT, Flags.IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY, Flags.IS_NATIVE_INTEROP_LIBRARY, Flags.IS_SYNTHETIC_JAVA_PROPERTY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$LocalSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "localFqn", "", "hashSig", "", "description", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;)V", "getLocalFqn", "()Ljava/lang/String;", "getHashSig", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getDescription", "isPubliclyVisible", "", "()Z", "isLocal", "index", "", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "equals", "other", "", "hashCode", "ir.tree"})
    public static final class LocalSignature
    extends IdSignature {
        @NotNull
        private final String localFqn;
        @Nullable
        private final Long hashSig;
        @Nullable
        private final String description;

        public LocalSignature(@NotNull String localFqn, @Nullable Long hashSig, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)localFqn, (String)"localFqn");
            super(null);
            this.localFqn = localFqn;
            this.hashSig = hashSig;
            this.description = description;
        }

        @NotNull
        public final String getLocalFqn() {
            return this.localFqn;
        }

        @Nullable
        public final Long getHashSig() {
            return this.hashSig;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @Override
        public boolean isPubliclyVisible() {
            return false;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        public final int index() {
            Long l = this.hashSig;
            if (l == null) {
                throw new IllegalStateException(("Expected index in " + this).toString());
            }
            return (int)l.longValue();
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            throw new IllegalStateException(("Illegal access: Local Sig does not have toplevel (" + this).toString());
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            throw new IllegalStateException(("Illegal access: Local Sig does not have information about its public part (" + this).toString());
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            throw new IllegalStateException(("Illegal access: Local signature does not have package (" + this).toString());
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LocalSignature && Intrinsics.areEqual((Object)this.localFqn, (Object)((LocalSignature)other).localFqn) && Intrinsics.areEqual((Object)this.hashSig, (Object)((LocalSignature)other).hashSig);
        }

        public int hashCode() {
            Long l = this.hashSig;
            return (int)(l != null ? l : 0L) * 31 + this.localFqn.hashCode();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$LoweredDeclarationSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "original", "stage", "", "index", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;II)V", "getOriginal", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getStage", "()I", "getIndex", "isPubliclyVisible", "", "()Z", "hasTopLevel", "getHasTopLevel", "visibleCrossFile", "getVisibleCrossFile", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "equals", "other", "", "hashCode", "ir.tree"})
    public static final class LoweredDeclarationSignature
    extends IdSignature {
        @NotNull
        private final IdSignature original;
        private final int stage;
        private final int index;
        private final int hashCode;

        public LoweredDeclarationSignature(@NotNull IdSignature original, int stage, int index) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            super(null);
            this.original = original;
            this.stage = stage;
            this.index = index;
            this.hashCode = (this.index * 31 + this.stage) * 31 + this.original.hashCode();
        }

        @NotNull
        public final IdSignature getOriginal() {
            return this.original;
        }

        public final int getStage() {
            return this.stage;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        public boolean isPubliclyVisible() {
            return this.original.isPubliclyVisible();
        }

        @Override
        public boolean getHasTopLevel() {
            return true;
        }

        @Override
        public boolean getVisibleCrossFile() {
            return this.original.getVisibleCrossFile();
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            return this;
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this;
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.original.packageFqName();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LoweredDeclarationSignature && Intrinsics.areEqual((Object)this.original, (Object)((LoweredDeclarationSignature)other).original) && this.stage == ((LoweredDeclarationSignature)other).stage && this.index == ((LoweredDeclarationSignature)other).index;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$ScopeLocalDeclaration;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "id", "", "description", "", "<init>", "(ILjava/lang/String;)V", "getId", "()I", "getDescription", "()Ljava/lang/String;", "isPubliclyVisible", "", "()Z", "visibleCrossFile", "getVisibleCrossFile", "hasTopLevel", "getHasTopLevel", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "equals", "other", "", "hashCode", "ir.tree"})
    public static final class ScopeLocalDeclaration
    extends IdSignature {
        private final int id;
        @Nullable
        private final String description;

        public ScopeLocalDeclaration(int id, @Nullable String description) {
            super(null);
            this.id = id;
            this.description = description;
        }

        public /* synthetic */ ScopeLocalDeclaration(int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            this(n, string2);
        }

        public final int getId() {
            return this.id;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @Override
        public boolean isPubliclyVisible() {
            return false;
        }

        @Override
        public boolean getVisibleCrossFile() {
            return false;
        }

        @Override
        public boolean getHasTopLevel() {
            return false;
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            throw new IllegalStateException("Is not supported for Local ID".toString());
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            throw new IllegalStateException("Is not supported for Local ID".toString());
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            throw new IllegalStateException("Is not supported for Local ID".toString());
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ScopeLocalDeclaration && this.id == ((ScopeLocalDeclaration)other).id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0001H\u0016J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$SpecialFakeOverrideSignature;", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "memberSignature", "overriddenSignatures", "", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignature;Ljava/util/List;)V", "getMemberSignature", "()Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getOverriddenSignatures", "()Ljava/util/List;", "isPubliclyVisible", "", "()Z", "asPublic", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature$CommonSignature;", "topLevelSignature", "nearestPublicSig", "packageFqName", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "equals", "other", "", "hashCode", "", "ir.tree"})
    public static final class SpecialFakeOverrideSignature
    extends IdSignature {
        @NotNull
        private final IdSignature memberSignature;
        @NotNull
        private final List<IdSignature> overriddenSignatures;
        private final int hashCode;

        public SpecialFakeOverrideSignature(@NotNull IdSignature memberSignature, @NotNull List<? extends IdSignature> overriddenSignatures) {
            Intrinsics.checkNotNullParameter((Object)memberSignature, (String)"memberSignature");
            Intrinsics.checkNotNullParameter(overriddenSignatures, (String)"overriddenSignatures");
            super(null);
            this.memberSignature = memberSignature;
            this.overriddenSignatures = overriddenSignatures;
            this.hashCode = 31 * this.memberSignature.hashCode() + ((Object)this.overriddenSignatures).hashCode();
        }

        @NotNull
        public final IdSignature getMemberSignature() {
            return this.memberSignature;
        }

        @NotNull
        public final List<IdSignature> getOverriddenSignatures() {
            return this.overriddenSignatures;
        }

        @Override
        public boolean isPubliclyVisible() {
            return this.memberSignature.isPubliclyVisible();
        }

        @Override
        @Nullable
        public CommonSignature asPublic() {
            return this.memberSignature.asPublic();
        }

        @Override
        @NotNull
        public IdSignature topLevelSignature() {
            return this.memberSignature.topLevelSignature();
        }

        @Override
        @NotNull
        public IdSignature nearestPublicSig() {
            return this.memberSignature.isPubliclyVisible() ? (IdSignature)this : this.memberSignature.nearestPublicSig();
        }

        @Override
        @NotNull
        public FqName packageFqName() {
            return this.memberSignature.packageFqName();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.SpecialFakeOverrideSignature");
            SpecialFakeOverrideSignature cfr_ignored_0 = (SpecialFakeOverrideSignature)other;
            if (!Intrinsics.areEqual((Object)this.memberSignature, (Object)((SpecialFakeOverrideSignature)other).memberSignature)) {
                return false;
            }
            return Intrinsics.areEqual(this.overriddenSignatures, ((SpecialFakeOverrideSignature)other).overriddenSignatures);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

