/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.resolve.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.resolve.checkers.EmptyIntersectionTypeInfo;
import org.jetbrains.kotlin.gradle.internal.types.AbstractTypeChecker;
import org.jetbrains.kotlin.gradle.internal.types.EmptyIntersectionTypeKind;
import org.jetbrains.kotlin.gradle.internal.types.TypeCheckerState;
import org.jetbrains.kotlin.gradle.internal.types.model.IntersectionTypeConstructorMarker;
import org.jetbrains.kotlin.gradle.internal.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.gradle.internal.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.gradle.internal.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.gradle.internal.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.gradle.internal.types.model.TypeSystemInferenceExtensionContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a8\u0006\u0017\u00b2\u0006\n\u0010\u0018\u001a\u00020\nX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u0011\u001a\u00020\u0012X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/resolve/checkers/EmptyIntersectionTypeChecker;", "", "<init>", "()V", "computeEmptyIntersectionEmptiness", "Lorg/jetbrains/kotlin/gradle/internal/resolve/checkers/EmptyIntersectionTypeInfo;", "context", "Lorg/jetbrains/kotlin/gradle/internal/types/model/TypeSystemInferenceExtensionContext;", "types", "", "Lorg/jetbrains/kotlin/gradle/internal/types/model/KotlinTypeMarker;", "computeByHavingCommonSubtype", "first", "second", "isSubtypeOfIgnoringArguments", "", "Lorg/jetbrains/kotlin/gradle/internal/types/model/RigidTypeMarker;", "typeCheckerState", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeCheckerState;", "otherConstructorMarker", "Lorg/jetbrains/kotlin/gradle/internal/types/model/TypeConstructorMarker;", "mayCauseEmptyIntersection", "type", "compiler.common", "firstSubstitutedType"})
public final class EmptyIntersectionTypeChecker {
    @NotNull
    public static final EmptyIntersectionTypeChecker INSTANCE = new EmptyIntersectionTypeChecker();

    private EmptyIntersectionTypeChecker() {
    }

    @Nullable
    public final EmptyIntersectionTypeInfo computeEmptyIntersectionEmptiness(@NotNull TypeSystemInferenceExtensionContext context, @NotNull Collection<? extends KotlinTypeMarker> types) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        TypeSystemInferenceExtensionContext $this$computeEmptyIntersectionEmptiness_u24lambda_u242 = context;
        boolean bl = false;
        if (types.isEmpty()) {
            return null;
        }
        List types2 = CollectionsKt.toList((Iterable)types);
        EmptyIntersectionTypeInfo possibleEmptyIntersectionTypeInfo = null;
        int n = ((Collection)types2).size();
        for (int i2 = 0; i2 < n; ++i2) {
            KotlinTypeMarker firstType = (KotlinTypeMarker)types2.get(i2);
            if (!INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, firstType)) continue;
            Lazy firstSubstitutedType$delegate = LazyKt.lazy(() -> EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$2$lambda$0($this$computeEmptyIntersectionEmptiness_u24lambda_u242, firstType));
            int n2 = types2.size();
            for (int j = i2 + 1; j < n2; ++j) {
                EmptyIntersectionTypeInfo typeInfo;
                KotlinTypeMarker secondSubstitutedType;
                KotlinTypeMarker secondType = (KotlinTypeMarker)types2.get(j);
                if (!INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, secondType) || !INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, secondSubstitutedType = $this$computeEmptyIntersectionEmptiness_u24lambda_u242.eraseContainingTypeParameters(secondType)) && !INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$2$lambda$1((Lazy<? extends KotlinTypeMarker>)firstSubstitutedType$delegate)) || INSTANCE.computeByHavingCommonSubtype($this$computeEmptyIntersectionEmptiness_u24lambda_u242, EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$2$lambda$1((Lazy<? extends KotlinTypeMarker>)firstSubstitutedType$delegate), secondSubstitutedType) == null) continue;
                if (typeInfo.getKind().isDefinitelyEmpty()) {
                    return typeInfo;
                }
                if (typeInfo.getKind().isDefinitelyEmpty()) continue;
                possibleEmptyIntersectionTypeInfo = typeInfo;
            }
        }
        return possibleEmptyIntersectionTypeInfo;
    }

    private final EmptyIntersectionTypeInfo computeByHavingCommonSubtype(TypeSystemInferenceExtensionContext $this$computeByHavingCommonSubtype, KotlinTypeMarker first, KotlinTypeMarker second) {
        List expandedTypes = CollectionsKt.plus((Collection)EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded($this$computeByHavingCommonSubtype, first), (Iterable)EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded($this$computeByHavingCommonSubtype, second));
        Lazy typeCheckerState$delegate = LazyKt.lazy(() -> EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$3($this$computeByHavingCommonSubtype));
        EmptyIntersectionTypeInfo possibleEmptyIntersectionKind = null;
        int n = ((Collection)expandedTypes).size();
        for (int i2 = 0; i2 < n; ++i2) {
            KotlinTypeMarker firstType = $this$computeByHavingCommonSubtype.withNullability((KotlinTypeMarker)expandedTypes.get(i2), false);
            TypeConstructorMarker firstTypeConstructor = $this$computeByHavingCommonSubtype.typeConstructor(firstType);
            if (!this.mayCauseEmptyIntersection($this$computeByHavingCommonSubtype, firstType)) continue;
            int n2 = expandedTypes.size();
            for (int j = i2 + 1; j < n2; ++j) {
                KotlinTypeMarker[] kotlinTypeMarkerArray;
                KotlinTypeMarker secondType = $this$computeByHavingCommonSubtype.withNullability((KotlinTypeMarker)expandedTypes.get(j), false);
                TypeConstructorMarker secondTypeConstructor = $this$computeByHavingCommonSubtype.typeConstructor(secondType);
                if (!this.mayCauseEmptyIntersection($this$computeByHavingCommonSubtype, secondType) || $this$computeByHavingCommonSubtype.areEqualTypeConstructors(firstTypeConstructor, secondTypeConstructor) || this.isSubtypeOfIgnoringArguments($this$computeByHavingCommonSubtype.lowerBoundIfFlexible(firstType), EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$4((Lazy<? extends TypeCheckerState>)typeCheckerState$delegate), secondTypeConstructor) || this.isSubtypeOfIgnoringArguments($this$computeByHavingCommonSubtype.lowerBoundIfFlexible(secondType), EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$4((Lazy<? extends TypeCheckerState>)typeCheckerState$delegate), firstTypeConstructor)) continue;
                if (!$this$computeByHavingCommonSubtype.isInterface(firstTypeConstructor) && !$this$computeByHavingCommonSubtype.isInterface(secondTypeConstructor)) {
                    kotlinTypeMarkerArray = new KotlinTypeMarker[]{firstType, secondType};
                    return new EmptyIntersectionTypeInfo(EmptyIntersectionTypeKind.MULTIPLE_CLASSES, kotlinTypeMarkerArray);
                }
                if (!$this$computeByHavingCommonSubtype.isFinalClassConstructor(firstTypeConstructor) && !$this$computeByHavingCommonSubtype.isFinalClassConstructor(secondTypeConstructor)) continue;
                kotlinTypeMarkerArray = new KotlinTypeMarker[]{firstType, secondType};
                possibleEmptyIntersectionKind = new EmptyIntersectionTypeInfo(EmptyIntersectionTypeKind.FINAL_CLASS_AND_INTERFACE, kotlinTypeMarkerArray);
            }
        }
        return possibleEmptyIntersectionKind;
    }

    private final boolean isSubtypeOfIgnoringArguments(RigidTypeMarker $this$isSubtypeOfIgnoringArguments, TypeCheckerState typeCheckerState, TypeConstructorMarker otherConstructorMarker) {
        return !((Collection)AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState, $this$isSubtypeOfIgnoringArguments, otherConstructorMarker)).isEmpty();
    }

    private final boolean mayCauseEmptyIntersection(TypeSystemInferenceExtensionContext $this$mayCauseEmptyIntersection, KotlinTypeMarker type) {
        if ($this$mayCauseEmptyIntersection.isStubType($this$mayCauseEmptyIntersection.lowerBoundIfFlexible(type)) || $this$mayCauseEmptyIntersection.isError(type)) {
            return false;
        }
        TypeConstructorMarker typeConstructor2 = $this$mayCauseEmptyIntersection.typeConstructor(type);
        if (!$this$mayCauseEmptyIntersection.isClassTypeConstructor(typeConstructor2) && !$this$mayCauseEmptyIntersection.isTypeParameterTypeConstructor(typeConstructor2)) {
            return false;
        }
        return !$this$mayCauseEmptyIntersection.isAnyConstructor(typeConstructor2) && !$this$mayCauseEmptyIntersection.isNothingConstructor(typeConstructor2);
    }

    private static final KotlinTypeMarker computeEmptyIntersectionEmptiness$lambda$2$lambda$0(TypeSystemInferenceExtensionContext $this_with, KotlinTypeMarker $firstType) {
        return $this_with.eraseContainingTypeParameters($firstType);
    }

    private static final KotlinTypeMarker computeEmptyIntersectionEmptiness$lambda$2$lambda$1(Lazy<? extends KotlinTypeMarker> $firstSubstitutedType$delegate) {
        Lazy<? extends KotlinTypeMarker> lazy = $firstSubstitutedType$delegate;
        return (KotlinTypeMarker)lazy.getValue();
    }

    private static final List<KotlinTypeMarker> computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded(TypeSystemInferenceExtensionContext $this_computeByHavingCommonSubtype, KotlinTypeMarker type) {
        return $this_computeByHavingCommonSubtype.typeConstructor(type) instanceof IntersectionTypeConstructorMarker ? CollectionsKt.toList((Iterable)$this_computeByHavingCommonSubtype.supertypes($this_computeByHavingCommonSubtype.typeConstructor(type))) : CollectionsKt.listOf((Object)type);
    }

    private static final TypeCheckerState computeByHavingCommonSubtype$lambda$3(TypeSystemInferenceExtensionContext $this_computeByHavingCommonSubtype) {
        return TypeCheckerProviderContext.newTypeCheckerState$default($this_computeByHavingCommonSubtype, true, true, false, 4, null);
    }

    private static final TypeCheckerState computeByHavingCommonSubtype$lambda$4(Lazy<? extends TypeCheckerState> $typeCheckerState$delegate) {
        Lazy<? extends TypeCheckerState> lazy = $typeCheckerState$delegate;
        return (TypeCheckerState)lazy.getValue();
    }
}

