/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.utils;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.gradle.internal.utils.PrintingLogger;

public class Profiler {
    private static final ThreadLocal<Stack<Profiler>> PROFILERS = new ThreadLocal<Stack<Profiler>>(){

        @Override
        protected Stack<Profiler> initialValue() {
            return new Stack<Profiler>();
        }
    };
    private static final ReentrantLock OUT_LOCK = new ReentrantLock();
    private final String name;
    private final Logger log;
    private long start;
    private long cumulative;
    private boolean paused;
    private StackTraceElement[] stackTrace;
    private boolean mute;
    private String formatString;

    @NotNull
    public static Profiler create(@NotNull String name) {
        if (name == null) {
            Profiler.$$$reportNull$$$0(0);
        }
        return Profiler.create(name, System.out);
    }

    @NotNull
    public static Profiler create(@NotNull String name, @NotNull PrintStream out) {
        if (name == null) {
            Profiler.$$$reportNull$$$0(1);
        }
        if (out == null) {
            Profiler.$$$reportNull$$$0(2);
        }
        return Profiler.create(name, new PrintingLogger(out));
    }

    @NotNull
    public static Profiler create(@NotNull String name, @NotNull Logger log) {
        if (name == null) {
            Profiler.$$$reportNull$$$0(3);
        }
        if (log == null) {
            Profiler.$$$reportNull$$$0(4);
        }
        Profiler profiler = new Profiler(name, log);
        PROFILERS.get().push(profiler);
        Profiler profiler2 = profiler;
        if (profiler2 == null) {
            Profiler.$$$reportNull$$$0(5);
        }
        return profiler2;
    }

    public static Profiler getFromContext() {
        Stack<Profiler> profilers = PROFILERS.get();
        if (profilers.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return profilers.peek();
    }

    private Profiler(@NotNull String name, @NotNull Logger log) {
        if (name == null) {
            Profiler.$$$reportNull$$$0(6);
        }
        if (log == null) {
            Profiler.$$$reportNull$$$0(7);
        }
        this.start = Long.MAX_VALUE;
        this.cumulative = 0L;
        this.paused = true;
        this.name = name;
        this.log = log;
        this.setPrintAccuracy(3);
    }

    public Profiler recordStackTrace(int depth) {
        return this.recordStackTrace(1, depth);
    }

    public Profiler recordStackTrace(int skip, int depth) {
        int from2 = 1 + skip;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        if (from2 >= trace.length) {
            return this;
        }
        int to = depth == -1 ? trace.length : Math.min(skip + depth + 1, trace.length);
        this.stackTrace = Arrays.copyOfRange(trace, from2, to);
        return this;
    }

    public Profiler resetStackTrace() {
        this.stackTrace = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler printStackTrace() {
        if (this.stackTrace != null && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                for (StackTraceElement element : this.stackTrace) {
                    this.println("\tat ", element);
                }
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    public Profiler printEntering() {
        this.println("Entering ", this.name);
        return this;
    }

    public Profiler printThreadName() {
        this.println(Thread.currentThread().getName() + " ", this.name);
        return this;
    }

    public Profiler start() {
        if (this.paused) {
            this.start = System.nanoTime();
            this.paused = false;
        }
        return this;
    }

    public Profiler end() {
        long result2 = this.cumulative;
        if (!this.paused) {
            result2 += System.nanoTime() - this.start;
        }
        this.paused = true;
        this.cumulative = 0L;
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                this.println(this.name, " took ", this.format(result2));
                this.printStackTrace();
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    public Profiler pause() {
        if (!this.paused) {
            this.cumulative += System.nanoTime() - this.start;
            this.paused = true;
        }
        return this;
    }

    public long getCumulative() {
        return this.cumulative;
    }

    public Profiler mute() {
        this.mute = true;
        return this;
    }

    public Profiler unmute() {
        this.mute = false;
        return this;
    }

    public Profiler println(Object message2) {
        if (!this.mute && this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(message2));
        }
        return this;
    }

    public Profiler println(Object a, Object b) {
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                this.log.debug(String.valueOf(a) + b);
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b, Object c) {
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                this.log.debug(String.valueOf(a) + b + c);
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b, Object c, Object ... rest) {
        if (!this.mute && this.log.isDebugEnabled()) {
            OUT_LOCK.lock();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(a);
                sb.append(b);
                sb.append(c);
                for (Object o : rest) {
                    sb.append(o);
                }
                this.log.debug(sb.toString());
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    public Profiler setPrintAccuracy(int accuracy) {
        this.formatString = "%." + accuracy + "fs";
        return this;
    }

    private String format(long delta) {
        return String.format(this.formatString, (double)delta / 1.0E9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/gradle/internal/utils/Profiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/gradle/internal/utils/Profiler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

