/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.internal.config.LanguageFeature;
import org.jetbrains.kotlin.gradle.plugin.sources.ConsistencyCheck;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilder;
import org.jetbrains.kotlin.gradle.plugin.sources.FragmentConsistencyChecks;
import org.jetbrains.kotlin.project.model.LanguageSettings;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B&\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ4\u0010\u0019\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u0001*\u00020\u00072\u0019\u0010\u001a\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0006\u00a2\u0006\u0002\b\bH\u0002\u00a2\u0006\u0002\u0010\u001bR'\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/FragmentConsistencyChecks;", "T", "", "unitName", "", "languageSettings", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/project/model/LanguageSettings;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "allChecks", "", "Lorg/jetbrains/kotlin/gradle/plugin/sources/ConsistencyCheck;", "getAllChecks", "()Ljava/util/List;", "defaultLanguageVersion", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinVersion;", "languageVersionCheck", "languageVersionCheckHint", "optInAnnotationsCheck", "", "optInAnnotationsInUseHint", "unstableFeaturesCheck", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageFeature;", "unstableFeaturesHint", "getValueIfExists", "getValue", "(Lorg/jetbrains/kotlin/project/model/LanguageSettings;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-gradle-plugin_common"})
public final class FragmentConsistencyChecks<T> {
    @NotNull
    private final Function1<T, LanguageSettings> languageSettings;
    @NotNull
    private final KotlinVersion defaultLanguageVersion;
    @NotNull
    private final String languageVersionCheckHint;
    @NotNull
    private final ConsistencyCheck<T, KotlinVersion> languageVersionCheck;
    @NotNull
    private final String unstableFeaturesHint;
    @NotNull
    private final ConsistencyCheck<T, Set<LanguageFeature>> unstableFeaturesCheck;
    @NotNull
    private final String optInAnnotationsInUseHint;
    @NotNull
    private final ConsistencyCheck<T, Set<String>> optInAnnotationsCheck;
    @NotNull
    private final List<ConsistencyCheck<T, ? extends Object>> allChecks;

    public FragmentConsistencyChecks(@NotNull String unitName, @NotNull Function1<? super T, ? extends LanguageSettings> languageSettings2) {
        Intrinsics.checkNotNullParameter((Object)unitName, (String)"unitName");
        Intrinsics.checkNotNullParameter(languageSettings2, (String)"languageSettings");
        this.languageSettings = languageSettings2;
        this.defaultLanguageVersion = KotlinVersion.Companion.getDEFAULT();
        this.languageVersionCheckHint = "The language version of the dependent " + unitName + " must be greater than or equal to that of its dependency.";
        this.languageVersionCheck = new ConsistencyCheck("language version", (Function1)new Function1<T, KotlinVersion>(this){
            final /* synthetic */ FragmentConsistencyChecks<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final KotlinVersion invoke(T unit) {
                return (KotlinVersion)FragmentConsistencyChecks.access$getValueIfExists(this.this$0, (LanguageSettings)FragmentConsistencyChecks.access$getLanguageSettings$p(this.this$0).invoke(unit), (Function1)new Function1<LanguageSettings, KotlinVersion>(this.this$0){
                    final /* synthetic */ FragmentConsistencyChecks<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final KotlinVersion invoke(LanguageSettings $this$getValueIfExists) {
                        String string2;
                        block3: {
                            block2: {
                                Intrinsics.checkNotNullParameter((Object)$this$getValueIfExists, (String)"$this$getValueIfExists");
                                string2 = $this$getValueIfExists.getLanguageVersion();
                                if (string2 == null) break block2;
                                String it = string2;
                                boolean bl = false;
                                KotlinVersion kotlinVersion = KotlinVersion.Companion.fromVersion(it);
                                string2 = kotlinVersion;
                                if (kotlinVersion != null) break block3;
                            }
                            string2 = FragmentConsistencyChecks.access$getDefaultLanguageVersion$p(this.this$0);
                        }
                        return string2;
                    }
                });
            }
        }, languageVersionCheck.2.INSTANCE, this.languageVersionCheckHint);
        this.unstableFeaturesHint = "The dependent " + unitName + " must enable all unstable language features that its dependency has.";
        this.unstableFeaturesCheck = new ConsistencyCheck("unstable language feature set", (Function1)new Function1<T, Set<? extends LanguageFeature>>(this){
            final /* synthetic */ FragmentConsistencyChecks<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Set<LanguageFeature> invoke(T unit) {
                return (Set)FragmentConsistencyChecks.access$getValueIfExists(this.this$0, (LanguageSettings)FragmentConsistencyChecks.access$getLanguageSettings$p(this.this$0).invoke(unit), unstableFeaturesCheck.1.INSTANCE);
            }
        }, unstableFeaturesCheck.2.INSTANCE, this.unstableFeaturesHint);
        this.optInAnnotationsInUseHint = "The dependent " + unitName + " must use all opt-in annotations that its dependency uses.";
        this.optInAnnotationsCheck = new ConsistencyCheck("set of opt-in annotations in use", (Function1)new Function1<T, Set<? extends String>>(this){
            final /* synthetic */ FragmentConsistencyChecks<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Set<String> invoke(T unit) {
                return (Set)FragmentConsistencyChecks.access$getValueIfExists(this.this$0, (LanguageSettings)FragmentConsistencyChecks.access$getLanguageSettings$p(this.this$0).invoke(unit), optInAnnotationsCheck.1.INSTANCE);
            }
        }, optInAnnotationsCheck.2.INSTANCE, this.optInAnnotationsInUseHint);
        Object[] objectArray = new ConsistencyCheck[]{this.languageVersionCheck, this.unstableFeaturesCheck, this.optInAnnotationsCheck};
        this.allChecks = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<ConsistencyCheck<T, ? extends Object>> getAllChecks() {
        return this.allChecks;
    }

    private final <T> T getValueIfExists(LanguageSettings $this$getValueIfExists, Function1<? super LanguageSettings, ? extends T> getValue2) {
        Intrinsics.checkNotNull((Object)$this$getValueIfExists, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilder");
        DefaultLanguageSettingsBuilder defaultLanguageSettingsBuilder = (DefaultLanguageSettingsBuilder)$this$getValueIfExists;
        return (T)(defaultLanguageSettingsBuilder.getCompilationCompilerOptions$kotlin_gradle_plugin_common().isCompleted() ? getValue2.invoke((Object)defaultLanguageSettingsBuilder) : null);
    }

    public static final /* synthetic */ Object access$getValueIfExists(FragmentConsistencyChecks $this, LanguageSettings $receiver, Function1 getValue2) {
        return $this.getValueIfExists($receiver, getValue2);
    }

    public static final /* synthetic */ Function1 access$getLanguageSettings$p(FragmentConsistencyChecks $this) {
        return $this.languageSettings;
    }

    public static final /* synthetic */ KotlinVersion access$getDefaultLanguageVersion$p(FragmentConsistencyChecks $this) {
        return $this.defaultLanguageVersion;
    }
}

