/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.binaryen;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u000fJ\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenPlatform;", "", "name", "", "arch", "(Ljava/lang/String;Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "getName", "platform", "getPlatform", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isWindows", "toString", "Companion", "kotlin-gradle-plugin_common"})
public final class BinaryenPlatform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String arch;
    @NotNull
    public static final String WIN = "windows";
    @NotNull
    public static final String LINUX = "linux";
    @NotNull
    public static final String DARWIN = "macos";
    @NotNull
    public static final String X64 = "x86_64";
    @NotNull
    public static final String X86 = "x86_86";

    public BinaryenPlatform(@NotNull String name, @NotNull String arch) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        this.name = name;
        this.arch = arch;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getArch() {
        return this.arch;
    }

    @NotNull
    public final String getPlatform() {
        return this.arch + '-' + this.name;
    }

    public final boolean isWindows() {
        return Intrinsics.areEqual((Object)this.name, (Object)WIN);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.arch;
    }

    @NotNull
    public final BinaryenPlatform copy(@NotNull String name, @NotNull String arch) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        return new BinaryenPlatform(name, arch);
    }

    public static /* synthetic */ BinaryenPlatform copy$default(BinaryenPlatform binaryenPlatform, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = binaryenPlatform.name;
        }
        if ((n & 2) != 0) {
            string3 = binaryenPlatform.arch;
        }
        return binaryenPlatform.copy(string2, string3);
    }

    @NotNull
    public String toString() {
        return "BinaryenPlatform(name=" + this.name + ", arch=" + this.arch + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.arch.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinaryenPlatform)) {
            return false;
        }
        BinaryenPlatform binaryenPlatform = (BinaryenPlatform)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)binaryenPlatform.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.arch, (Object)binaryenPlatform.arch);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenPlatform$Companion;", "", "()V", "DARWIN", "", "LINUX", "WIN", "X64", "X86", "parseBinaryenPlatform", "Lorg/jetbrains/kotlin/gradle/targets/js/binaryen/BinaryenPlatform;", "name", "arch", "uname", "Lorg/gradle/api/provider/Provider;", "parseBinaryenPlatform$kotlin_gradle_plugin_common", "parseOsArch", "parseOsName", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BinaryenPlatform parseBinaryenPlatform$kotlin_gradle_plugin_common(@NotNull String name, @NotNull String arch, @NotNull Provider<String> uname) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter(uname, (String)"uname");
            String string2 = name.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String string3 = this.parseOsName(string2);
            String string4 = arch.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            return new BinaryenPlatform(string3, this.parseOsArch(string4, uname));
        }

        private final String parseOsName(String name) {
            String string2;
            if (StringsKt.contains$default((CharSequence)name, (CharSequence)BinaryenPlatform.WIN, (boolean)false, (int)2, null)) {
                string2 = BinaryenPlatform.WIN;
            } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                string2 = BinaryenPlatform.DARWIN;
            } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)BinaryenPlatform.LINUX, (boolean)false, (int)2, null)) {
                string2 = BinaryenPlatform.LINUX;
            } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"freebsd", (boolean)false, (int)2, null)) {
                string2 = BinaryenPlatform.LINUX;
            } else {
                throw new IllegalArgumentException("Unsupported OS: " + name);
            }
            return string2;
        }

        private final String parseOsArch(String arch, Provider<String> uname) {
            String string2;
            if (Intrinsics.areEqual((Object)arch, (Object)"arm") || StringsKt.startsWith$default((String)arch, (String)"aarch", (boolean)false, (int)2, null)) {
                Object object = uname.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uname.get()");
                string2 = (String)object;
            } else {
                string2 = StringsKt.contains$default((CharSequence)arch, (CharSequence)"64", (boolean)false, (int)2, null) ? BinaryenPlatform.X64 : BinaryenPlatform.X86;
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

