/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.codec.digest;

import java.nio.charset.StandardCharsets;
import org.jetbrains.kotlin.org.apache.commons.codec.digest.Md5Crypt;
import org.jetbrains.kotlin.org.apache.commons.codec.digest.Sha2Crypt;
import org.jetbrains.kotlin.org.apache.commons.codec.digest.UnixCrypt;

public class Crypt {
    public static String crypt(byte[] keyBytes) {
        return Crypt.crypt(keyBytes, null);
    }

    public static String crypt(byte[] keyBytes, String salt2) {
        if (salt2 == null) {
            return Sha2Crypt.sha512Crypt(keyBytes);
        }
        if (salt2.startsWith("$6$")) {
            return Sha2Crypt.sha512Crypt(keyBytes, salt2);
        }
        if (salt2.startsWith("$5$")) {
            return Sha2Crypt.sha256Crypt(keyBytes, salt2);
        }
        if (salt2.startsWith("$1$")) {
            return Md5Crypt.md5Crypt(keyBytes, salt2);
        }
        return UnixCrypt.crypt(keyBytes, salt2);
    }

    public static String crypt(String key) {
        return Crypt.crypt(key, null);
    }

    public static String crypt(String key, String salt2) {
        return Crypt.crypt(key.getBytes(StandardCharsets.UTF_8), salt2);
    }

    @Deprecated
    public Crypt() {
    }
}

