/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.DiagnosticIcon;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticOutput;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0016\b\"\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\fH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR\u001b\u0010\u0014\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u0004\u0018\u00010\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001c\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/AbstractToolingDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticOutput;", "diagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "showEmoji", "", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "(Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;ZLorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "documentation", "", "getDocumentation", "()Ljava/lang/String;", "documentation$delegate", "Lkotlin/Lazy;", "message", "getMessage", "message$delegate", "name", "getName", "name$delegate", "getSeverity", "()Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "getShowEmoji", "()Z", "solution", "getSolution", "solution$delegate", "buildDocumentation", "buildMessage", "buildName", "buildSolution", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nStyledToolingDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyledToolingDiagnostic.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/AbstractToolingDiagnostic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1851#2,2:235\n*S KotlinDebug\n*F\n+ 1 StyledToolingDiagnostic.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/AbstractToolingDiagnostic\n*L\n99#1:235,2\n*E\n"})
abstract class AbstractToolingDiagnostic
implements ToolingDiagnosticOutput {
    @NotNull
    private final ToolingDiagnostic diagnostic;
    private final boolean showEmoji;
    @NotNull
    private final ToolingDiagnostic.Severity severity;
    @NotNull
    private final Lazy name$delegate;
    @NotNull
    private final Lazy message$delegate;
    @NotNull
    private final Lazy solution$delegate;
    @NotNull
    private final Lazy documentation$delegate;

    public AbstractToolingDiagnostic(@NotNull ToolingDiagnostic diagnostic, boolean showEmoji, @NotNull ToolingDiagnostic.Severity severity) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.diagnostic = diagnostic;
        this.showEmoji = showEmoji;
        this.severity = severity;
        this.name$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AbstractToolingDiagnostic this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.buildName();
            }
        }));
        this.message$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AbstractToolingDiagnostic this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.buildMessage();
            }
        }));
        this.solution$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AbstractToolingDiagnostic this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.buildSolution();
            }
        }));
        this.documentation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AbstractToolingDiagnostic this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.buildDocumentation();
            }
        }));
    }

    @NotNull
    public final ToolingDiagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public final boolean getShowEmoji() {
        return this.showEmoji;
    }

    @NotNull
    public final ToolingDiagnostic.Severity getSeverity() {
        return this.severity;
    }

    @Override
    @NotNull
    public String getName() {
        Lazy lazy = this.name$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getMessage() {
        Lazy lazy = this.message$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getSolution() {
        Lazy lazy = this.solution$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getDocumentation() {
        Lazy lazy = this.documentation$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String buildName() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.showEmoji) {
            DiagnosticIcon diagnosticIcon;
            switch (WhenMappings.$EnumSwitchMapping$0[this.severity.ordinal()]) {
                case 1: {
                    diagnosticIcon = DiagnosticIcon.WARNING;
                    break;
                }
                case 2: {
                    diagnosticIcon = DiagnosticIcon.ERROR;
                    break;
                }
                case 3: {
                    diagnosticIcon = DiagnosticIcon.FATAL;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticIcon iconSeverity = diagnosticIcon;
            $this$buildName_u24lambda_u240.append(iconSeverity.getIcon());
            $this$buildName_u24lambda_u240.append(" ");
        }
        $this$buildName_u24lambda_u240.append(this.diagnostic.getIdentifier().getDisplayName());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    @NotNull
    public String buildMessage() {
        return ((Object)StringsKt.trimEnd((CharSequence)this.diagnostic.getMessage())).toString();
    }

    @Nullable
    public String buildSolution() {
        String string;
        List<String> solutions = this.diagnostic.getSolutions();
        switch (solutions.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = "Solution: " + (String)CollectionsKt.single(solutions);
                break;
            }
            default: {
                StringBuilder stringBuilder;
                StringBuilder $this$buildSolution_u24lambda_u242 = stringBuilder = new StringBuilder();
                boolean bl = false;
                StringBuilder stringBuilder2 = $this$buildSolution_u24lambda_u242.append("Solutions:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                Iterable $this$forEach$iv = solutions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String solution2 = (String)element$iv;
                    boolean bl2 = false;
                    StringBuilder stringBuilder3 = $this$buildSolution_u24lambda_u242.append(" \u2022 " + solution2);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                }
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                string = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
            }
        }
        return string;
    }

    @Nullable
    public String buildDocumentation() {
        Object object = this.diagnostic.getDocumentation();
        return object != null && (object = ((ToolingDiagnostic.Documentation)object).getAdditionalUrlContext()) != null ? ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)object))).toString() : null;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolingDiagnostic.Severity.values().length];
            try {
                nArray[ToolingDiagnostic.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.FATAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

