/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.Attribute;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class CPMember
extends ClassFileEntry {
    List<Attribute> attributes;
    short flags;
    CPUTF8 name;
    transient int nameIndex;
    protected final CPUTF8 descriptor;
    transient int descriptorIndex;

    public CPMember(CPUTF8 name2, CPUTF8 descriptor2, long flags, List<Attribute> attributes2) {
        this.name = Objects.requireNonNull(name2, "name");
        this.descriptor = Objects.requireNonNull(descriptor2, "descriptor");
        this.flags = (short)flags;
        this.attributes = attributes2 == null ? Collections.EMPTY_LIST : attributes2;
    }

    @Override
    protected void doWrite(DataOutputStream dos) throws IOException {
        dos.writeShort(this.flags);
        dos.writeShort(this.nameIndex);
        dos.writeShort(this.descriptorIndex);
        int attributeCount = this.attributes.size();
        dos.writeShort(attributeCount);
        for (int i2 = 0; i2 < attributeCount; ++i2) {
            Attribute attribute = this.attributes.get(i2);
            attribute.doWrite(dos);
        }
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        CPMember other = (CPMember)obj2;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.descriptor, other.descriptor) && this.flags == other.flags && Objects.equals(this.name, other.name);
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        int attributeCount = this.attributes.size();
        ClassFileEntry[] entries2 = new ClassFileEntry[attributeCount + 2];
        entries2[0] = this.name;
        entries2[1] = this.descriptor;
        for (int i2 = 0; i2 < attributeCount; ++i2) {
            entries2[i2 + 2] = this.attributes.get(i2);
        }
        return entries2;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.attributes.hashCode();
        result2 = 31 * result2 + this.descriptor.hashCode();
        result2 = 31 * result2 + this.flags;
        result2 = 31 * result2 + this.name.hashCode();
        return result2;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.nameIndex = pool.indexOf(this.name);
        this.descriptorIndex = pool.indexOf(this.descriptor);
        this.attributes.forEach(attribute -> attribute.resolve(pool));
    }

    @Override
    public String toString() {
        return "CPMember: " + this.name + "(" + this.descriptor + ")";
    }
}

