/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.gradle.plugin.statistics.FusMetrics;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinTaskExecutionMetrics;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/FusMetrics;", "()V", "collectMetrics", "", "taskExecutionResult", "Lorg/jetbrains/kotlin/gradle/report/TaskExecutionResult;", "event", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "metricsConsumer", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "kotlin-gradle-plugin_common"})
public final class KotlinTaskExecutionMetrics
implements FusMetrics {
    @NotNull
    public static final KotlinTaskExecutionMetrics INSTANCE = new KotlinTaskExecutionMetrics();

    private KotlinTaskExecutionMetrics() {
    }

    public final void collectMetrics(@NotNull TaskExecutionResult taskExecutionResult, @NotNull TaskFinishEvent event, @NotNull StatisticsValuesConsumer metricsConsumer) {
        Intrinsics.checkNotNullParameter((Object)taskExecutionResult, (String)"taskExecutionResult");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)metricsConsumer, (String)"metricsConsumer");
        long totalTimeMs = event.getResult().getEndTime() - event.getResult().getStartTime();
        BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> buildMetrics = taskExecutionResult.getBuildMetrics();
        StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, NumericalMetrics.COMPILATION_DURATION, totalTimeMs, null, null, 12, null);
        StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, BooleanMetrics.KOTLIN_COMPILATION_FAILED, event.getResult() instanceof FailureResult, null, null, 12, null);
        StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, NumericalMetrics.COMPILATIONS_COUNT, 1L, null, null, 12, null);
        Map metricsMap = buildMetrics.getBuildPerformanceMetrics().asMap();
        Long linesOfCode = (Long)metricsMap.get(GradleBuildPerformanceMetric.SOURCE_LINES_NUMBER);
        if (linesOfCode != null && linesOfCode > 0L && totalTimeMs > 0L) {
            long value2;
            Long l;
            StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, NumericalMetrics.COMPILED_LINES_OF_CODE, linesOfCode, null, null, 12, null);
            metricsConsumer.report(NumericalMetrics.COMPILATION_LINES_PER_SECOND, linesOfCode * (long)1000 / totalTimeMs, null, linesOfCode);
            Long l2 = (Long)metricsMap.get(GradleBuildPerformanceMetric.ANALYSIS_LPS);
            if (l2 != null) {
                l = l2;
                value2 = ((Number)l).longValue();
                boolean bl = false;
                metricsConsumer.report(NumericalMetrics.ANALYSIS_LINES_PER_SECOND, value2, null, linesOfCode);
            }
            Long l3 = (Long)metricsMap.get(GradleBuildPerformanceMetric.CODE_GENERATION_LPS);
            if (l3 != null) {
                l = l3;
                value2 = ((Number)l).longValue();
                boolean bl = false;
                metricsConsumer.report(NumericalMetrics.CODE_GENERATION_LINES_PER_SECOND, value2, null, linesOfCode);
            }
        }
        StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, NumericalMetrics.INCREMENTAL_COMPILATIONS_COUNT, taskExecutionResult.getBuildMetrics().getBuildAttributes().asMap().isEmpty() ? 1L : 0L, null, null, 12, null);
    }
}

