/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.util.DynamicStats;
import org.jetbrains.kotlin.gradle.internal.util.GarbageCollectionStats;
import org.jetbrains.kotlin.gradle.internal.util.PhaseSideType;
import org.jetbrains.kotlin.gradle.internal.util.PhaseType;
import org.jetbrains.kotlin.gradle.internal.util.SideStats;
import org.jetbrains.kotlin.gradle.internal.util.Time;
import org.jetbrains.kotlin.gradle.internal.util.UnitStats;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00010\u0004\u001a&\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0012\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0006\"\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"forEachPhaseMeasurement", "", "Lorg/jetbrains/kotlin/gradle/internal/util/UnitStats;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/gradle/internal/util/PhaseType;", "Lorg/jetbrains/kotlin/gradle/internal/util/Time;", "forEachPhaseSideMeasurement", "Lorg/jetbrains/kotlin/gradle/internal/util/PhaseSideType;", "Lorg/jetbrains/kotlin/gradle/internal/util/SideStats;", "phaseTypeName", "", "", "getPhaseTypeName", "()Ljava/util/Map;", "phaseSideTypeName", "getPhaseSideTypeName", "forEachStringMeasurement", "Lkotlin/Function1;", "nanosInSecond", "", "getNanosInSecond", "()J", "getLinesPerSecond", "", "time", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nUnitStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitStats.kt\norg/jetbrains/kotlin/util/UnitStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n1869#2,2:283\n1869#2,2:285\n774#2:287\n865#2,2:288\n1869#2,2:290\n*S KotlinDebug\n*F\n+ 1 UnitStats.kt\norg/jetbrains/kotlin/util/UnitStatsKt\n*L\n266#1:283,2\n275#1:285,2\n246#1:287\n246#1:288,2\n246#1:290,2\n*E\n"})
public final class UnitStatsKt {
    @NotNull
    private static final Map<PhaseType, String> phaseTypeName;
    @NotNull
    private static final Map<PhaseSideType, String> phaseSideTypeName;
    private static final long nanosInSecond;

    public static final void forEachPhaseMeasurement(@NotNull UnitStats $this$forEachPhaseMeasurement, @NotNull Function2<? super PhaseType, ? super Time, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachPhaseMeasurement, (String)"<this>");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        action2.invoke((Object)PhaseType.Initialization, (Object)$this$forEachPhaseMeasurement.getInitStats());
        action2.invoke((Object)PhaseType.Analysis, (Object)$this$forEachPhaseMeasurement.getAnalysisStats());
        action2.invoke((Object)PhaseType.TranslationToIr, (Object)$this$forEachPhaseMeasurement.getTranslationToIrStats());
        action2.invoke((Object)PhaseType.IrPreLowering, (Object)$this$forEachPhaseMeasurement.getIrPreLoweringStats());
        action2.invoke((Object)PhaseType.IrSerialization, (Object)$this$forEachPhaseMeasurement.getIrSerializationStats());
        action2.invoke((Object)PhaseType.KlibWriting, (Object)$this$forEachPhaseMeasurement.getKlibWritingStats());
        action2.invoke((Object)PhaseType.IrLowering, (Object)$this$forEachPhaseMeasurement.getIrLoweringStats());
        action2.invoke((Object)PhaseType.Backend, (Object)$this$forEachPhaseMeasurement.getBackendStats());
    }

    public static final void forEachPhaseSideMeasurement(@NotNull UnitStats $this$forEachPhaseSideMeasurement, @NotNull Function2<? super PhaseSideType, ? super SideStats, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachPhaseSideMeasurement, (String)"<this>");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        action2.invoke((Object)PhaseSideType.FindJavaClass, (Object)$this$forEachPhaseSideMeasurement.getFindJavaClassStats());
        action2.invoke((Object)PhaseSideType.BinaryClassFromKotlinFile, (Object)$this$forEachPhaseSideMeasurement.getFindKotlinClassStats());
    }

    @NotNull
    public static final Map<PhaseType, String> getPhaseTypeName() {
        return phaseTypeName;
    }

    @NotNull
    public static final Map<PhaseSideType, String> getPhaseSideTypeName() {
        return phaseSideTypeName;
    }

    public static final void forEachStringMeasurement(@NotNull UnitStats $this$forEachStringMeasurement, @NotNull Function1<? super String, Unit> action2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$forEachStringMeasurement, (String)"<this>");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            UnitStatsKt.forEachPhaseMeasurement($this$forEachStringMeasurement, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> UnitStatsKt.forEachStringMeasurement$lambda$0(action2, $this$forEachStringMeasurement, arg_0, arg_1)));
            UnitStatsKt.forEachPhaseSideMeasurement($this$forEachStringMeasurement, (Function2<? super PhaseSideType, ? super SideStats, Unit>)((Function2)(arg_0, arg_1) -> UnitStatsKt.forEachStringMeasurement$lambda$1(action2, arg_0, arg_1)));
            Iterable $this$forEach$iv = $this$forEachStringMeasurement.getGcStats();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GarbageCollectionStats it = (GarbageCollectionStats)element$iv;
                boolean bl = false;
                action2.invoke((Object)("GC time for " + it.getKind() + " is " + it.getMillis() + " ms, " + it.getCount() + " collections"));
            }
            Long l = $this$forEachStringMeasurement.getJitTimeMillis();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                action2.invoke((Object)("JIT time is " + it + " ms"));
            }
            List<String> list = $this$forEachStringMeasurement.getExtendedStats();
            if (list == null) break block3;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl = false;
                action2.invoke((Object)it);
            }
        }
    }

    public static final long getNanosInSecond() {
        return nanosInSecond;
    }

    public static final double getLinesPerSecond(@NotNull UnitStats $this$getLinesPerSecond, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinesPerSecond, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return (double)$this$getLinesPerSecond.getLinesCount() / (double)time.getNanos() * (double)nanosInSecond;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit forEachStringMeasurement$lambda$0(Function1 $action, UnitStats $this_forEachStringMeasurement, PhaseType phaseType, Time time) {
        block7: {
            void $this$filterTo$iv$iv;
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
            if (time == null) {
                return Unit.INSTANCE;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "%20s%8s ms";
            Object object = new Object[]{MapsKt.getValue(phaseTypeName, (Object)((Object)phaseType)), time.getMillis()};
            String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            if (phaseType != PhaseType.Initialization && $this_forEachStringMeasurement.getLinesCount() != 0) {
                string2 = "%12.3f loc/s";
                object = Locale.ENGLISH;
                Object[] objectArray = new Object[]{UnitStatsKt.getLinesPerSecond($this_forEachStringMeasurement, time)};
                String string4 = String.format((Locale)object, string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            } else {
                string = "";
            }
            $action.invoke((Object)stringBuilder2.append(string).toString());
            List<DynamicStats> list = $this_forEachStringMeasurement.getDynamicStats();
            if (list == null) break block7;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DynamicStats it = (DynamicStats)element$iv$iv;
                boolean bl = false;
                if (!(it.getParentPhaseType() == phaseType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string5;
                DynamicStats dynamicStats = (DynamicStats)element$iv;
                boolean bl = false;
                String dynamicName = dynamicStats.component2();
                Time dynamicTime = dynamicStats.component3();
                StringBuilder stringBuilder3 = new StringBuilder();
                String string6 = "%20s%8s ms";
                Object object2 = new Object[]{"DYNAMIC PHASE", dynamicTime.getMillis()};
                String string7 = String.format(string6, Arrays.copyOf(object2, ((Object[])object2).length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
                StringBuilder stringBuilder4 = stringBuilder3.append(string7);
                if ($this_forEachStringMeasurement.getLinesCount() != 0) {
                    string6 = "%12.3f loc/s (" + dynamicName + ')';
                    object2 = Locale.ENGLISH;
                    Object[] objectArray = new Object[]{UnitStatsKt.getLinesPerSecond($this_forEachStringMeasurement, dynamicTime)};
                    String string8 = String.format((Locale)object2, string6, Arrays.copyOf(objectArray, objectArray.length));
                    string5 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
                } else {
                    string5 = " (" + dynamicName + ')';
                }
                $action.invoke((Object)stringBuilder4.append(string5).toString());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit forEachStringMeasurement$lambda$1(Function1 $action, PhaseSideType phaseSideType, SideStats sideStats) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
        if (sideStats == null) {
            return Unit.INSTANCE;
        }
        String description2 = (String)MapsKt.getValue(phaseSideTypeName, (Object)((Object)phaseSideType));
        $action.invoke((Object)(description2 + " performed " + sideStats.getCount() + " times, total time " + sideStats.getTime().getMillis() + " ms"));
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)PhaseType.Initialization), (Object)"INIT"), TuplesKt.to((Object)((Object)PhaseType.Analysis), (Object)"ANALYZE"), TuplesKt.to((Object)((Object)PhaseType.TranslationToIr), (Object)"TRANSLATION to IR"), TuplesKt.to((Object)((Object)PhaseType.IrPreLowering), (Object)"IR PRE-LOWERING"), TuplesKt.to((Object)((Object)PhaseType.IrSerialization), (Object)"IR SERIALIZATION"), TuplesKt.to((Object)((Object)PhaseType.KlibWriting), (Object)"KLIB WRITING"), TuplesKt.to((Object)((Object)PhaseType.IrLowering), (Object)"IR LOWERING"), TuplesKt.to((Object)((Object)PhaseType.Backend), (Object)"BACKEND")};
        phaseTypeName = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)PhaseSideType.FindJavaClass), (Object)"Find Java class"), TuplesKt.to((Object)((Object)PhaseSideType.BinaryClassFromKotlinFile), (Object)"Binary class from Kotlin file")};
        phaseSideTypeName = MapsKt.mapOf((Pair[])pairArray);
        nanosInSecond = TimeUnit.SECONDS.toNanos(1L);
    }
}

