/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.logging.BuildErrorMessageCollector;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB5\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\"\u0010\u001b\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "logger", "Lorg/gradle/api/logging/Logger;", "delegate", "acceptableMessageSeverity", "", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "kotlinPluginVersion", "", "(Lorg/gradle/api/logging/Logger;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Ljava/lang/String;)V", "buildErrorMessageCollector", "Lorg/jetbrains/kotlin/gradle/logging/BuildErrorMessageCollector;", "getKotlinPluginVersion", "()Ljava/lang/String;", "getLogger", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "clear", "", "flush", "files", "", "Ljava/io/File;", "hasErrors", "", "report", "error", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "severity", "message", "kotlin-gradle-plugin_common"})
public final class GradleErrorMessageCollector
implements MessageCollector {
    @NotNull
    private final KotlinLogger logger;
    @Nullable
    private final MessageCollector delegate;
    @NotNull
    private final List<CompilerMessageSeverity> acceptableMessageSeverity;
    @Nullable
    private final String kotlinPluginVersion;
    @NotNull
    private final BuildErrorMessageCollector buildErrorMessageCollector;

    public GradleErrorMessageCollector(@NotNull KotlinLogger logger2, @Nullable MessageCollector delegate2, @NotNull List<? extends CompilerMessageSeverity> acceptableMessageSeverity, @Nullable String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(acceptableMessageSeverity, (String)"acceptableMessageSeverity");
        this.logger = logger2;
        this.delegate = delegate2;
        this.acceptableMessageSeverity = acceptableMessageSeverity;
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.buildErrorMessageCollector = new BuildErrorMessageCollector(this.logger, this.kotlinPluginVersion);
    }

    public /* synthetic */ GradleErrorMessageCollector(KotlinLogger kotlinLogger, MessageCollector messageCollector, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            messageCollector = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.listOf((Object)((Object)CompilerMessageSeverity.EXCEPTION));
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(kotlinLogger, messageCollector, (List<? extends CompilerMessageSeverity>)list, string);
    }

    @NotNull
    public final KotlinLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final String getKotlinPluginVersion() {
        return this.kotlinPluginVersion;
    }

    public GradleErrorMessageCollector(@NotNull Logger logger2, @Nullable MessageCollector delegate2, @NotNull List<? extends CompilerMessageSeverity> acceptableMessageSeverity, @Nullable String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(acceptableMessageSeverity, (String)"acceptableMessageSeverity");
        this(new GradleKotlinLogger(logger2, null, false, 6, null), delegate2, acceptableMessageSeverity, kotlinPluginVersion);
    }

    public /* synthetic */ GradleErrorMessageCollector(Logger logger2, MessageCollector messageCollector, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            messageCollector = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.listOf((Object)((Object)CompilerMessageSeverity.EXCEPTION));
        }
        if ((n & 8) != 0) {
            string = KotlinPluginWrapperKt.getKotlinPluginVersion(logger2);
        }
        this(logger2, messageCollector, (List<? extends CompilerMessageSeverity>)list, string);
    }

    @Override
    public void clear() {
        block0: {
            MessageCollector messageCollector = this.delegate;
            if (messageCollector == null) break block0;
            messageCollector.clear();
        }
    }

    public final void report(@NotNull Throwable error, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.report(CompilerMessageSeverity.EXCEPTION, error.getMessage() + '\n' + ExceptionsKt.stackTraceToString((Throwable)error), location);
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageCollector messageCollector = this.delegate;
        if (messageCollector != null) {
            messageCollector.report(severity, message2, location);
        }
        if (this.acceptableMessageSeverity.contains((Object)severity)) {
            this.buildErrorMessageCollector.addError(message2);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.buildErrorMessageCollector.hasErrors();
    }

    public final void flush(@NotNull Set<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.buildErrorMessageCollector.flush(files2);
        this.clear();
    }
}

