/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ProblemsReporter;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.RenderReportedDiagnosticsKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptions;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptionsKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnosticsParameters;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J.\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u00072\f\b\u0002\u0010\u001e\u001a\u00060\u000ej\u0002`\u0014J.\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u00072\f\b\u0002\u0010\u001e\u001a\u00060\u000ej\u0002`\u0014J\u0006\u0010!\u001a\u00020\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector$Parameter;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "isTransparent", "", "problemsReporter", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ProblemsReporter;", "getProblemsReporter$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ProblemsReporter;", "rawDiagnosticsFromProject", "", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/GradleProjectPath;", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "reportedIds", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticId;", "getDiagnosticsForProject", "", "project", "Lorg/gradle/api/Project;", "handleDiagnostic", "", "diagnostic", "report", "reportOnce", "key", "from", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnosticsParameters;", "switchToTransparentMode", "Parameter", "kotlin-gradle-plugin_common"})
public abstract class KotlinToolingDiagnosticsCollector
implements BuildService<Parameter> {
    @NotNull
    private final ObjectFactory objects;
    private volatile boolean isTransparent;
    @NotNull
    private final Map<String, List<ToolingDiagnostic>> rawDiagnosticsFromProject;
    @NotNull
    private final Set<String> reportedIds;

    @Inject
    public KotlinToolingDiagnosticsCollector(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.objects = objects;
        this.rawDiagnosticsFromProject = new ConcurrentHashMap();
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(ConcurrentHashMap())");
        this.reportedIds = set;
    }

    @Internal
    @NotNull
    public final ProblemsReporter getProblemsReporter$kotlin_gradle_plugin_common() {
        return ((ProblemsReporter.Factory)((Parameter)this.getParameters()).getProblemsReporterFactory().get()).getInstance(this.objects);
    }

    @NotNull
    public final Collection<ToolingDiagnostic> getDiagnosticsForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<ToolingDiagnostic> list = this.rawDiagnosticsFromProject.get(project.getPath());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    public final void report(@NotNull Project project, @NotNull ToolingDiagnostic diagnostic, boolean reportOnce, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.reportedIds.add(key) || !reportOnce) {
            this.handleDiagnostic(project, diagnostic);
        }
    }

    public static /* synthetic */ void report$default(KotlinToolingDiagnosticsCollector kotlinToolingDiagnosticsCollector, Project project, ToolingDiagnostic toolingDiagnostic, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = toolingDiagnostic.getId();
        }
        kotlinToolingDiagnosticsCollector.report(project, toolingDiagnostic, bl, string);
    }

    public final void report(@NotNull UsesKotlinToolingDiagnosticsParameters from2, @NotNull ToolingDiagnostic diagnostic, boolean reportOnce, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.reportedIds.add(key) || !reportOnce) {
            ToolingDiagnosticRenderingOptions options = (ToolingDiagnosticRenderingOptions)from2.getDiagnosticRenderingOptions().get();
            ProblemsReporter problemsReporter = this.getProblemsReporter$kotlin_gradle_plugin_common();
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"options");
            problemsReporter.reportProblemDiagnostic(diagnostic, options);
        }
    }

    public static /* synthetic */ void report$default(KotlinToolingDiagnosticsCollector kotlinToolingDiagnosticsCollector, UsesKotlinToolingDiagnosticsParameters usesKotlinToolingDiagnosticsParameters, ToolingDiagnostic toolingDiagnostic, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = toolingDiagnostic.getId();
        }
        kotlinToolingDiagnosticsCollector.report(usesKotlinToolingDiagnosticsParameters, toolingDiagnostic, bl, string);
    }

    public final void switchToTransparentMode() {
        this.isTransparent = true;
    }

    private final void handleDiagnostic(Project project, ToolingDiagnostic diagnostic) {
        ToolingDiagnosticRenderingOptions options = ToolingDiagnosticRenderingOptions.Companion.forProject(project);
        if (ToolingDiagnosticRenderingOptionsKt.isSuppressed(diagnostic, options)) {
            return;
        }
        this.rawDiagnosticsFromProject.compute(project.getPath(), new BiFunction(diagnostic){
            final /* synthetic */ ToolingDiagnostic $diagnostic;
            {
                this.$diagnostic = $diagnostic;
            }

            public final List<ToolingDiagnostic> apply(String string, List<ToolingDiagnostic> previousListIfAny) {
                List<ToolingDiagnostic> list;
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                List<ToolingDiagnostic> list2 = previousListIfAny;
                if (list2 != null) {
                    List<ToolingDiagnostic> list3 = list2;
                    ToolingDiagnostic toolingDiagnostic = this.$diagnostic;
                    List<ToolingDiagnostic> $this$apply_u24lambda_u240 = list3;
                    boolean bl = false;
                    $this$apply_u24lambda_u240.add(toolingDiagnostic);
                    list = list3;
                } else {
                    Object[] objectArray = new ToolingDiagnostic[]{this.$diagnostic};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                }
                return list;
            }
        });
        if (this.isTransparent) {
            this.getProblemsReporter$kotlin_gradle_plugin_common().reportProblemDiagnostic(diagnostic, options);
            return;
        }
        if (diagnostic.getSeverity() == ToolingDiagnostic.Severity.FATAL) {
            throw RenderReportedDiagnosticsKt.createAnExceptionForFatalDiagnostic(diagnostic, options);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector$Parameter;", "Lorg/gradle/api/services/BuildServiceParameters;", "problemsReporterFactory", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ProblemsReporter$Factory;", "getProblemsReporterFactory", "()Lorg/gradle/api/provider/Property;", "kotlin-gradle-plugin_common"})
    public static interface Parameter
    extends BuildServiceParameters {
        @NotNull
        public Property<ProblemsReporter.Factory> getProblemsReporterFactory();
    }
}

