/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilerPluginSupportPlugin;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.statistics.MetricContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.plugins.ObservablePlugins;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001aF\u0010\t\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"UNKNOWN_VERSION", "", "addTaskMetrics", "", "project", "Lorg/gradle/api/Project;", "configurationTimeMetrics", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "collectAppliedPluginsStatistics", "collectGeneralConfigurationTimeMetrics", "gradle", "Lorg/gradle/api/invocation/Gradle;", "buildReportOutputs", "", "Lorg/jetbrains/kotlin/gradle/report/BuildReportType;", "pluginVersion", "isProjectIsolationEnabled", "", "isProjectIsolationRequested", "isConfigurationCacheRequested", "collectProjectConfigurationTimeMetrics", "reportLibrariesVersions", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nkotlinBuildStatisticsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinBuildStatisticsUtils.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatisticsUtilsKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n17#2,5:247\n22#2:254\n17#2,6:255\n1851#3,2:252\n1770#3,4:261\n766#3:265\n857#3,2:266\n1851#3,2:268\n*S KotlinDebug\n*F\n+ 1 kotlinBuildStatisticsUtils.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatisticsUtilsKt\n*L\n36#1:247,5\n36#1:254\n76#1:255,6\n38#1:252,2\n161#1:261,4\n203#1:265\n203#1:266,2\n203#1:268,2\n*E\n"})
public final class KotlinBuildStatisticsUtilsKt {
    @NotNull
    private static final String UNKNOWN_VERSION = "0.0.0";

    @NotNull
    public static final MetricContainer collectGeneralConfigurationTimeMetrics(@NotNull Project project, @NotNull Gradle gradle, @NotNull List<? extends BuildReportType> buildReportOutputs, @NotNull String pluginVersion, boolean isProjectIsolationEnabled, boolean isProjectIsolationRequested, boolean isConfigurationCacheRequested) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        Intrinsics.checkNotNullParameter(buildReportOutputs, (String)"buildReportOutputs");
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        MetricContainer configurationTimeMetrics = new MetricContainer();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        configurationTimeMetrics.put(StringMetrics.KOTLIN_COMPILER_VERSION, pluginVersion);
        Iterable $this$forEach$iv = buildReportOutputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildReportType it = (BuildReportType)element$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    configurationTimeMetrics.put(BooleanMetrics.BUILD_SCAN_BUILD_REPORT, true);
                    break;
                }
                case 2: {
                    configurationTimeMetrics.put(BooleanMetrics.FILE_BUILD_REPORT, true);
                    break;
                }
                case 3: {
                    configurationTimeMetrics.put(BooleanMetrics.HTTP_BUILD_REPORT, true);
                    break;
                }
                case 4: {
                    configurationTimeMetrics.put(BooleanMetrics.SINGLE_FILE_BUILD_REPORT, true);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    configurationTimeMetrics.put(BooleanMetrics.JSON_BUILD_REPORT, true);
                }
            }
        }
        String string = project.getRootDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.rootDir.absolutePath");
        configurationTimeMetrics.put(StringMetrics.PROJECT_PATH, string);
        String string2 = gradle.getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gradle.gradleVersion");
        configurationTimeMetrics.put(StringMetrics.GRADLE_VERSION, string2);
        if (!isProjectIsolationEnabled) {
            gradle.getTaskGraph().whenReady(new Action(configurationTimeMetrics){
                final /* synthetic */ MetricContainer $configurationTimeMetrics;
                {
                    this.$configurationTimeMetrics = $configurationTimeMetrics;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void execute(TaskExecutionGraph taskExecutionGraph) {
                    void $this$mapTo$iv$iv;
                    List list = taskExecutionGraph.getAllTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"taskExecutionGraph.allTasks");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Task task2 = (Task)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    List executedTaskNames = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    this.$configurationTimeMetrics.put(BooleanMetrics.MAVEN_PUBLISH_EXECUTED, executedTaskNames.contains("install"));
                }
            });
        }
        configurationTimeMetrics.put(BooleanMetrics.GRADLE_CONFIGURATION_CACHE_ENABLED, isConfigurationCacheRequested);
        configurationTimeMetrics.put(BooleanMetrics.GRADLE_PROJECT_ISOLATION_ENABLED, isProjectIsolationRequested);
        long statisticOverhead2 = System.currentTimeMillis() - start$iv;
        configurationTimeMetrics.put(NumericalMetrics.STATISTICS_VISIT_ALL_PROJECTS_OVERHEAD, statisticOverhead2);
        return configurationTimeMetrics;
    }

    @NotNull
    public static final MetricContainer collectProjectConfigurationTimeMetrics(@NotNull Project project) {
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MetricContainer configurationTimeMetrics = new MetricContainer();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        KotlinBuildStatisticsUtilsKt.collectAppliedPluginsStatistics(project, configurationTimeMetrics);
        Collection collection = project.getConfigurations().getAsMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"project.configurations.asMap.values");
        Collection configurations = collection;
        for (Configuration configuration2 : configurations) {
            try {
                String configurationName = configuration2.getName();
                DependencySet dependencies2 = configuration2.getDependencies();
                String string2 = configurationName;
                if (string2 == null) continue;
                int n = -1;
                switch (string2.hashCode()) {
                    case -2074174337: {
                        if (string2.equals("compileOnly")) {
                            n = 1;
                        }
                        break;
                    }
                    case 950491699: {
                        if (string2.equals("compile")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1683336114: {
                        if (string2.equals("implementation")) {
                            n = 3;
                        }
                        break;
                    }
                    case 3284442: {
                        if (string2.equals("kapt")) {
                            n = 4;
                        }
                        break;
                    }
                    case 1550962648: {
                        if (string2.equals("runtime")) {
                            n = 5;
                        }
                        break;
                    }
                    case 96794: {
                        if (string2.equals("api")) {
                            n = 6;
                        }
                        break;
                    }
                    case 1325346147: {
                        if (string2.equals("KoverEngineConfig")) {
                            n = 7;
                        }
                        break;
                    }
                    case 754694052: {
                        if (string2.equals("runtimeOnly")) {
                            n = 8;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 7: {
                        configurationTimeMetrics.put(BooleanMetrics.ENABLED_KOVER, true);
                        break;
                    }
                    case 4: {
                        configurationTimeMetrics.put(BooleanMetrics.ENABLED_KAPT, true);
                        for (Dependency dependency : dependencies2) {
                            String string3 = dependency.getGroup();
                            if (Intrinsics.areEqual((Object)string3, (Object)"org.jetbrains.kotlin.com.google.dagger")) {
                                configurationTimeMetrics.put(BooleanMetrics.ENABLED_DAGGER, true);
                                continue;
                            }
                            if (!Intrinsics.areEqual((Object)string3, (Object)"com.android.databinding")) continue;
                            configurationTimeMetrics.put(BooleanMetrics.ENABLED_DATABINDING, true);
                        }
                        break;
                    }
                    case 6: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_API_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies2);
                        break;
                    }
                    case 3: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_IMPLEMENTATION_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies2);
                        break;
                    }
                    case 2: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_COMPILE_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies2);
                        break;
                    }
                    case 1: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_COMPILE_ONLY_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies2);
                        break;
                    }
                    case 5: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_RUNTIME_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies2);
                        break;
                    }
                    case 8: {
                        configurationTimeMetrics.put(NumericalMetrics.CONFIGURATION_RUNTIME_ONLY_COUNT, 1L);
                        KotlinBuildStatisticsUtilsKt.reportLibrariesVersions(configurationTimeMetrics, dependencies2);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        configurationTimeMetrics.put(NumericalMetrics.NUMBER_OF_SUBPROJECTS, 1L);
        Object object = project.getBuildscript().getSourceFile();
        if (object != null && (object = (string = ((File)object).getName())) != null) {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
            bl = StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        configurationTimeMetrics.put(BooleanMetrics.KOTLIN_KTS_USED, bl);
        KotlinBuildStatisticsUtilsKt.addTaskMetrics(project, configurationTimeMetrics);
        boolean crossCompilationEnabled = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project).getEnableKlibsCrossCompilation();
        if (!crossCompilationEnabled) {
            configurationTimeMetrics.put(BooleanMetrics.KOTLIN_CROSS_COMPILATION_DISABLED, true);
        }
        if (Intrinsics.areEqual((Object)project.getName(), (Object)"buildSrc")) {
            configurationTimeMetrics.put(NumericalMetrics.BUILD_SRC_COUNT, 1L);
            configurationTimeMetrics.put(BooleanMetrics.BUILD_SRC_EXISTS, true);
        }
        long statisticOverhead2 = System.currentTimeMillis() - start$iv;
        configurationTimeMetrics.put(NumericalMetrics.STATISTICS_VISIT_ALL_PROJECTS_OVERHEAD, statisticOverhead2);
        return configurationTimeMetrics;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addTaskMetrics(Project project, MetricContainer configurationTimeMetrics) {
        try {
            int n;
            void $this$count$iv;
            SortedSet sortedSet = project.getTasks().getNames();
            Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"project.tasks.names");
            List taskNames = CollectionsKt.toList((Iterable)sortedSet);
            configurationTimeMetrics.put(NumericalMetrics.GRADLE_NUMBER_OF_TASKS, taskNames.size());
            Iterable iterable = taskNames;
            NumericalMetrics numericalMetrics = NumericalMetrics.GRADLE_NUMBER_OF_UNCONFIGURED_TASKS;
            MetricContainer metricContainer = configurationTimeMetrics;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    boolean bl;
                    String name2 = (String)element$iv;
                    boolean bl2 = false;
                    try {
                        String string = project.getTasks().named(name2).getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.tasks.named(name).javaClass.name");
                        bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"TaskCreatingProvider", (boolean)false, (int)2, null);
                    }
                    catch (Exception _) {
                        bl = true;
                    }
                    if (!bl || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            metricContainer.put(numericalMetrics, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void collectAppliedPluginsStatistics(Project project, MetricContainer configurationTimeMetrics) {
        for (ObservablePlugins plugin : ObservablePlugins.values()) {
            project.getPlugins().withId(plugin.getTitle(), new Action(configurationTimeMetrics, plugin){
                final /* synthetic */ MetricContainer $configurationTimeMetrics;
                final /* synthetic */ ObservablePlugins $plugin;
                {
                    this.$configurationTimeMetrics = $configurationTimeMetrics;
                    this.$plugin = $plugin;
                }

                public final void execute(Plugin it) {
                    this.$configurationTimeMetrics.put(this.$plugin.getMetric(), true);
                }
            });
        }
        String prefix = "com";
        project.getPlugins().withId(prefix + ".google.devtools.ksp", new Action(configurationTimeMetrics){
            final /* synthetic */ MetricContainer $configurationTimeMetrics;
            {
                this.$configurationTimeMetrics = $configurationTimeMetrics;
            }

            public final void execute(Plugin plugin) {
                try {
                    KotlinCompilerPluginSupportPlugin kotlinCompilerPluginSupportPlugin = plugin instanceof KotlinCompilerPluginSupportPlugin ? (KotlinCompilerPluginSupportPlugin)plugin : null;
                    String version2 = kotlinCompilerPluginSupportPlugin != null && (kotlinCompilerPluginSupportPlugin = kotlinCompilerPluginSupportPlugin.getPluginArtifact()) != null ? kotlinCompilerPluginSupportPlugin.getVersion() : null;
                    String string = version2;
                    if (string == null) {
                        string = "0.0.0";
                    }
                    this.$configurationTimeMetrics.put(StringMetrics.KSP_GRADLE_PLUGIN_VERSION, string);
                }
                catch (Exception _) {
                    this.$configurationTimeMetrics.put(StringMetrics.KSP_GRADLE_PLUGIN_VERSION, "0.0.0");
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void reportLibrariesVersions(MetricContainer configurationTimeMetrics, DependencySet dependencies2) {
        block38: {
            void $this$filterTo$iv$iv;
            DependencySet dependencySet = dependencies2;
            if (dependencySet == null) break block38;
            Iterable $this$filter$iv = (Iterable)dependencySet;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Dependency it = (Dependency)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof ProjectDependency))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                String string2;
                Dependency dependency = (Dependency)element$iv;
                boolean bl5 = false;
                String string3 = string2 = dependency.getGroup();
                if (string3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group");
                    bl4 = StringsKt.startsWith$default((String)string2, (String)"org.springframework", (boolean)false, (int)2, null);
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    String string4;
                    String string5 = string2 = dependency.getVersion();
                    if (string5 == null) {
                        string4 = UNKNOWN_VERSION;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"dependency.version ?: \"0.0.0\"");
                        string4 = string2;
                    }
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_SPRING_VERSION, string4);
                    continue;
                }
                String string6 = string2 = dependency.getGroup();
                if (string6 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"group");
                    bl3 = StringsKt.startsWith$default((String)string2, (String)"com.vaadin", (boolean)false, (int)2, null);
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    String string7;
                    String string8 = string2 = dependency.getVersion();
                    if (string8 == null) {
                        string7 = UNKNOWN_VERSION;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"dependency.version ?: \"0.0.0\"");
                        string7 = string2;
                    }
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_VAADIN_VERSION, string7);
                    continue;
                }
                String string9 = string2 = dependency.getGroup();
                if (string9 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"group");
                    bl2 = StringsKt.startsWith$default((String)string2, (String)"org.jetbrains.kotlin.com.google.gwt", (boolean)false, (int)2, null);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    String string10;
                    String string11 = string2 = dependency.getVersion();
                    if (string11 == null) {
                        string10 = UNKNOWN_VERSION;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"dependency.version ?: \"0.0.0\"");
                        string10 = string2;
                    }
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_GWT_VERSION, string10);
                    continue;
                }
                String string12 = string2 = dependency.getGroup();
                if (string12 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"group");
                    bl = StringsKt.startsWith$default((String)string2, (String)"org.hibernate", (boolean)false, (int)2, null);
                } else {
                    bl = false;
                }
                if (bl) {
                    String string13;
                    String string14 = string2 = dependency.getVersion();
                    if (string14 == null) {
                        string13 = UNKNOWN_VERSION;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"dependency.version ?: \"0.0.0\"");
                        string13 = string2;
                    }
                    configurationTimeMetrics.put(StringMetrics.LIBRARY_HIBERNATE_VERSION, string13);
                    continue;
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlin")) {
                    String string15 = dependency.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"dependency.name");
                    if (StringsKt.startsWith$default((String)string15, (String)"kotlin-stdlib", (boolean)false, (int)2, null)) {
                        String string16;
                        String string17 = string2 = dependency.getVersion();
                        if (string17 == null) {
                            string16 = UNKNOWN_VERSION;
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"dependency.version ?: \"0.0.0\"");
                            string16 = string2;
                        }
                        configurationTimeMetrics.put(StringMetrics.KOTLIN_STDLIB_VERSION, string16);
                        continue;
                    }
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlinx") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"kotlinx-coroutines")) {
                    String string18;
                    String string19 = string2 = dependency.getVersion();
                    if (string19 == null) {
                        string18 = UNKNOWN_VERSION;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"dependency.version ?: \"0.0.0\"");
                        string18 = string2;
                    }
                    configurationTimeMetrics.put(StringMetrics.KOTLIN_COROUTINES_VERSION, string18);
                    continue;
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlin") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"kotlin-reflect")) {
                    String string20;
                    String string21 = string2 = dependency.getVersion();
                    if (string21 == null) {
                        string20 = UNKNOWN_VERSION;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"dependency.version ?: \"0.0.0\"");
                        string20 = string2;
                    }
                    configurationTimeMetrics.put(StringMetrics.KOTLIN_REFLECT_VERSION, string20);
                    continue;
                }
                if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"org.jetbrains.kotlinx")) {
                    String string22 = dependency.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"dependency.name");
                    if (StringsKt.startsWith$default((String)string22, (String)"kotlinx-serialization-runtime", (boolean)false, (int)2, null)) {
                        String string23;
                        String string24 = string2 = dependency.getVersion();
                        if (string24 == null) {
                            string23 = UNKNOWN_VERSION;
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"dependency.version ?: \"0.0.0\"");
                            string23 = string2;
                        }
                        configurationTimeMetrics.put(StringMetrics.KOTLIN_SERIALIZATION_VERSION, string23);
                        continue;
                    }
                }
                if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.android.tools.build")) continue;
                String string25 = dependency.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"dependency.name");
                if (!StringsKt.startsWith$default((String)string25, (String)"gradle", (boolean)false, (int)2, null)) continue;
                String string26 = string2 = dependency.getVersion();
                if (string26 == null) {
                    string = UNKNOWN_VERSION;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"dependency.version ?: \"0.0.0\"");
                    string = string2;
                }
                configurationTimeMetrics.put(StringMetrics.ANDROID_GRADLE_PLUGIN_VERSION, string);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildReportType.values().length];
            try {
                nArray[BuildReportType.BUILD_SCAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.HTTP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.SINGLE_FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.TRY_NEXT_CONSOLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildReportType.JSON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

