/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.config;

import java.util.List;

public class IncrementalCompilation {
    public static final String INCREMENTAL_COMPILATION_JVM_PROPERTY = "kotlin.incremental.compilation";
    public static final String INCREMENTAL_COMPILATION_JS_PROPERTY = "kotlin.incremental.compilation.js";

    public static boolean isEnabledForJvm() {
        return Boolean.valueOf(System.getProperty(INCREMENTAL_COMPILATION_JVM_PROPERTY));
    }

    public static boolean isEnabledForJs() {
        return Boolean.valueOf(System.getProperty(INCREMENTAL_COMPILATION_JS_PROPERTY));
    }

    @Deprecated
    public static void setIsEnabledForJvm(boolean value2) {
        System.setProperty(INCREMENTAL_COMPILATION_JVM_PROPERTY, String.valueOf(value2));
    }

    @Deprecated
    public static void setIsEnabledForJs(boolean value2) {
        System.setProperty(INCREMENTAL_COMPILATION_JS_PROPERTY, String.valueOf(value2));
    }

    @Deprecated
    public static void toJvmArgs(List<String> jvmArgs2) {
        if (IncrementalCompilation.isEnabledForJvm()) {
            IncrementalCompilation.addJvmSystemFlag(jvmArgs2, INCREMENTAL_COMPILATION_JVM_PROPERTY);
        }
        if (IncrementalCompilation.isEnabledForJs()) {
            IncrementalCompilation.addJvmSystemFlag(jvmArgs2, INCREMENTAL_COMPILATION_JS_PROPERTY);
        }
    }

    private static void addJvmSystemFlag(List<String> jvmArgs2, String name2) {
        jvmArgs2.add("D" + name2 + "=true");
    }
}

