/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.JsonElement;
import org.jetbrains.kotlin.com.google.gson.JsonObject;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.CheckXcodeTargetsConfigurationTaskKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeProjectStructure;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@DisableCachingByDefault(because="This task's output is a diagnostic, which should be re-evaluated on each build.")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b!\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u0013J8\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JB\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckXcodeTargetsConfigurationTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnostics;", "()V", "appleTargets", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getAppleTargets", "()Lorg/gradle/api/provider/ListProperty;", "pbxprojJson", "Lorg/gradle/api/file/RegularFileProperty;", "getPbxprojJson", "()Lorg/gradle/api/file/RegularFileProperty;", "xcodeProjectPath", "Lorg/gradle/api/file/DirectoryProperty;", "getXcodeProjectPath", "()Lorg/gradle/api/file/DirectoryProperty;", "checkXcodeTargets", "", "checkXcodeTargets$kotlin_gradle_plugin_common", "getConfigurationMap", "", "", "objects", "Lorg/jetbrains/kotlin/com/google/gson/JsonObject;", "listId", "gson", "Lorg/jetbrains/kotlin/com/google/gson/Gson;", "parseSingleNativeTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/XcodeProjectStructure$XcodeTarget;", "targetId", "projectConfigs", "parseXcodeTargets", "", "pbxprojContent", "logger", "Lorg/gradle/api/logging/Logger;", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nCheckXcodeTargetsConfigurationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckXcodeTargetsConfigurationTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckXcodeTargetsConfigurationTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n766#2:392\n857#2,2:393\n1360#2:395\n1446#2,5:396\n1603#2,9:401\n1851#2:410\n1852#2:412\n1612#2:413\n1851#2,2:415\n1603#2,9:417\n1851#2:426\n1852#2:428\n1612#2:429\n1#3:411\n1#3:414\n1#3:427\n*S KotlinDebug\n*F\n+ 1 CheckXcodeTargetsConfigurationTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckXcodeTargetsConfigurationTask\n*L\n212#1:392\n212#1:393,2\n224#1:395\n224#1:396,5\n254#1:401,9\n254#1:410\n254#1:412\n254#1:413\n292#1:415,2\n320#1:417,9\n320#1:426\n320#1:428\n320#1:429\n254#1:411\n320#1:427\n*E\n"})
public abstract class CheckXcodeTargetsConfigurationTask
extends DefaultTask
implements UsesKotlinToolingDiagnostics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TASK_NAME = "checkXcodeProjectConfiguration";

    public CheckXcodeTargetsConfigurationTask() {
        this.onlyIf("Task can only run on macOS", 1.INSTANCE);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getXcodeProjectPath();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getPbxprojJson();

    @Internal
    @NotNull
    public abstract ListProperty<KonanTarget> getAppleTargets();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void checkXcodeTargets$kotlin_gradle_plugin_common() {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        String pbxprojContent = FilesKt.readText$default((File)FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.getPbxprojJson())), null, (int)1, null);
        if (StringsKt.isBlank((CharSequence)pbxprojContent) || Intrinsics.areEqual((Object)pbxprojContent, (Object)"{}")) {
            return;
        }
        Gson gson2 = new Gson();
        Logger logger2 = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        Set<XcodeProjectStructure.XcodeTarget> set = this.parseXcodeTargets(pbxprojContent, gson2, logger2);
        if (set == null) {
            return;
        }
        Set<XcodeProjectStructure.XcodeTarget> xcodeTargets = set;
        Iterable $this$filter$iv = xcodeTargets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XcodeProjectStructure.XcodeTarget it = (XcodeProjectStructure.XcodeTarget)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getProductType(), (Object)"com.apple.product-type.application") || Intrinsics.areEqual((Object)it.getProductType(), (Object)"com.apple.product-type.application.watchapp2-container"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List xcodeAppTargets = (List)destination$iv$iv;
        if (xcodeAppTargets.isEmpty()) {
            this.reportDiagnostic(KotlinToolingDiagnostics.NoApplicationTargetFoundDiagnostic.INSTANCE.invoke(FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getXcodeProjectPath()))));
            return;
        }
        Iterable $this$flatMap$iv = xcodeAppTargets;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            XcodeProjectStructure.XcodeTarget it = (XcodeProjectStructure.XcodeTarget)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getPlatforms();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set allXcodeAppPlatforms = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        List missingTargets = new ArrayList();
        for (KonanTarget kotlinTarget : (List)this.getAppleTargets().get()) {
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTarget, (String)"kotlinTarget");
            String expectedSdkRoot = CheckXcodeTargetsConfigurationTaskKt.access$getExpectedSdkRoot(kotlinTarget);
            if (Intrinsics.areEqual((Object)expectedSdkRoot, (Object)"unknown") || allXcodeAppPlatforms.contains(expectedSdkRoot)) continue;
            missingTargets.add(kotlinTarget);
        }
        if (!((Collection)missingTargets).isEmpty()) {
            this.reportDiagnostic(KotlinToolingDiagnostics.MissingXcodeTargetDiagnostic.INSTANCE.invoke(missingTargets, FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getXcodeProjectPath()))));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<XcodeProjectStructure.XcodeTarget> parseXcodeTargets(String pbxprojContent, Gson gson2, Logger logger2) {
        try {
            void $this$mapNotNullTo$iv$iv;
            XcodeProjectStructure.Pbxproj pbxproj = gson2.fromJson(pbxprojContent, XcodeProjectStructure.Pbxproj.class);
            Map<String, JsonObject> objects = pbxproj.getObjects();
            JsonObject jsonObject = objects.get(pbxproj.getRootObject());
            if (jsonObject == null) {
                return SetsKt.emptySet();
            }
            JsonObject rootProjectJson = jsonObject;
            XcodeProjectStructure.PbxProject rootProject = gson2.fromJson((JsonElement)rootProjectJson, XcodeProjectStructure.PbxProject.class);
            Map<String, String> projectConfigs = this.getConfigurationMap(objects, rootProject.getBuildConfigurationList(), gson2);
            Iterable $this$mapNotNull$iv = rootProject.getTargets();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                XcodeProjectStructure.XcodeTarget it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String targetId = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.parseSingleNativeTarget(targetId, objects, projectConfigs, gson2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        catch (Exception exception) {
            logger2.error("Failed to parse the JSON file for '" + FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.getXcodeProjectPath())).getPath() + "'. The file might be malformed.", (Throwable)exception);
            return null;
        }
    }

    private final XcodeProjectStructure.XcodeTarget parseSingleNativeTarget(String targetId, Map<String, JsonObject> objects, Map<String, String> projectConfigs, Gson gson2) {
        JsonObject jsonObject = objects.get(targetId);
        if (jsonObject == null) {
            return null;
        }
        JsonObject targetJson = jsonObject;
        JsonElement jsonElement = targetJson.get("isa");
        if (!Intrinsics.areEqual((Object)(jsonElement != null ? jsonElement.getAsString() : null), (Object)"PBXNativeTarget")) {
            return null;
        }
        XcodeProjectStructure.PbxNativeTarget nativeTarget = gson2.fromJson((JsonElement)targetJson, XcodeProjectStructure.PbxNativeTarget.class);
        Map<String, String> targetConfigs = this.getConfigurationMap(objects, nativeTarget.getBuildConfigurationList(), gson2);
        Set platforms2 = new LinkedHashSet();
        for (Map.Entry<String, String> entry2 : targetConfigs.entrySet()) {
            String sdkRoot;
            String supportedPlatforms;
            String string;
            Object projectSettings;
            XcodeProjectStructure.XCBuildConfiguration xCBuildConfiguration;
            String configName = entry2.getKey();
            String configId = entry2.getValue();
            XcodeProjectStructure.XCBuildConfiguration targetConfig = gson2.fromJson((JsonElement)objects.get(configId), XcodeProjectStructure.XCBuildConfiguration.class);
            String projectConfigId = projectConfigs.get(configName);
            if (projectConfigId != null) {
                String it;
                boolean bl = false;
                xCBuildConfiguration = gson2.fromJson((JsonElement)objects.get(it), XcodeProjectStructure.XCBuildConfiguration.class);
            } else {
                xCBuildConfiguration = null;
            }
            XcodeProjectStructure.XCBuildConfiguration projectConfig = xCBuildConfiguration;
            XcodeProjectStructure.BuildSettings targetSettings = targetConfig.getBuildSettings();
            Object object = projectConfig;
            if (object == null || (object = ((XcodeProjectStructure.XCBuildConfiguration)object).getBuildSettings()) == null) {
                object = projectSettings = new XcodeProjectStructure.BuildSettings(null, null, null, null, null, null, 63, null);
            }
            if ((string = targetSettings.getSupportedPlatforms()) == null) {
                string = ((XcodeProjectStructure.BuildSettings)projectSettings).getSupportedPlatforms();
            }
            if ((supportedPlatforms = string) != null) {
                String[] stringArray = new String[]{" "};
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)supportedPlatforms, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String sdk = (String)element$iv;
                    boolean bl = false;
                    if (!(!StringsKt.isBlank((CharSequence)sdk))) continue;
                    platforms2.add(sdk);
                }
                continue;
            }
            String string2 = targetSettings.getSdkRoot();
            if (string2 == null) {
                string2 = ((XcodeProjectStructure.BuildSettings)projectSettings).getSdkRoot();
            }
            if ((sdkRoot = string2) == null) continue;
            platforms2.add(sdkRoot);
        }
        return !((Collection)platforms2).isEmpty() ? new XcodeProjectStructure.XcodeTarget(nativeTarget.getName(), nativeTarget.getProductType(), platforms2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getConfigurationMap(Map<String, JsonObject> objects, String listId, Gson gson2) {
        void $this$mapNotNullTo$iv$iv;
        JsonObject jsonObject = objects.get(listId);
        if (jsonObject == null) {
            return MapsKt.emptyMap();
        }
        JsonObject configListJson = jsonObject;
        XcodeProjectStructure.XCConfigurationList configList = gson2.fromJson((JsonElement)configListJson, XcodeProjectStructure.XCConfigurationList.class);
        Iterable $this$mapNotNull$iv = configList.getBuildConfigurations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String id = (String)element$iv$iv;
            boolean bl2 = false;
            if (objects.get(id) == null) {
                pair = null;
            } else {
                JsonObject configJson;
                XcodeProjectStructure.XCBuildConfiguration config = gson2.fromJson((JsonElement)configJson, XcodeProjectStructure.XCBuildConfiguration.class);
                pair = TuplesKt.to((Object)config.getName(), (Object)id);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        UsesKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckXcodeTargetsConfigurationTask$Companion;", "", "()V", "TASK_NAME", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

