/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.native.tasks.AbstractPodInstallTask;
import org.jetbrains.kotlin.gradle.targets.native.tasks.CocoapodsTask;
import org.jetbrains.kotlin.gradle.utils.CommandFallback;
import org.jetbrains.kotlin.gradle.utils.ProcessUtilsKt;
import org.jetbrains.kotlin.gradle.utils.RunProcessResult;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J \u0010 \u001a\u0004\u0018\u00010\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\r8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/AbstractPodInstallTask;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/CocoapodsTask;", "()V", "podExecutablePath", "Lorg/gradle/api/file/RegularFileProperty;", "getPodExecutablePath", "()Lorg/gradle/api/file/RegularFileProperty;", "podfile", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPodfile", "()Lorg/gradle/api/provider/Property;", "podsDir", "Lorg/gradle/api/provider/Provider;", "getPodsDir$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Provider;", "podsXcodeProjDirProvider", "getPodsXcodeProjDirProvider$kotlin_gradle_plugin_common", "workingDir", "getWorkingDir", "doPodInstall", "", "handleError", "", "result", "Lorg/jetbrains/kotlin/gradle/utils/RunProcessResult;", "missingPodsError", "podExecutable", "runPodInstall", "updateRepo", "", "runWhichPod", "sharedHandleError", "podInstallCommand", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAbstractPodInstallTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPodInstallTask.kt\norg/jetbrains/kotlin/gradle/targets/native/tasks/AbstractPodInstallTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public abstract class AbstractPodInstallTask
extends CocoapodsTask {
    @NotNull
    private final Provider<File> workingDir;
    @NotNull
    private final Provider<File> podsDir;
    @NotNull
    private final Provider<File> podsXcodeProjDirProvider;

    public AbstractPodInstallTask() {
        this.onlyIf("Podfile location is set", new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                return this.getPodfile().isPresent();
            }
        });
        Provider provider2 = this.getPodfile().map((Transformer)workingDir.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"podfile.map { file: File\u2026ipped\" }.parentFile\n    }");
        this.workingDir = provider2;
        Provider provider3 = this.workingDir.map((Transformer)podsDir.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"workingDir.map { it.resolve(\"Pods\") }");
        this.podsDir = provider3;
        Provider provider4 = this.podsDir.map((Transformer)podsXcodeProjDirProvider.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"podsDir.map { it.resolve(\"Pods.xcodeproj\") }");
        this.podsXcodeProjDirProvider = provider4;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFile
    @NotNull
    public abstract Property<File> getPodfile();

    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPodExecutablePath();

    @Internal
    @NotNull
    protected final Provider<File> getWorkingDir() {
        return this.workingDir;
    }

    @OutputDirectory
    @NotNull
    public final Provider<File> getPodsDir$kotlin_gradle_plugin_common() {
        return this.podsDir;
    }

    @Internal
    @NotNull
    public final Provider<File> getPodsXcodeProjDirProvider$kotlin_gradle_plugin_common() {
        return this.podsXcodeProjDirProvider;
    }

    @TaskAction
    public void doPodInstall() {
        this.runPodInstall(false);
        File $this$doPodInstall_u24lambda_u241 = (File)this.podsXcodeProjDirProvider.get();
        boolean bl = false;
        if (!($this$doPodInstall_u24lambda_u241.exists() && $this$doPodInstall_u24lambda_u241.isDirectory())) {
            boolean bl2 = false;
            String string = "The directory 'Pods/Pods.xcodeproj' was not created as a result of the `pod install` call.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final String podExecutable() {
        String string;
        File podPath;
        RegularFile regularFile = (RegularFile)this.getPodExecutablePath().getOrNull();
        File file2 = podPath = regularFile != null ? regularFile.getAsFile() : null;
        if (file2 != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = file2.getAbsolutePath();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = this.runWhichPod();
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"podPath.absolutePath.ifBlank { runWhichPod() }");
            string = (String)charSequence;
        } else {
            string = this.runWhichPod();
        }
        return string;
    }

    private final String runWhichPod() {
        Object[] objectArray = new String[]{"which", "pod"};
        List checkPodCommand = CollectionsKt.listOf((Object[])objectArray);
        String output2 = ProcessUtilsKt.runCommand$default(checkPodCommand, this.getLogger(), (Function1)new Function1<RunProcessResult, String>(this, (List<String>)checkPodCommand){
            final /* synthetic */ AbstractPodInstallTask this$0;
            final /* synthetic */ List<String> $checkPodCommand;
            {
                this.this$0 = $receiver;
                this.$checkPodCommand = $checkPodCommand;
                super(1);
            }

            public final String invoke(RunProcessResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                return result2.getRetCode() == 1 ? AbstractPodInstallTask.access$missingPodsError(this.this$0) : AbstractPodInstallTask.access$sharedHandleError(this.this$0, this.$checkPodCommand, result2);
            }
        }, null, 8, null);
        CharSequence charSequence = StringUtilsKt.removingTrailingNewline(output2);
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl = false;
            throw new IllegalStateException(this.missingPodsError());
        }
        return (String)charSequence;
    }

    private final String runPodInstall(boolean updateRepo) {
        Object[] objectArray = new String[]{this.podExecutable(), "install", updateRepo ? "--repo-update" : null};
        List podInstallCommand = CollectionsKt.listOfNotNull((Object[])objectArray);
        return ProcessUtilsKt.runCommandWithFallback(podInstallCommand, this.getLogger(), (Function1<? super RunProcessResult, ? extends CommandFallback>)((Function1)new Function1<RunProcessResult, CommandFallback>(updateRepo, this, (List<String>)podInstallCommand){
            final /* synthetic */ boolean $updateRepo;
            final /* synthetic */ AbstractPodInstallTask this$0;
            final /* synthetic */ List<String> $podInstallCommand;
            {
                this.$updateRepo = $updateRepo;
                this.this$0 = $receiver;
                this.$podInstallCommand = $podInstallCommand;
                super(1);
            }

            public final CommandFallback invoke(RunProcessResult result2) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                CharSequence charSequence2 = result2.getStdErr();
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    charSequence = result2.getStdOut();
                } else {
                    charSequence = charSequence2;
                }
                String output2 = (String)charSequence;
                return StringsKt.contains$default((CharSequence)output2, (CharSequence)"out-of-date source repos which you can update with `pod repo update` or with `pod install --repo-update`", (boolean)false, (int)2, null) && !this.$updateRepo ? (CommandFallback)new CommandFallback.Action(AbstractPodInstallTask.access$runPodInstall(this.this$0, true)) : (CommandFallback)new CommandFallback.Error(AbstractPodInstallTask.access$sharedHandleError(this.this$0, this.$podInstallCommand, result2));
            }
        }), (Function1<? super ProcessBuilder, Unit>)((Function1)new Function1<ProcessBuilder, Unit>(this){
            final /* synthetic */ AbstractPodInstallTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ProcessBuilder $this$runCommandWithFallback) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommandWithFallback, (String)"$this$runCommandWithFallback");
                $this$runCommandWithFallback.directory((File)this.this$0.getWorkingDir().get());
                $this$runCommandWithFallback.environment().putIfAbsent("LC_ALL", "en_US.UTF-8");
            }
        }));
    }

    private final String sharedHandleError(List<String> podInstallCommand, RunProcessResult result2) {
        CharSequence charSequence;
        String command = CollectionsKt.joinToString$default((Iterable)podInstallCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        CharSequence charSequence2 = result2.getStdErr();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = result2.getStdOut();
        } else {
            charSequence = charSequence2;
        }
        String output2 = (String)charSequence;
        String message2 = StringsKt.trimMargin$default((String)("\n            |'" + command + "' command failed with an exception:\n            | stdErr: " + result2.getStdErr() + "\n            | stdOut: " + result2.getStdOut() + "\n            | exitCode: " + result2.getRetCode() + "\n            |        \n        "), null, (int)1, null);
        if (StringsKt.contains$default((CharSequence)output2, (CharSequence)"No such file or directory", (boolean)false, (int)2, null)) {
            message2 = message2 + StringsKt.trimMargin$default((String)(" \n               |        Full command: " + command + "\n               |        \n               |        Possible reason: CocoaPods is not installed\n               |        Please check that CocoaPods v1.14 or above is installed.\n               |        \n               |        To check CocoaPods version type 'pod --version' in the terminal\n               |        To install CocoaPods execute 'sudo gem install cocoapods'\n               |        For more information, refer to the documentation: https://kotl.in/fx2sde\n               |\n            "), null, (int)1, null);
            return message2;
        }
        if (StringsKt.contains$default((CharSequence)output2, (CharSequence)"[Xcodeproj] Unknown object version", (boolean)false, (int)2, null)) {
            message2 = message2 + StringsKt.trimMargin$default((String)"\n               |        Your CocoaPods installation may be outdated or corrupted\n               |\n               |        To update CocoaPods execute 'sudo gem install cocoapods'\n               |        For more information, refer to the documentation: https://kotl.in/0xfxux\n               |\n            ", null, (int)1, null);
            return message2;
        }
        return this.handleError(result2);
    }

    private final String missingPodsError() {
        return StringsKt.trimMargin$default((String)"\n                  |        ERROR: CocoaPods executable not found in your PATH.\n                  |        Please make sure CocoaPods is installed on your system.\n                  |\n                  |        You can install CocoaPods using the following command:\n                  |        $ sudo gem install cocoapods\n                  |\n                  |        If CocoaPods is already installed and not in your PATH, you can define the\n                  |        CocoaPods executable path in the local.properties file by executing the following:\n                  |        $ echo -e \"kotlin.apple.cocoapods.bin=$(which pod)\" >> local.properties\n                  |\n                  |        For more information, refer to the documentation: https://kotl.in/hxxwtk\n                  |        \n               ", null, (int)1, null);
    }

    @Nullable
    public abstract String handleError(@NotNull RunProcessResult var1);

    public static final /* synthetic */ String access$missingPodsError(AbstractPodInstallTask $this) {
        return $this.missingPodsError();
    }

    public static final /* synthetic */ String access$sharedHandleError(AbstractPodInstallTask $this, List podInstallCommand, RunProcessResult result2) {
        return $this.sharedHandleError(podInstallCommand, result2);
    }

    public static final /* synthetic */ String access$runPodInstall(AbstractPodInstallTask $this, boolean updateRepo) {
        return $this.runPodInstall(updateRepo);
    }
}

