/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.backend.common.serialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.gradle.internal.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.gradle.internal.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.gradle.internal.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.gradle.internal.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.gradle.internal.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.gradle.internal.ir.util.IdSignature;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0016H\u0002J\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R%\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/IrFileDeserializer;", "", "file", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrFile;", "libraryFile", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/IrLibraryFile;", "fileProto", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/proto/IrFile;", "symbolDeserializer", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/IrSymbolDeserializer;", "declarationDeserializer", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/IrDeclarationDeserializer;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;)V", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "getDeclarationDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "reversedSignatureIndex", "", "Lorg/jetbrains/kotlin/gradle/internal/ir/util/IdSignature;", "", "kotlin.jvm.PlatformType", "getReversedSignatureIndex", "()Ljava/util/Map;", "protoAnnotationsPendingDeserialization", "", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/proto/IrConstructorCall;", "deserializeDeclaration", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrDeclaration;", "idSig", "loadTopLevelDeclarationProto", "Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/proto/IrDeclaration;", "deserializeFileImplicitDataIfFirstUse", "", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrFileDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1220#2,2:306\n1249#2,4:308\n*S KotlinDebug\n*F\n+ 1 IrFileDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer\n*L\n39#1:306,2\n39#1:308,4\n*E\n"})
public final class IrFileDeserializer {
    @NotNull
    private final org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFile file;
    @NotNull
    private final IrLibraryFile libraryFile;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final IrDeclarationDeserializer declarationDeserializer;
    @NotNull
    private final Map<IdSignature, Integer> reversedSignatureIndex;
    @Nullable
    private List<IrConstructorCall> protoAnnotationsPendingDeserialization;

    /*
     * WARNING - void declaration
     */
    public IrFileDeserializer(@NotNull org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFile file2, @NotNull IrLibraryFile libraryFile, @NotNull IrFile fileProto, @NotNull IrSymbolDeserializer symbolDeserializer2, @NotNull IrDeclarationDeserializer declarationDeserializer) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)fileProto, (String)"fileProto");
        Intrinsics.checkNotNullParameter((Object)symbolDeserializer2, (String)"symbolDeserializer");
        Intrinsics.checkNotNullParameter((Object)declarationDeserializer, (String)"declarationDeserializer");
        this.file = file2;
        this.libraryFile = libraryFile;
        this.symbolDeserializer = symbolDeserializer2;
        this.declarationDeserializer = declarationDeserializer;
        List<Integer> list = fileProto.getDeclarationIdList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclarationIdList(...)");
        Iterable iterable = list;
        IrFileDeserializer irFileDeserializer = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_10 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Integer n = (Integer)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            map.put(this.symbolDeserializer.deserializeIdSignature(it.intValue()), element$iv$iv);
        }
        irFileDeserializer.reversedSignatureIndex = destination$iv$iv;
        this.protoAnnotationsPendingDeserialization = fileProto.getAnnotationList();
    }

    @NotNull
    public final org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFile getFile() {
        return this.file;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrDeclarationDeserializer getDeclarationDeserializer() {
        return this.declarationDeserializer;
    }

    @NotNull
    public final Map<IdSignature, Integer> getReversedSignatureIndex() {
        return this.reversedSignatureIndex;
    }

    @NotNull
    public final org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclaration deserializeDeclaration(@NotNull IdSignature idSig) {
        org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclaration irDeclaration;
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclaration it = irDeclaration = IrDeclarationDeserializer.deserializeDeclaration$default(this.declarationDeserializer, this.loadTopLevelDeclarationProto(idSig), false, 2, null);
        boolean bl = false;
        ((Collection)this.file.getDeclarations()).add(it);
        return irDeclaration;
    }

    private final IrDeclaration loadTopLevelDeclarationProto(IdSignature idSig) {
        Integer n = this.reversedSignatureIndex.get(idSig);
        if (n == null) {
            throw new IllegalStateException(("Not found Idx for " + idSig).toString());
        }
        int idSigIndex = n;
        return this.libraryFile.declaration(idSigIndex);
    }

    public final boolean deserializeFileImplicitDataIfFirstUse() {
        List<IrConstructorCall> list = this.protoAnnotationsPendingDeserialization;
        if (list != null) {
            List<IrConstructorCall> it = list;
            boolean bl = false;
            org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFile irFile = this.file;
            irFile.setAnnotations(CollectionsKt.plus((Collection)irFile.getAnnotations(), (Iterable)this.declarationDeserializer.deserializeAnnotations$ir_serialization_common(it)));
            this.protoAnnotationsPendingDeserialization = null;
            return true;
        }
        return false;
    }
}

