/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0010"}, d2={"copyZipFilePartially", "", "sourceZipFile", "Ljava/io/File;", "destinationZipFile", "path", "", "ensureValidZipDirectoryPath", "isValidZipDirectoryPath", "", "requireValidZipDirectoryPath", "copyPartially", "Ljava/util/zip/ZipFile;", "listDescendants", "Lkotlin/sequences/Sequence;", "Ljava/util/zip/ZipEntry;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nzipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 zipUtils.kt\norg/jetbrains/kotlin/gradle/utils/ZipUtilsKt\n+ 2 fileUtils.kt\norg/jetbrains/kotlin/gradle/utils/FileUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n232#2,12:67\n232#2,3:79\n232#2,12:84\n242#2,2:97\n235#2,6:99\n1851#3:82\n1852#3:96\n1#4:83\n*S KotlinDebug\n*F\n+ 1 zipUtils.kt\norg/jetbrains/kotlin/gradle/utils/ZipUtilsKt\n*L\n15#1:67,12\n23#1:79,3\n39#1:84,12\n23#1:97,2\n23#1:99,6\n24#1:82\n24#1:96\n*E\n"})
public final class ZipUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyZipFilePartially(@NotNull File sourceZipFile, @NotNull File destinationZipFile, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)sourceZipFile, (String)"sourceZipFile");
        Intrinsics.checkNotNullParameter((Object)destinationZipFile, (String)"destinationZipFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        AutoCloseable $this$use$iv = new ZipFile(sourceZipFile);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            ZipFile zip = (ZipFile)$this$use$iv;
            boolean bl = false;
            ZipUtilsKt.copyPartially(zip, destinationZipFile, path);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyPartially(@NotNull ZipFile $this$copyPartially, @NotNull File destinationZipFile, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$copyPartially, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationZipFile, (String)"destinationZipFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        List entries2 = SequencesKt.toList(ZipUtilsKt.listDescendants($this$copyPartially, path));
        if (entries2.isEmpty()) {
            return;
        }
        AutoCloseable $this$use$iv = new ZipOutputStream(new FileOutputStream(destinationZipFile));
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            ZipOutputStream destinationZipOutputStream = (ZipOutputStream)$this$use$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = entries2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileTime it;
                FileTime fileTime;
                ZipEntry sourceEntry = (ZipEntry)element$iv;
                boolean bl2 = false;
                String string = sourceEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceEntry.name");
                ZipEntry destinationEntry = new ZipEntry(StringsKt.substringAfter$default((String)string, (String)path, null, (int)2, null));
                FileTime fileTime2 = fileTime = sourceEntry.getLastAccessTime();
                if (fileTime2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"lastAccessTime");
                    it = fileTime;
                    boolean bl3 = false;
                    destinationEntry.setLastAccessTime(it);
                }
                FileTime fileTime3 = fileTime = sourceEntry.getLastModifiedTime();
                if (fileTime3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime3, (String)"lastModifiedTime");
                    it = fileTime;
                    boolean bl4 = false;
                    destinationEntry.setLastModifiedTime(it);
                }
                FileTime fileTime4 = fileTime = sourceEntry.getCreationTime();
                if (fileTime4 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime4, (String)"creationTime");
                    it = fileTime;
                    boolean bl5 = false;
                    destinationEntry.setCreationTime(it);
                }
                destinationEntry.setComment(sourceEntry.getComment());
                destinationEntry.setExtra(sourceEntry.getExtra());
                destinationEntry.setCrc(sourceEntry.getCrc());
                destinationEntry.setSize(sourceEntry.getSize());
                destinationEntry.setMethod(sourceEntry.getMethod());
                destinationZipOutputStream.putNextEntry(destinationEntry);
                if (!sourceEntry.isDirectory()) {
                    AutoCloseable $this$use$iv2 = $this$copyPartially.getInputStream(sourceEntry);
                    boolean $i$f$use2 = false;
                    boolean closed$iv2 = false;
                    try {
                        InputStream inputStream22 = (InputStream)$this$use$iv2;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream22, (String)"inputStream");
                        long inputStream22 = ByteStreamsKt.copyTo$default((InputStream)inputStream22, (OutputStream)destinationZipOutputStream, (int)0, (int)2, null);
                    }
                    catch (Exception e$iv) {
                        try {
                            closed$iv2 = true;
                            try {
                                AutoCloseable autoCloseable = $this$use$iv2;
                                if (autoCloseable != null) {
                                    autoCloseable.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw e$iv;
                        }
                        catch (Throwable throwable) {
                            if (!closed$iv2) {
                                AutoCloseable autoCloseable = $this$use$iv2;
                                if (autoCloseable != null) {
                                    autoCloseable.close();
                                }
                            }
                            throw throwable;
                        }
                    }
                    AutoCloseable autoCloseable = $this$use$iv2;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                destinationZipOutputStream.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
    }

    @NotNull
    public static final Sequence<ZipEntry> listDescendants(@NotNull ZipFile $this$listDescendants, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$listDescendants, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        Enumeration<? extends ZipEntry> enumeration = $this$listDescendants.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries()");
        return SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<ZipEntry, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZipEntry entry2) {
                boolean bl;
                if (!Intrinsics.areEqual((Object)entry2.getName(), (Object)this.$path)) {
                    String string = entry2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                    if (StringsKt.startsWith$default((String)string, (String)this.$path, (boolean)false, (int)2, null)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    @NotNull
    public static final String ensureValidZipDirectoryPath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (ZipUtilsKt.isValidZipDirectoryPath(path)) {
            return path;
        }
        String p0 = string = path + '/';
        boolean bl = false;
        ZipUtilsKt.requireValidZipDirectoryPath(p0);
        return string;
    }

    private static final void requireValidZipDirectoryPath(String path) {
        if (!ZipUtilsKt.isValidZipDirectoryPath(path)) {
            boolean bl = false;
            String string = "Expected path to end with '/', found '" + path + '\'';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final boolean isValidZipDirectoryPath(String path) {
        return ((CharSequence)path).length() == 0 || StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null);
    }
}

