/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmRecordApplicabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JvmRecordApplicabilityChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public JvmRecordApplicabilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        List list;
        Object reportSupertypeOn;
        Object modifierOrName;
        KtElementImplStub reportOn;
        Object v0;
        KtAnnotationEntry it;
        Object element$iv;
        Object object;
        KtSuperTypeListEntry supertypeEntry22;
        block21: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor2 instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
                return;
            }
            for (KtSuperTypeListEntry supertypeEntry22 : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
                ClassifierDescriptor classifierDescriptor;
                KotlinType kotlinType = (KotlinType)context.getTrace().get((ReadOnlySlice)BindingContext.TYPE, (Object)supertypeEntry22.getTypeReference());
                KotlinType kotlinType2 = kotlinType;
                if (!Intrinsics.areEqual(kotlinType2 == null ? null : ((classifierDescriptor = (object = kotlinType2.getConstructor()).getDeclarationDescriptor()) == null ? null : DescriptorUtilsKt.fqNameOrNull(classifierDescriptor)), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
                context.getTrace().report((Diagnostic)ErrorsJvm.ILLEGAL_JAVA_LANG_RECORD_SUPERTYPE.on((PsiElement)supertypeEntry22));
                return;
            }
            if (!JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)descriptor2)) {
                return;
            }
            List list2 = ((KtClassOrObject)declaration).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"declaration.annotationEntries");
            Iterable iterable = list2;
            boolean $i$f$firstOrNull = false;
            object = iterable.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)JvmAnnotationUtilKt.getJVM_RECORD_ANNOTATION_FQ_NAME().shortName())) continue;
                v0 = element$iv;
                break block21;
            }
            v0 = null;
        }
        supertypeEntry22 = v0;
        KtElementImplStub ktElementImplStub = reportOn = supertypeEntry22 == null ? (KtElementImplStub)declaration : (KtElementImplStub)supertypeEntry22;
        if (DescriptorUtilsKt.resolveTopLevelClass(context.getModuleDescriptor(), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FOR_DEFAULT_IMPORTS) == null) {
            context.getTrace().report((Diagnostic)ErrorsJvm.JVM_RECORD_REQUIRES_JDK15.on((PsiElement)reportOn));
            return;
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmRecordSupport)) {
            context.getTrace().report((Diagnostic)Errors.UNSUPPORTED_FEATURE.on((PsiElement)reportOn, (Object)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)context.getLanguageVersionSettings())));
            return;
        }
        if (!JvmRecordApplicabilityCheckerKt.access$areRecordsAllowed(this.jvmTarget, context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview()))) {
            context.getTrace().report((Diagnostic)ErrorsJvm.JVM_RECORDS_ILLEGAL_BYTECODE_TARGET.on((PsiElement)reportOn));
            return;
        }
        if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS) {
            PsiElement $i$f$firstOrNull;
            object = ((KtClassOrObject)declaration).getModifierList();
            PsiElement psiElement = $i$f$firstOrNull = object == null ? null : object.getModifier(KtTokens.ENUM_KEYWORD);
            PsiElement psiElement2 = $i$f$firstOrNull == null ? ((object = ((KtClassOrObject)declaration).getNameIdentifier()) == null ? (PsiElement)declaration : object) : $i$f$firstOrNull;
            modifierOrName = psiElement2;
            context.getTrace().report((Diagnostic)ErrorsJvm.ENUM_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (!ModalityUtilsKt.isFinalClass((ClassDescriptor)descriptor2)) {
            KtModifierList ktModifierList;
            KtModifierList ktModifierList2;
            KtModifierList $i$f$firstOrNull = ((KtClassOrObject)declaration).getModifierList();
            if ($i$f$firstOrNull == null) {
                ktModifierList2 = null;
            } else {
                object = new KtModifierKeywordToken[3];
                element$iv = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(element$iv, (String)"ABSTRACT_KEYWORD");
                object[0] = element$iv;
                element$iv = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(element$iv, (String)"OPEN_KEYWORD");
                object[1] = element$iv;
                element$iv = KtTokens.SEALED_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(element$iv, (String)"SEALED_KEYWORD");
                object[2] = element$iv;
                ktModifierList2 = ktModifierList = JvmRecordApplicabilityCheckerKt.access$findOneOfModifiers($i$f$firstOrNull, (KtModifierKeywordToken[])object);
            }
            modifierOrName = ktModifierList == null ? (($i$f$firstOrNull = ((KtClassOrObject)declaration).getNameIdentifier()) == null ? (PsiElement)declaration : $i$f$firstOrNull) : ktModifierList;
            context.getTrace().report((Diagnostic)ErrorsJvm.NON_FINAL_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (((ClassDescriptor)descriptor2).isInner()) {
            PsiElement $i$f$firstOrNull;
            object = ((KtClassOrObject)declaration).getModifierList();
            PsiElement psiElement = $i$f$firstOrNull = object == null ? null : object.getModifier(KtTokens.INNER_KEYWORD);
            PsiElement psiElement3 = $i$f$firstOrNull == null ? ((object = ((KtClassOrObject)declaration).getNameIdentifier()) == null ? (PsiElement)declaration : object) : $i$f$firstOrNull;
            modifierOrName = psiElement3;
            context.getTrace().report((Diagnostic)ErrorsJvm.INNER_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (DescriptorUtils.isLocal(descriptor2)) {
            context.getTrace().report((Diagnostic)ErrorsJvm.LOCAL_JVM_RECORD.on((PsiElement)reportOn));
            return;
        }
        for (KtDeclaration ktDeclaration : ((KtClassOrObject)declaration).getDeclarations()) {
            if (!(ktDeclaration instanceof KtProperty)) continue;
            element$iv = context.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)ktDeclaration);
            Substitutable<CallableDescriptor> substitutable = object = element$iv instanceof PropertyDescriptor ? (PropertyDescriptor)element$iv : null;
            if (object == null) continue;
            Object propertyDescriptor = object;
            if (!Intrinsics.areEqual((Object)context.getTrace().getBindingContext().get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor), (Object)true) && ((KtProperty)ktDeclaration).getDelegate() == null) continue;
            context.getTrace().report((Diagnostic)ErrorsJvm.FIELD_IN_JVM_RECORD.on((PsiElement)ktDeclaration));
            return;
        }
        for (KtSuperTypeListEntry ktSuperTypeListEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            if (!(ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry)) continue;
            context.getTrace().report((Diagnostic)ErrorsJvm.DELEGATION_BY_IN_JVM_RECORD.on((PsiElement)ktSuperTypeListEntry));
            return;
        }
        for (KotlinType kotlinType : ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes()) {
            Object classDescriptor;
            element$iv = kotlinType.getConstructor().getDeclarationDescriptor();
            object = element$iv instanceof ClassDescriptor ? (ClassDescriptor)element$iv : null;
            if (object == null || (classDescriptor = object).getKind() == ClassKind.INTERFACE || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)classDescriptor), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
            it = ((KtClassOrObject)declaration).getNameIdentifier();
            element$iv = it == null ? (PsiElement)declaration : it;
            reportSupertypeOn = element$iv;
            context.getTrace().report((Diagnostic)ErrorsJvm.JVM_RECORD_EXTENDS_CLASS.on((PsiElement)reportSupertypeOn, (Object)kotlinType));
            return;
        }
        if (!((ClassDescriptor)descriptor2).isData()) {
            context.getTrace().report((Diagnostic)ErrorsJvm.NON_DATA_CLASS_JVM_RECORD.on((PsiElement)reportOn));
            return;
        }
        KtPrimaryConstructor primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor();
        Object object2 = primaryConstructor2;
        List list3 = list = object2 == null ? CollectionsKt.emptyList() : object2.getValueParameters();
        if (list.isEmpty()) {
            element$iv = primaryConstructor2;
            reportSupertypeOn = element$iv == null ? null : element$iv.getValueParameterList();
            Object object3 = object2 = reportSupertypeOn == null ? ((KtClassOrObject)declaration).getNameIdentifier() : (PsiElement)reportSupertypeOn;
            if (object2 != null) {
                Object it2 = reportSupertypeOn = object2;
                boolean bl = false;
                context.getTrace().report((Diagnostic)ErrorsJvm.JVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS.on((PsiElement)it2));
                return;
            }
        }
        for (KtParameter parameter : list) {
            if (parameter.hasValOrVar() && !parameter.isMutable()) continue;
            context.getTrace().report((Diagnostic)ErrorsJvm.JVM_RECORD_NOT_VAL_PARAMETER.on((PsiElement)parameter));
            return;
        }
        for (KtParameter parameter : CollectionsKt.dropLast((List)list, (int)1)) {
            if (!parameter.isVarArg()) continue;
            context.getTrace().report((Diagnostic)ErrorsJvm.JVM_RECORD_NOT_LAST_VARARG_PARAMETER.on((PsiElement)parameter));
            return;
        }
    }
}

