/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeAliasExpansion;
import org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J*\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u0014\u0010\"\u001a\u00020#*\u00020#2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010\"\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010$\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0014\u0010&\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020\u000eH\u0002J\u001c\u0010'\u001a\u00020\u0011*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0014\u0010(\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001c\u0010)\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/types/TypeAliasExpander;", "", "reportStrategy", "Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "shouldCheckBounds", "", "(Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;Z)V", "checkRepeatedAnnotations", "", "existingAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "newAnnotations", "checkTypeArgumentsSubstitution", "unsubstitutedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "substitutedType", "expand", "Lorg/jetbrains/kotlin/types/SimpleType;", "typeAliasExpansion", "Lorg/jetbrains/kotlin/types/TypeAliasExpansion;", "annotations", "expandNonArgumentTypeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "originalProjection", "recursionDepth", "", "expandRecursively", "isNullable", "withAbbreviatedType", "expandTypeProjection", "underlyingProjection", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "expandWithoutAbbreviation", "combineAnnotations", "Lorg/jetbrains/kotlin/types/DynamicType;", "combineNullability", "fromType", "combineNullabilityAndAnnotations", "createAbbreviation", "createCombinedAnnotations", "substituteArguments", "Companion", "descriptors"})
public final class TypeAliasExpander {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;
    private static final int MAX_RECURSION_DEPTH = 100;
    @NotNull
    private static final TypeAliasExpander NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false);

    public TypeAliasExpander(@NotNull TypeAliasExpansionReportStrategy reportStrategy, boolean shouldCheckBounds) {
        Intrinsics.checkNotNullParameter((Object)reportStrategy, (String)"reportStrategy");
        this.reportStrategy = reportStrategy;
        this.shouldCheckBounds = shouldCheckBounds;
    }

    @NotNull
    public final SimpleType expand(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull Annotations annotations2) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"typeAliasExpansion");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        return this.expandRecursively(typeAliasExpansion, annotations2, false, 0, true);
    }

    @NotNull
    public final SimpleType expandWithoutAbbreviation(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull Annotations annotations2) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"typeAliasExpansion");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        return this.expandRecursively(typeAliasExpansion, annotations2, false, 0, false);
    }

    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, Annotations annotations2, boolean isNullable, int recursionDepth, boolean withAbbreviatedType) {
        SimpleType simpleType2;
        boolean bl;
        TypeProjectionImpl underlyingProjection = new TypeProjectionImpl(Variance.INVARIANT, typeAliasExpansion.getDescriptor().getUnderlyingType());
        TypeProjection expandedProjection = this.expandTypeProjection(underlyingProjection, typeAliasExpansion, null, recursionDepth);
        KotlinType kotlinType = expandedProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expandedProjection.type");
        SimpleType expandedType = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError(expandedType)) {
            return expandedType;
        }
        boolean bl2 = bl = expandedProjection.getProjectionKind() == Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Type alias expansion: result for " + typeAliasExpansion.getDescriptor() + " is " + (Object)((Object)expandedProjection.getProjectionKind()) + ", should be invariant";
            throw new AssertionError((Object)string);
        }
        this.checkRepeatedAnnotations(expandedType.getAnnotations(), annotations2);
        SimpleType it = simpleType2 = this.combineAnnotations(expandedType, annotations2);
        boolean bl4 = false;
        SimpleType simpleType3 = TypeUtils.makeNullableIfNeeded(it, isNullable);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"expandedType.combineAnno\u2026fNeeded(it, isNullable) }");
        SimpleType expandedTypeWithExtraAnnotations = simpleType3;
        return withAbbreviatedType ? SpecialTypesKt.withAbbreviation(expandedTypeWithExtraAnnotations, this.createAbbreviation(typeAliasExpansion, annotations2, isNullable)) : expandedTypeWithExtraAnnotations;
    }

    private final SimpleType createAbbreviation(TypeAliasExpansion $this$createAbbreviation, Annotations annotations2, boolean isNullable) {
        TypeConstructor typeConstructor2 = $this$createAbbreviation.getDescriptor().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"descriptor.typeConstructor");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor2, $this$createAbbreviation.getArguments(), isNullable, MemberScope.Empty.INSTANCE);
    }

    private final TypeProjection expandTypeProjection(TypeProjection underlyingProjection, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int recursionDepth) {
        Variance variance;
        Variance variance2;
        TypeAliasExpander typeAliasExpander;
        TypeAliasExpander.Companion.assertRecursionDepth(recursionDepth, typeAliasExpansion.getDescriptor());
        if (underlyingProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor2);
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"makeStarProjection(typeParameterDescriptor!!)");
            return typeProjection;
        }
        KotlinType kotlinType = underlyingProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"underlyingProjection.type");
        KotlinType underlyingType = kotlinType;
        TypeProjection typeProjection = typeAliasExpansion.getReplacement(underlyingType.getConstructor());
        if (typeProjection == null) {
            return this.expandNonArgumentTypeProjection(underlyingProjection, typeAliasExpansion, recursionDepth);
        }
        TypeProjection argument = typeProjection;
        if (argument.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor3);
            typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"makeStarProjection(typeParameterDescriptor!!)");
            return typeProjection;
        }
        UnwrappedType argumentType = argument.getType().unwrap();
        TypeAliasExpander $this$expandTypeProjection_u24lambda_u2d2 = typeAliasExpander = this;
        boolean bl = false;
        Variance variance3 = argument.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance3), (String)"argument.projectionKind");
        Variance argumentVariance = variance3;
        Variance variance4 = underlyingProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance4), (String)"underlyingProjection.projectionKind");
        Variance underlyingVariance = variance4;
        if (underlyingVariance == argumentVariance) {
            variance2 = argumentVariance;
        } else if (underlyingVariance == Variance.INVARIANT) {
            variance2 = argumentVariance;
        } else if (argumentVariance == Variance.INVARIANT) {
            variance2 = underlyingVariance;
        } else {
            $this$expandTypeProjection_u24lambda_u2d2.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance2 = argumentVariance;
        }
        Variance substitutionVariance = variance2;
        TypeParameterDescriptor typeParameterDescriptor4 = typeParameterDescriptor;
        Variance variance5 = typeParameterDescriptor4 == null ? Variance.INVARIANT : typeParameterDescriptor4.getVariance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance5), (String)"typeParameterDescriptor?\u2026nce ?: Variance.INVARIANT");
        Variance parameterVariance = variance5;
        if (parameterVariance == substitutionVariance) {
            variance = substitutionVariance;
        } else if (parameterVariance == Variance.INVARIANT) {
            variance = substitutionVariance;
        } else if (substitutionVariance == Variance.INVARIANT) {
            variance = Variance.INVARIANT;
        } else {
            $this$expandTypeProjection_u24lambda_u2d2.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance = substitutionVariance;
        }
        Variance resultingVariance = variance;
        this.checkRepeatedAnnotations(underlyingType.getAnnotations(), argumentType.getAnnotations());
        UnwrappedType substitutedType = argumentType instanceof DynamicType ? (UnwrappedType)this.combineAnnotations((DynamicType)argumentType, underlyingType.getAnnotations()) : (UnwrappedType)this.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType(argumentType), underlyingType);
        return new TypeProjectionImpl(resultingVariance, substitutedType);
    }

    private final DynamicType combineAnnotations(DynamicType $this$combineAnnotations, Annotations newAnnotations) {
        return $this$combineAnnotations.replaceAnnotations(this.createCombinedAnnotations($this$combineAnnotations, newAnnotations));
    }

    private final SimpleType combineAnnotations(SimpleType $this$combineAnnotations, Annotations newAnnotations) {
        return KotlinTypeKt.isError($this$combineAnnotations) ? $this$combineAnnotations : TypeSubstitutionKt.replace$default($this$combineAnnotations, null, this.createCombinedAnnotations($this$combineAnnotations, newAnnotations), 1, null);
    }

    private final Annotations createCombinedAnnotations(KotlinType $this$createCombinedAnnotations, Annotations newAnnotations) {
        if (KotlinTypeKt.isError($this$createCombinedAnnotations)) {
            return $this$createCombinedAnnotations.getAnnotations();
        }
        return AnnotationsKt.composeAnnotations(newAnnotations, $this$createCombinedAnnotations.getAnnotations());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRepeatedAnnotations(Annotations existingAnnotations, Annotations newAnnotations) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = existingAnnotations;
        Collection collection = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv;
            void var11_10 = destination$iv;
            boolean bl = false;
            FqName fqName2 = it.getFqName();
            var11_10.add(fqName2);
        }
        HashSet existingAnnotationFqNames = (HashSet)destination$iv;
        for (AnnotationDescriptor annotation : newAnnotations) {
            if (!existingAnnotationFqNames.contains(annotation.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation(annotation);
        }
    }

    private final SimpleType combineNullability(SimpleType $this$combineNullability, KotlinType fromType) {
        SimpleType simpleType2 = TypeUtils.makeNullableIfNeeded($this$combineNullability, fromType.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"makeNullableIfNeeded(thi\u2026romType.isMarkedNullable)");
        return simpleType2;
    }

    private final SimpleType combineNullabilityAndAnnotations(SimpleType $this$combineNullabilityAndAnnotations, KotlinType fromType) {
        return this.combineAnnotations(this.combineNullability($this$combineNullabilityAndAnnotations, fromType), fromType.getAnnotations());
    }

    /*
     * WARNING - void declaration
     */
    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection originalProjection, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        TypeProjection typeProjection;
        boolean bl;
        UnwrappedType originalType = originalProjection.getType().unwrap();
        if (DynamicTypesKt.isDynamic(originalType)) {
            return originalProjection;
        }
        SimpleType type2 = TypeSubstitutionKt.asSimpleType(originalType);
        if (KotlinTypeKt.isError(type2) || !TypeUtilsKt.requiresTypeAliasExpansion(type2)) {
            return originalProjection;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor typeDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean bl2 = bl = typeConstructor2.getParameters().size() == type2.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22 = false;
            String $i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22 = Intrinsics.stringPlus((String)"Unexpected malformed type: ", (Object)type2);
            throw new AssertionError((Object)$i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22);
        }
        ClassifierDescriptor classifierDescriptor = typeDescriptor;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            typeProjection = originalProjection;
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            void $this$mapIndexedTo$iv$iv;
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)typeDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)typeDescriptor);
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType(Intrinsics.stringPlus((String)"Recursive type alias: ", (Object)((TypeAliasDescriptor)typeDescriptor).getName())));
            }
            Iterable $this$mapIndexed$iv = type2.getArguments();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void typeAliasArgument;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                TypeProjection typeProjection3 = this.expandTypeProjection((TypeProjection)typeAliasArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i), recursionDepth + 1);
                collection.add(typeProjection3);
            }
            List expandedArguments = (List)destination$iv$iv;
            TypeAliasExpansion nestedExpansion = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)typeDescriptor, expandedArguments);
            SimpleType nestedExpandedType = this.expandRecursively(nestedExpansion, type2.getAnnotations(), type2.isMarkedNullable(), recursionDepth + 1, false);
            SimpleType substitutedType = this.substituteArguments(type2, typeAliasExpansion, recursionDepth);
            SimpleType typeWithAbbreviation = DynamicTypesKt.isDynamic(nestedExpandedType) ? nestedExpandedType : SpecialTypesKt.withAbbreviation(nestedExpandedType, substitutedType);
            typeProjection = new TypeProjectionImpl(originalProjection.getProjectionKind(), typeWithAbbreviation);
        } else {
            SimpleType substitutedType = this.substituteArguments(type2, typeAliasExpansion, recursionDepth);
            this.checkTypeArgumentsSubstitution(type2, substitutedType);
            typeProjection = new TypeProjectionImpl(originalProjection.getProjectionKind(), substitutedType);
        }
        return typeProjection;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType substituteArguments(SimpleType $this$substituteArguments, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        void $this$mapIndexedTo$iv$iv;
        TypeConstructor typeConstructor2 = $this$substituteArguments.getConstructor();
        Iterable $this$mapIndexed$iv = $this$substituteArguments.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void originalArgument;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeProjection projection = this.expandTypeProjection((TypeProjection)originalArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i), recursionDepth + 1);
            TypeProjection typeProjection2 = projection.isStarProjection() ? projection : (TypeProjection)new TypeProjectionImpl(projection.getProjectionKind(), TypeUtils.makeNullableIfNeeded(projection.getType(), originalArgument.getType().isMarkedNullable()));
            collection.add(typeProjection2);
        }
        List substitutedArguments = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default($this$substituteArguments, substitutedArguments, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArgumentsSubstitution(KotlinType unsubstitutedType, KotlinType substitutedType) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitutedType);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(substitutedType)");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        Iterable $this$forEachIndexed$iv = substitutedType.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void substitutedArgument;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n;
            boolean bl = false;
            if (substitutedArgument.isStarProjection()) continue;
            KotlinType kotlinType = substitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"substitutedArgument.type");
            if (TypeUtilsKt.containsTypeAliasParameters(kotlinType)) continue;
            TypeProjection unsubstitutedArgument = unsubstitutedType.getArguments().get(i);
            TypeParameterDescriptor typeParameter = unsubstitutedType.getConstructor().getParameters().get(i);
            if (!this.shouldCheckBounds) continue;
            KotlinType kotlinType2 = unsubstitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"unsubstitutedArgument.type");
            KotlinType kotlinType3 = kotlinType2;
            kotlinType2 = substitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"substitutedArgument.type");
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter, (String)"typeParameter");
            this.reportStrategy.boundsViolationInSubstitution(typeSubstitutor3, kotlinType3, kotlinType2, typeParameter);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/TypeAliasExpander$Companion;", "", "()V", "MAX_RECURSION_DEPTH", "", "NON_REPORTING", "Lorg/jetbrains/kotlin/types/TypeAliasExpander;", "getNON_REPORTING", "()Lorg/jetbrains/kotlin/types/TypeAliasExpander;", "assertRecursionDepth", "", "recursionDepth", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        private final void assertRecursionDepth(int recursionDepth, TypeAliasDescriptor typeAliasDescriptor) {
            if (recursionDepth > 100) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Too deep recursion while expanding type alias ", (Object)typeAliasDescriptor.getName()));
            }
        }

        @NotNull
        public final TypeAliasExpander getNON_REPORTING() {
            return NON_REPORTING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

