/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.statistics.BuildReportService;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0017B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/FileReportService;", "T", "Lorg/jetbrains/kotlin/build/report/statistics/BuildReportService;", "buildReportDir", "Ljava/io/File;", "projectName", "", "fileSuffix", "<init>", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "ts", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "printBuildReport", "", "data", "outputFile", "(Ljava/lang/Object;Ljava/io/File;)V", "process", "log", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)V", "createReportFile", "Companion", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nFileReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileReportService.kt\norg/jetbrains/kotlin/build/report/statistics/FileReportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public abstract class FileReportService<T>
implements BuildReportService<T> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final File buildReportDir;
    @NotNull
    private final String projectName;
    @NotNull
    private final String fileSuffix;
    private final String ts;
    @NotNull
    private static final SimpleDateFormat formatter;
    private static final int MAX_ATTEMPTS = 10;

    public FileReportService(@NotNull File buildReportDir, @NotNull String projectName, @NotNull String fileSuffix) {
        Intrinsics.checkNotNullParameter((Object)buildReportDir, (String)"buildReportDir");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)fileSuffix, (String)"fileSuffix");
        this.buildReportDir = buildReportDir;
        this.projectName = projectName;
        this.fileSuffix = fileSuffix;
        this.ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
    }

    public abstract void printBuildReport(T var1, @NotNull File var2);

    @Override
    public void process(T data, @NotNull KotlinLogger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        try {
            this.buildReportDir.mkdirs();
            if (!this.buildReportDir.exists() || !this.buildReportDir.isDirectory()) {
                KotlinLogger.error$default((KotlinLogger)log, (String)("Kotlin build report cannot be created: '" + this.buildReportDir + "' is a file or do not have permissions to create"), null, (int)2, null);
                return;
            }
            File outputFile = this.createReportFile(log);
            if (outputFile != null) {
                String string = outputFile.toPath().toUri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String buildReportPath = string;
                this.printBuildReport(data, outputFile);
                log.lifecycle("Kotlin build report is written to " + buildReportPath);
            }
        }
        catch (Exception e) {
            log.error("Could not create Kotlin build report in " + this.buildReportDir, (Throwable)e);
        }
    }

    private final File createReportFile(KotlinLogger log) {
        for (int index = 0; index < 11; ++index) {
            File outputFile = FilesKt.resolve((File)this.buildReportDir, (String)(this.projectName + "-build-" + this.ts + '-' + index + '.' + this.fileSuffix));
            if (!outputFile.createNewFile()) continue;
            return outputFile;
        }
        KotlinLogger.error$default((KotlinLogger)log, (String)"Failed to create report file after 10 attempts", null, (int)2, null);
        return null;
    }

    static {
        SimpleDateFormat simpleDateFormat;
        Companion = new Companion(null);
        SimpleDateFormat it = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        boolean bl = false;
        it.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter = simpleDateFormat;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/FileReportService$Companion;", "", "<init>", "()V", "formatter", "Ljava/text/SimpleDateFormat;", "getFormatter$kotlin_build_statistics", "()Ljava/text/SimpleDateFormat;", "MAX_ATTEMPTS", "", "kotlin-build-statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDateFormat getFormatter$kotlin_build_statistics() {
            return formatter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

