/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.FilesToRecompile;
import org.jetbrains.kotlin.jps.build.JpsICReporter;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageManager;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\"\u0010\r\u001a\u00020\u000e*\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002\u00a8\u0006\u0016"}, d2={"processChangesUsingLookups", "", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compiledFiles", "", "Ljava/io/File;", "lookupStorageManager", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "caches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "getDirtyFiles", "Lorg/jetbrains/kotlin/jps/build/FilesToRecompile;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "getLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "representativeTarget", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuilder.kt\norg/jetbrains/kotlin/jps/build/KotlinBuilderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,800:1\n1391#2:801\n1480#2,5:802\n*S KotlinDebug\n*F\n+ 1 KotlinBuilder.kt\norg/jetbrains/kotlin/jps/build/KotlinBuilderKt\n*L\n756#1:801\n756#1:802,5\n*E\n"})
public final class KotlinBuilderKt {
    /*
     * WARNING - void declaration
     */
    private static final void processChangesUsingLookups(ChangesCollector $this$processChangesUsingLookups, Set<? extends File> compiledFiles, JpsLookupStorageManager lookupStorageManager, FSOperationsHelper fsOperations, Iterable<? extends JpsIncrementalCache> caches) {
        void $this$flatMapTo$iv$iv;
        Iterable<? extends JpsIncrementalCache> $this$flatMap$iv = caches;
        boolean $i$f$flatMap = false;
        Iterable<? extends JpsIncrementalCache> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JpsIncrementalCache it = (JpsIncrementalCache)element$iv$iv;
            boolean bl = false;
            Iterable<AbstractIncrementalCache<?>> list$iv$iv = it.getThisWithDependentCaches();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List allCaches = (List)destination$iv$iv;
        JpsICReporter reporter = new JpsICReporter();
        ICReporterKt.debug(reporter, (Function0<String>)((Function0)KotlinBuilderKt::processChangesUsingLookups$lambda$1));
        FilesToRecompile dirtyFiles = KotlinBuilderKt.getDirtyFiles($this$processChangesUsingLookups, allCaches, lookupStorageManager);
        Set excludeFiles = compiledFiles.containsAll((Collection)dirtyFiles.getForceRecompileTogether()) ? compiledFiles : SetsKt.minus(compiledFiles, (Iterable)dirtyFiles.getForceRecompileTogether());
        fsOperations.markInChunkOrDependents(SetsKt.plus(dirtyFiles.getDirtyFiles(), (Iterable)dirtyFiles.getForceRecompileTogether()), excludeFiles);
        ICReporterKt.debug(reporter, (Function0<String>)((Function0)KotlinBuilderKt::processChangesUsingLookups$lambda$2));
    }

    private static final FilesToRecompile getDirtyFiles(ChangesCollector $this$getDirtyFiles, Iterable<? extends IncrementalCacheCommon> caches, JpsLookupStorageManager lookupStorageManager) {
        JpsICReporter reporter = new JpsICReporter();
        DirtyData dirtyData = BuildUtilKt.getChangedAndImpactedSymbols($this$getDirtyFiles, caches, (ICReporter)reporter);
        Collection<LookupSymbol> dirtyLookupSymbols = dirtyData.component1();
        Collection<FqName> dirtyClassFqNames = dirtyData.component2();
        Collection<FqName> forceRecompile = dirtyData.component3();
        Set dirtyFilesFromLookups = (Set)lookupStorageManager.withLookupStorage(arg_0 -> KotlinBuilderKt.getDirtyFiles$lambda$0(dirtyLookupSymbols, reporter, arg_0));
        return new FilesToRecompile(SetsKt.plus((Set)dirtyFilesFromLookups, (Iterable)BuildUtilKt.mapClassesFqNamesToFiles$default(caches, dirtyClassFqNames, reporter, null, 8, null)), BuildUtilKt.mapClassesFqNamesToFiles$default(caches, forceRecompile, reporter, null, 8, null));
    }

    private static final LookupTracker getLookupTracker(JpsProject project, KotlinModuleBuildTarget<?> representativeTarget) {
        Object testLookupTracker;
        Object object = TestingContextKt.getTestingContext(project);
        if (object == null || (object = ((TestingContext)object).getLookupTracker()) == null) {
            object = testLookupTracker = (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            return new LookupTrackerImpl((LookupTracker)testLookupTracker);
        }
        return testLookupTracker;
    }

    private static final String processChangesUsingLookups$lambda$1() {
        return "Start processing changes";
    }

    private static final String processChangesUsingLookups$lambda$2() {
        return "End of processing changes";
    }

    private static final Set getDirtyFiles$lambda$0(Collection $dirtyLookupSymbols, JpsICReporter $reporter, LookupStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildUtilKt.mapLookupSymbolsToFiles$default(it, $dirtyLookupSymbols, $reporter, null, 8, null);
    }

    public static final /* synthetic */ FilesToRecompile access$getDirtyFiles(ChangesCollector $receiver, Iterable caches, JpsLookupStorageManager lookupStorageManager) {
        return KotlinBuilderKt.getDirtyFiles($receiver, caches, lookupStorageManager);
    }

    public static final /* synthetic */ LookupTracker access$getLookupTracker(JpsProject project, KotlinModuleBuildTarget representativeTarget) {
        return KotlinBuilderKt.getLookupTracker(project, representativeTarget);
    }

    public static final /* synthetic */ void access$processChangesUsingLookups(ChangesCollector $receiver, Set compiledFiles, JpsLookupStorageManager lookupStorageManager, FSOperationsHelper fsOperations, Iterable caches) {
        KotlinBuilderKt.processChangesUsingLookups($receiver, compiledFiles, lookupStorageManager, fsOperations, caches);
    }
}

