/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00102\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0086\u0002J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\tH\u0086\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/jps/build/MarkerFile;", "", "fileName", "", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "get", "", "target", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;)Ljava/lang/Boolean;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)Ljava/lang/Boolean;", "set", "", "value", "clean", "markerFile", "Ljava/io/File;", "getMarkerFile", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)Ljava/io/File;", "jps-plugin"})
public abstract class MarkerFile {
    @NotNull
    private final String fileName;
    @NotNull
    private final BuildDataPaths paths;

    public MarkerFile(@NotNull String fileName, @NotNull BuildDataPaths paths) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        this.fileName = fileName;
        this.paths = paths;
    }

    @Nullable
    public final Boolean get(@NotNull KotlinModuleBuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.get(target.getJpsModuleBuildTarget());
    }

    @Nullable
    public final Boolean get(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        File file = this.getMarkerFile(target);
        if (!file.exists()) {
            return null;
        }
        return Boolean.parseBoolean(FilesKt.readText$default((File)file, null, (int)1, null));
    }

    public final void set(@NotNull KotlinModuleBuildTarget<?> target, boolean value2) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.set(target.getJpsModuleBuildTarget(), value2);
    }

    public final void set(@NotNull ModuleBuildTarget target, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        File file = this.getMarkerFile(target);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FilesKt.writeText$default((File)file, (String)String.valueOf(value2), null, (int)2, null);
    }

    public final void clean(@NotNull KotlinModuleBuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.clean(target.getJpsModuleBuildTarget());
    }

    public final void clean(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.getMarkerFile(target).delete();
    }

    private final File getMarkerFile(ModuleBuildTarget $this$markerFile) {
        File directory = new File(this.paths.getTargetDataRoot((BuildTarget)$this$markerFile), "kotlin");
        return new File(directory, this.fileName);
    }
}

