/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\f\u0010\u0019\u001a\u00020\u0013*\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "", "<init>", "()V", "isOnTeamcity", "", "totalTime", "Ljava/util/concurrent/atomic/AtomicLong;", "escapedChar", "", "c", "escape", "", "text", "registerStatistic", "", "moduleChunk", "Lorg/jetbrains/jps/ModuleChunk;", "timeToCompileNs", "", "printPerChunkStatistics", "reportTotal", "printStatisticMessage", "key", "value", "nanosToMillis", "jps-plugin"})
public final class TeamcityStatisticsLogger {
    private final boolean isOnTeamcity = System.getenv("TEAMCITY_VERSION") != null;
    @NotNull
    private final AtomicLong totalTime = new AtomicLong();

    private final char escapedChar(char c) {
        char c2;
        switch (c) {
            case '\n': {
                c2 = 'n';
                break;
            }
            case '\r': {
                c2 = 'r';
                break;
            }
            case '\u0085': {
                c2 = 'x';
                break;
            }
            case '\u2028': {
                c2 = 'l';
                break;
            }
            case '\u2029': {
                c2 = 'p';
                break;
            }
            case '|': {
                c2 = '|';
                break;
            }
            case '\'': {
                c2 = '\'';
                break;
            }
            case '[': {
                c2 = '[';
                break;
            }
            case ']': {
                c2 = ']';
                break;
            }
            default: {
                c2 = '\u0000';
            }
        }
        return c2;
    }

    private final String escape(String text) {
        StringBuilder escaped = new StringBuilder();
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            char escChar = this.escapedChar(c);
            StringBuilder stringBuilder = escChar == '\u0000' ? escaped.append(c) : escaped.append('|').append(escChar);
        }
        String string = escaped.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void registerStatistic(@NotNull ModuleChunk moduleChunk, long timeToCompileNs) {
        Intrinsics.checkNotNullParameter((Object)moduleChunk, (String)"moduleChunk");
        if (!this.isOnTeamcity) {
            return;
        }
        this.totalTime.addAndGet(timeToCompileNs);
        this.printPerChunkStatistics(moduleChunk, timeToCompileNs);
    }

    private final void printPerChunkStatistics(ModuleChunk moduleChunk, long timeToCompileNs) {
        this.printStatisticMessage("Kotlin Builder for " + moduleChunk.getPresentableShortName() + " compilation time, ms", String.valueOf(this.nanosToMillis(timeToCompileNs)));
    }

    public final void reportTotal() {
        if (!this.isOnTeamcity) {
            return;
        }
        this.printStatisticMessage("Kotlin Builder total compilation time, ms", String.valueOf(this.nanosToMillis(this.totalTime.get())));
    }

    private final void printStatisticMessage(String key, String value2) {
        System.out.println((Object)("##teamcity[buildStatisticValue key='" + this.escape(key) + "' value='" + this.escape(value2) + "']"));
    }

    private final long nanosToMillis(long $this$nanosToMillis) {
        return TimeUnit.NANOSECONDS.toMillis($this$nanosToMillis);
    }
}

