/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManagerKt;
import org.jetbrains.kotlin.load.kotlin.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "versionFile", "Ljava/nio/file/Path;", "expectedOwnVersion", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/Integer;)V", "expected", "getExpected", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "loadActual", "writeVersion", "", "values", "versionFileForTesting", "Ljava/io/File;", "getVersionFileForTesting", "()Ljava/io/File;", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nCacheVersionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheVersionManager.kt\norg/jetbrains/kotlin/jps/incremental/CacheVersionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class CacheVersionManager
implements CacheAttributesManager<CacheVersion> {
    @NotNull
    private final Path versionFile;
    @Nullable
    private final CacheVersion expected;

    public CacheVersionManager(@NotNull Path versionFile, @Nullable Integer expectedOwnVersion) {
        Intrinsics.checkNotNullParameter((Object)versionFile, (String)"versionFile");
        this.versionFile = versionFile;
        this.expected = expectedOwnVersion == null ? null : CacheVersionManagerKt.CacheVersion(expectedOwnVersion, JvmBytecodeBinaryVersion.INSTANCE, MetadataVersion.INSTANCE);
    }

    @Override
    @Nullable
    public CacheVersion getExpected() {
        return this.expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CacheVersion loadActual() {
        InputStream inputStream;
        if (!this.versionFile.toFile().exists()) {
            inputStream = null;
        } else {
            Object object;
            try {
                InputStream inputStream2 = Files.newInputStream(this.versionFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
                object = inputStream2;
                Object object2 = Charsets.UTF_8;
                Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
                int n = 8192;
                object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                object2 = null;
                try {
                    BufferedReader it = (BufferedReader)object;
                    boolean bl = false;
                    object3 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                int n2 = Integer.parseInt((String)object3);
                object = new CacheVersion(n2);
            }
            catch (NumberFormatException e) {
                object = null;
            }
            catch (IOException e) {
                object = null;
            }
            inputStream = object;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeVersion(@Nullable CacheVersion values) {
        if (values == null) {
            Files.deleteIfExists(this.versionFile);
        } else {
            Files.createDirectories(this.versionFile.getParent(), new FileAttribute[0]);
            OutputStream outputStream = Files.newOutputStream(this.versionFile, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl = false;
                writer = it.append(String.valueOf(values.getIntValue()));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
    }

    @TestOnly
    @NotNull
    public final File getVersionFileForTesting() {
        File file = this.versionFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }
}

