/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets.impl;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.java.LookupNameUsage;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jps/targets/impl/LookupUsageRegistrar;", "", "<init>", "()V", "processLookupTracker", "", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "callback", "Lorg/jetbrains/jps/builders/java/dependencyView/Callbacks$Backend;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "checkRequiredJpsBuildApi", "", "registerLookupTrackerImplEntries", "Lorg/jetbrains/kotlin/incremental/LookupTrackerImpl;", "Companion", "jps-plugin"})
public final class LookupUsageRegistrar {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HOW_TO_FIX = "Kotlin incremental compilation might be incorrect. Consider using build option -Djps.use.dependency.graph=false";

    public final void processLookupTracker(@Nullable LookupTracker lookupTracker, @NotNull Callbacks.Backend callback, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        if (!this.checkRequiredJpsBuildApi()) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "Can't register lookup usages with this version of JPS. Kotlin incremental compilation might be incorrect. Consider using build option -Djps.use.dependency.graph=false", null, 4, null);
            return;
        }
        if (lookupTracker instanceof LookupTrackerImpl) {
            this.registerLookupTrackerImplEntries((LookupTrackerImpl)lookupTracker, callback);
        } else {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "Can't register lookup usages with this compilation setup. lookupTracker is " + lookupTracker + ". Kotlin incremental compilation might be incorrect. Consider using build option -Djps.use.dependency.graph=false", null, 4, null);
        }
    }

    private final boolean checkRequiredJpsBuildApi() {
        try {
            Class.forName("org.jetbrains.jps.dependency.java.LookupNameUsage");
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private final void registerLookupTrackerImplEntries(LookupTrackerImpl lookupTracker, Callbacks.Backend callback) {
        for (Map.Entry entry : lookupTracker.getLookups().entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            LookupSymbol lookupKey = (LookupSymbol)entry.getKey();
            Collection fileList = (Collection)entry.getValue();
            String symbolOwner = StringsKt.replace$default((String)lookupKey.getScope(), (char)'.', (char)'/', (boolean)false, (int)4, null);
            String symbolName = lookupKey.getName();
            LookupNameUsage usage = new LookupNameUsage(symbolOwner, symbolName);
            for (String file : fileList) {
                callback.registerUsage(Paths.get(file, new String[0]), (Usage)usage);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/jps/targets/impl/LookupUsageRegistrar$Companion;", "", "<init>", "()V", "HOW_TO_FIX", "", "jps-plugin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

