/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.config.JsGenerationGranularity;
import org.jetbrains.kotlin.js.config.ModuleKind;
import org.jetbrains.kotlin.js.config.TsCompilationStrategy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J\u0010\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003JE\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0014\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010'\u001a\u00020(H\u00d6\u0081\u0004J\n\u0010)\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/config/WebArtifactConfiguration;", "", "moduleKind", "Lorg/jetbrains/kotlin/js/config/ModuleKind;", "moduleName", "", "outputDirectory", "Ljava/io/File;", "outputName", "granularity", "Lorg/jetbrains/kotlin/js/config/JsGenerationGranularity;", "tsCompilationStrategy", "Lorg/jetbrains/kotlin/js/config/TsCompilationStrategy;", "<init>", "(Lorg/jetbrains/kotlin/js/config/ModuleKind;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Lorg/jetbrains/kotlin/js/config/JsGenerationGranularity;Lorg/jetbrains/kotlin/js/config/TsCompilationStrategy;)V", "getModuleKind", "()Lorg/jetbrains/kotlin/js/config/ModuleKind;", "getModuleName", "()Ljava/lang/String;", "getOutputDirectory", "()Ljava/io/File;", "getOutputName", "getGranularity", "()Lorg/jetbrains/kotlin/js/config/JsGenerationGranularity;", "getTsCompilationStrategy", "()Lorg/jetbrains/kotlin/js/config/TsCompilationStrategy;", "outputJsFile", "outputSourceMapFile", "outputDtsFile", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "js.config"})
public final class WebArtifactConfiguration {
    @NotNull
    private final ModuleKind moduleKind;
    @NotNull
    private final String moduleName;
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final String outputName;
    @NotNull
    private final JsGenerationGranularity granularity;
    @NotNull
    private final TsCompilationStrategy tsCompilationStrategy;

    public WebArtifactConfiguration(@NotNull ModuleKind moduleKind, @NotNull String moduleName, @NotNull File outputDirectory, @NotNull String outputName, @NotNull JsGenerationGranularity granularity, @NotNull TsCompilationStrategy tsCompilationStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        Intrinsics.checkNotNullParameter((Object)((Object)tsCompilationStrategy), (String)"tsCompilationStrategy");
        this.moduleKind = moduleKind;
        this.moduleName = moduleName;
        this.outputDirectory = outputDirectory;
        this.outputName = outputName;
        this.granularity = granularity;
        this.tsCompilationStrategy = tsCompilationStrategy;
    }

    @NotNull
    public final ModuleKind getModuleKind() {
        return this.moduleKind;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final File getOutputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    public final String getOutputName() {
        return this.outputName;
    }

    @NotNull
    public final JsGenerationGranularity getGranularity() {
        return this.granularity;
    }

    @NotNull
    public final TsCompilationStrategy getTsCompilationStrategy() {
        return this.tsCompilationStrategy;
    }

    @NotNull
    public final File outputJsFile(@NotNull String outputName) {
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        return FilesKt.resolve((File)this.outputDirectory, (String)(outputName + this.moduleKind.getJsExtension()));
    }

    public static /* synthetic */ File outputJsFile$default(WebArtifactConfiguration webArtifactConfiguration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = webArtifactConfiguration.outputName;
        }
        return webArtifactConfiguration.outputJsFile(string);
    }

    @NotNull
    public final File outputSourceMapFile(@NotNull String outputName) {
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        return FilesKt.resolve((File)this.outputDirectory, (String)(outputName + this.moduleKind.getJsExtension() + ".map"));
    }

    public static /* synthetic */ File outputSourceMapFile$default(WebArtifactConfiguration webArtifactConfiguration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = webArtifactConfiguration.outputName;
        }
        return webArtifactConfiguration.outputSourceMapFile(string);
    }

    @NotNull
    public final File outputDtsFile(@NotNull String outputName) {
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        return FilesKt.resolve((File)this.outputDirectory, (String)(outputName + this.moduleKind.getDtsExtension()));
    }

    public static /* synthetic */ File outputDtsFile$default(WebArtifactConfiguration webArtifactConfiguration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = webArtifactConfiguration.outputName;
        }
        return webArtifactConfiguration.outputDtsFile(string);
    }

    @NotNull
    public final ModuleKind component1() {
        return this.moduleKind;
    }

    @NotNull
    public final String component2() {
        return this.moduleName;
    }

    @NotNull
    public final File component3() {
        return this.outputDirectory;
    }

    @NotNull
    public final String component4() {
        return this.outputName;
    }

    @NotNull
    public final JsGenerationGranularity component5() {
        return this.granularity;
    }

    @NotNull
    public final TsCompilationStrategy component6() {
        return this.tsCompilationStrategy;
    }

    @NotNull
    public final WebArtifactConfiguration copy(@NotNull ModuleKind moduleKind, @NotNull String moduleName, @NotNull File outputDirectory, @NotNull String outputName, @NotNull JsGenerationGranularity granularity, @NotNull TsCompilationStrategy tsCompilationStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)outputName, (String)"outputName");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        Intrinsics.checkNotNullParameter((Object)((Object)tsCompilationStrategy), (String)"tsCompilationStrategy");
        return new WebArtifactConfiguration(moduleKind, moduleName, outputDirectory, outputName, granularity, tsCompilationStrategy);
    }

    public static /* synthetic */ WebArtifactConfiguration copy$default(WebArtifactConfiguration webArtifactConfiguration, ModuleKind moduleKind, String string, File file, String string2, JsGenerationGranularity jsGenerationGranularity, TsCompilationStrategy tsCompilationStrategy, int n, Object object) {
        if ((n & 1) != 0) {
            moduleKind = webArtifactConfiguration.moduleKind;
        }
        if ((n & 2) != 0) {
            string = webArtifactConfiguration.moduleName;
        }
        if ((n & 4) != 0) {
            file = webArtifactConfiguration.outputDirectory;
        }
        if ((n & 8) != 0) {
            string2 = webArtifactConfiguration.outputName;
        }
        if ((n & 0x10) != 0) {
            jsGenerationGranularity = webArtifactConfiguration.granularity;
        }
        if ((n & 0x20) != 0) {
            tsCompilationStrategy = webArtifactConfiguration.tsCompilationStrategy;
        }
        return webArtifactConfiguration.copy(moduleKind, string, file, string2, jsGenerationGranularity, tsCompilationStrategy);
    }

    @NotNull
    public String toString() {
        return "WebArtifactConfiguration(moduleKind=" + (Object)((Object)this.moduleKind) + ", moduleName=" + this.moduleName + ", outputDirectory=" + this.outputDirectory + ", outputName=" + this.outputName + ", granularity=" + (Object)((Object)this.granularity) + ", tsCompilationStrategy=" + (Object)((Object)this.tsCompilationStrategy) + ')';
    }

    public int hashCode() {
        int result = this.moduleKind.hashCode();
        result = result * 31 + this.moduleName.hashCode();
        result = result * 31 + this.outputDirectory.hashCode();
        result = result * 31 + this.outputName.hashCode();
        result = result * 31 + this.granularity.hashCode();
        result = result * 31 + this.tsCompilationStrategy.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebArtifactConfiguration)) {
            return false;
        }
        WebArtifactConfiguration webArtifactConfiguration = (WebArtifactConfiguration)other;
        if (this.moduleKind != webArtifactConfiguration.moduleKind) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.moduleName, (Object)webArtifactConfiguration.moduleName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outputDirectory, (Object)webArtifactConfiguration.outputDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outputName, (Object)webArtifactConfiguration.outputName)) {
            return false;
        }
        if (this.granularity != webArtifactConfiguration.granularity) {
            return false;
        }
        return this.tsCompilationStrategy == webArtifactConfiguration.tsCompilationStrategy;
    }
}

