/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.konan.file.ZipFileSystemInPlaceAccessor;
import org.jetbrains.kotlin.library.KotlinLibraryLayout;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImpl;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/library/impl/BaseLibraryAccess;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "", "klib", "Lorg/jetbrains/kotlin/konan/file/File;", "component", "", "zipAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;)V", "getKlib", "()Lorg/jetbrains/kotlin/konan/file/File;", "klibZipAccessor", "layout", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "getLayout", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "inPlace", "T", "action", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-util-klib"})
public class BaseLibraryAccess<L extends KotlinLibraryLayout> {
    @NotNull
    private final File klib;
    @NotNull
    private final KotlinLibraryLayoutImpl layout;
    @NotNull
    private final ZipFileSystemAccessor klibZipAccessor;

    public BaseLibraryAccess(@NotNull File klib, @Nullable String component, @Nullable ZipFileSystemAccessor zipAccessor) {
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        this.klib = klib;
        this.layout = new KotlinLibraryLayoutImpl(this.klib, component);
        ZipFileSystemAccessor zipFileSystemAccessor = zipAccessor;
        if (zipFileSystemAccessor == null) {
            zipFileSystemAccessor = ZipFileSystemInPlaceAccessor.INSTANCE;
        }
        this.klibZipAccessor = zipFileSystemAccessor;
    }

    @NotNull
    public final File getKlib() {
        return this.klib;
    }

    @NotNull
    public KotlinLibraryLayoutImpl getLayout() {
        return this.layout;
    }

    public final <T> T inPlace(@NotNull Function1<? super L, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.getLayout().isZipped()) {
            object = this.klibZipAccessor.withZipFileSystem(this.getLayout().getKlib(), (Function1)new Function1<FileSystem, T>(action, this){
                final /* synthetic */ Function1<L, T> $action;
                final /* synthetic */ BaseLibraryAccess<L> this$0;
                {
                    this.$action = $action;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final T invoke(FileSystem zipFileSystem) {
                    Intrinsics.checkNotNullParameter((Object)zipFileSystem, (String)"zipFileSystem");
                    KotlinLibraryLayout kotlinLibraryLayout = this.this$0.getLayout().directlyFromZip(zipFileSystem);
                    Intrinsics.checkNotNull((Object)kotlinLibraryLayout, (String)"null cannot be cast to non-null type L of org.jetbrains.kotlin.library.impl.BaseLibraryAccess");
                    return (T)this.$action.invoke((Object)kotlinLibraryLayout);
                }
            });
        } else {
            KotlinLibraryLayoutImpl kotlinLibraryLayoutImpl = this.getLayout();
            Intrinsics.checkNotNull((Object)kotlinLibraryLayoutImpl, (String)"null cannot be cast to non-null type L of org.jetbrains.kotlin.library.impl.BaseLibraryAccess");
            object = action.invoke((Object)kotlinLibraryLayoutImpl);
        }
        return (T)object;
    }
}

