/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\t\u001a\u00020\n\u001a3\u0010\u000e\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\u0014H\u0082\b\u001a\u001e\u0010\u0016\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0019\u001a\n \u0002*\u0004\u0018\u00010\u00060\u0006*\u00020\nH\u0002\u001a&\u0010\u001a\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0012\u001a&\u0010\u001a\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0012\u001a)\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001e0\u0014\u00a2\u0006\u0002\u0010 \u001a1\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\n2\u0006\u0010!\u001a\u00020\u00122\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001e0\u0014\u00a2\u0006\u0002\u0010\"\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\n2\u0006\u0010#\u001a\u00020\n\u001a\u0016\u0010$\u001a\u00020\u000b*\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0012H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"DEFAULT_ZIP_ENTRY_TIME", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "zipDirAs", "", "dirPath", "Ljava/nio/file/Path;", "zipFilePath", "expandSymlinks", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "Ljava/nio/file/FileSystem;", "path", "", "newEntry", "Ljava/util/zip/ZipOutputStream;", "relativePath", "isDir", "", "block", "Lkotlin/Function1;", "Ljava/util/zip/ZipEntry;", "recursiveCopyTo", "destination", "resetTimeAttributes", "toPath", "unzipTo", "destinationDirectory", "fromSubdirectory", "withZipFileSystem", "T", "action", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "create", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipFile", "zipFileSystem", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,191:1\n774#2:192\n865#2,2:193\n1617#2,9:195\n1869#2:204\n1870#2:206\n1626#2:207\n1#3:205\n214#4,3:208\n214#4,13:211\n225#4,2:224\n217#4,7:226\n214#4,13:233\n*S KotlinDebug\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n*L\n31#1:192\n31#1:193,2\n31#1:195,9\n31#1:204\n31#1:206\n31#1:207\n31#1:205\n55#1:208,3\n56#1:211,13\n55#1:224,2\n55#1:226,7\n155#1:233,13\n*E\n"})
public final class ZipUtilKt {
    private static final FileTime DEFAULT_ZIP_ENTRY_TIME = FileTime.fromMillis(0L);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean create) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$zipFileSystem, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(create))};
        HashMap attributes = MapsKt.hashMapOf((Pair[])pairArray);
        List<FileSystemProvider> list = FileSystemProvider.installedProviders();
        Intrinsics.checkNotNullExpressionValue(list, (String)"installedProviders()");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getScheme(), (Object)"jar")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FileSystem it$iv$iv;
            FileSystem fileSystem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl2 = false;
            try {
                fileSystem = it.newFileSystem(ZipUtilKt.toPath($this$zipFileSystem), (Map)attributes);
            }
            catch (Exception e2) {
                Exception exception = e2;
                if (!(exception instanceof UnsupportedOperationException ? true : exception instanceof IllegalArgumentException)) {
                    throw e2;
                }
                fileSystem = null;
            }
            if (fileSystem == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (FileSystem)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = $this$file.getPath(file.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.getPath(file.path)");
        return new File(path);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = $this$file.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.getPath(path)");
        return new File(path2);
    }

    private static final Path toPath(File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean create, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = ZipUtilKt.zipFileSystem($this$withZipFileSystem, create);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            object = action.invoke((Object)$this$use$iv);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)object;
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }
}

