/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.h;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.AbstractIntList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.ag;

public interface IntList
extends Comparable<List<? extends Integer>>,
List<Integer>,
IntCollection {
    @Override
    public IntListIterator iterator();

    @Override
    default public IntSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractIntList.a(this);
        }
        return ag.a((IntIterator)this.iterator(), h.a(this), 16720);
    }

    public IntListIterator listIterator();

    public IntListIterator listIterator(int var1);

    public IntList subList(int var1, int var2);

    public void getElements(int var1, int[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    default public void setElements(int[] a2) {
        void var1_1;
        this.setElements(0, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void setElements(int index, int[] a2) {
        void var2_2;
        void var1_1;
        this.setElements((int)var1_1, a2, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    default public void setElements(int index, int[] a2, int offset, int length) {
        void var1_1;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        IntArrays.ensureOffsetLength(a2, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        IntListIterator intListIterator = this.listIterator((int)var1_1);
        int n2 = 0;
        while (n2 < length) {
            intListIterator.nextInt();
            intListIterator.f_(a2[offset + n2++]);
        }
    }

    @Override
    public boolean add(int var1);

    @Override
    public void add(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public void add(int index, Integer key) {
        void var2_2;
        void var1_1;
        this.add((int)var1_1, var2_2.intValue());
    }

    @Override
    public int set(int var1, int var2);

    default public void replaceAll(IntUnaryOperator operator) {
        IntListIterator intListIterator = this.listIterator();
        while (intListIterator.hasNext()) {
            intListIterator.f_(operator.applyAsInt(intListIterator.nextInt()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Integer> operator) {
        void var1_1;
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof IntUnaryOperator ? (IntUnaryOperator)((Object)operator) : ((UnaryOperator)var1_1)::apply);
    }

    public int getInt(int var1);

    public int indexOf(int var1);

    public int lastIndexOf(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public boolean contains(Object key) {
        void var1_1;
        return IntCollection.super.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public Integer get(int index) {
        void var1_1;
        return this.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public int indexOf(Object o2) {
        void var1_1;
        return this.indexOf((Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public int lastIndexOf(Object o2) {
        void var1_1;
        return this.lastIndexOf((Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public boolean add(Integer k2) {
        void var1_1;
        return this.add(var1_1.intValue());
    }

    public int removeInt(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public boolean remove(Object key) {
        void var1_1;
        return IntCollection.super.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public Integer remove(int index) {
        void var1_1;
        return this.removeInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public Integer set(int index, Integer k2) {
        void var2_2;
        void var1_1;
        return this.set((int)var1_1, var2_2.intValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public void sort(Comparator<? super Integer> comparator) {
        void var1_1;
        this.sort(IntComparators.asIntComparator((Comparator<? super Integer>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    default public void sort(IntComparator comparator) {
        void var1_1;
        if (comparator == null) {
            this.unstableSort(comparator);
            return;
        }
        int[] nArray = this.toIntArray();
        IntArrays.stableSort(nArray, (IntComparator)var1_1);
        this.setElements(nArray);
    }

    /*
     * WARNING - void declaration
     */
    default public void unstableSort(IntComparator comparator) {
        int[] nArray = this.toIntArray();
        if (comparator == null) {
            IntArrays.unstableSort(nArray);
        } else {
            void var1_1;
            IntArrays.unstableSort(nArray, (IntComparator)var1_1);
        }
        this.setElements(nArray);
    }
}

