/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.h;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.N;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.V;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.ah;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.l;

public interface LongList
extends Comparable<List<? extends Long>>,
List<Long>,
LongCollection {
    @Override
    public LongListIterator iterator();

    @Override
    default public LongSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new l.a(this);
        }
        return ah.a((LongIterator)this.iterator(), h.a(this), 16720);
    }

    public LongListIterator listIterator();

    public LongListIterator listIterator(int var1);

    public LongList subList(int var1, int var2);

    public void getElements(int var1, long[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    default public void setElements(long[] a2) {
        void var1_1;
        this.setElements(0, (long[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void setElements(int index, long[] a2) {
        void var2_2;
        void var1_1;
        this.setElements((int)var1_1, a2, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    default public void setElements(int index, long[] a2, int offset, int length) {
        void var1_1;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        N.c(a2, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        LongListIterator longListIterator = this.listIterator((int)var1_1);
        int n2 = 0;
        while (n2 < length) {
            longListIterator.nextLong();
            longListIterator.b(a2[offset + n2++]);
        }
    }

    @Override
    public boolean add(long var1);

    @Override
    public void add(int var1, long var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public void add(int index, Long key) {
        void var2_2;
        void var1_1;
        this.add((int)var1_1, var2_2.longValue());
    }

    @Override
    public long set(int var1, long var2);

    default public void replaceAll(LongUnaryOperator operator) {
        LongListIterator longListIterator = this.listIterator();
        while (longListIterator.hasNext()) {
            longListIterator.b(operator.applyAsLong(longListIterator.nextLong()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Long> operator) {
        void var1_1;
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof LongUnaryOperator ? (LongUnaryOperator)((Object)operator) : ((UnaryOperator)var1_1)::apply);
    }

    public long getLong(int var1);

    public int indexOf(long var1);

    public int lastIndexOf(long var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public boolean contains(Object key) {
        void var1_1;
        return LongCollection.super.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public Long get(int index) {
        void var1_1;
        return this.getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public int indexOf(Object o2) {
        void var1_1;
        return this.indexOf((Long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public int lastIndexOf(Object o2) {
        void var1_1;
        return this.lastIndexOf((Long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public boolean add(Long k2) {
        void var1_1;
        return this.add(var1_1.longValue());
    }

    public long removeLong(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public boolean remove(Object key) {
        void var1_1;
        return LongCollection.super.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public Long remove(int index) {
        void var1_1;
        return this.removeLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public Long set(int index, Long k2) {
        void var2_2;
        void var1_1;
        return this.set((int)var1_1, var2_2.longValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    default public void sort(Comparator<? super Long> comparator) {
        void var1_1;
        this.sort(V.a((Comparator<? super Long>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    default public void sort(LongComparator comparator) {
        void var1_1;
        if (comparator == null) {
            this.unstableSort(comparator);
            return;
        }
        long[] lArray = this.toLongArray();
        N.b(lArray, (LongComparator)var1_1);
        this.setElements(lArray);
    }

    /*
     * WARNING - void declaration
     */
    default public void unstableSort(LongComparator comparator) {
        long[] lArray = this.toLongArray();
        if (comparator == null) {
            N.a(lArray);
        } else {
            void var1_1;
            N.a(lArray, (LongComparator)var1_1);
        }
        this.setElements(lArray);
    }
}

