/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.Klib;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.LibraryTarget;
import org.jetbrains.kotlin.library.abi.impl.AbiSignatureVersions;
import org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer;
import org.jetbrains.kotlin.library.components.KlibIrComponent;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.loader.KlibLoader;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;
import org.jetbrains.kotlin.library.loader.KlibLoaderResultKt;
import org.jetbrains.kotlin.library.loader.KlibLoaderSpec;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl;", "", "libraryFile", "Ljava/io/File;", "filters", "", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "<init>", "(Ljava/io/File;Ljava/util/List;)V", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "compositeFilter", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;", "readAbi", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "readManifest", "Lorg/jetbrains/kotlin/library/abi/LibraryManifest;", "readSupportedSignatureVersions", "", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KlibIrComponent.kt\norg/jetbrains/kotlin/library/components/KlibIrComponentKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,835:1\n1#2:836\n72#3:837\n80#3:838\n72#3:839\n1661#4,3:840\n1661#4,3:843\n1661#4,3:846\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n*L\n66#1:837\n81#1:838\n81#1:839\n94#1:840,3\n95#1:843,3\n104#1:846,3\n*E\n"})
public final class LibraryAbiReaderImpl {
    @NotNull
    private final KotlinLibrary library;
    @Nullable
    private final AbiReadingFilter.Composite compositeFilter;

    public LibraryAbiReaderImpl(@NotNull File libraryFile, @NotNull List<? extends AbiReadingFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        LibraryAbiReaderImpl libraryAbiReaderImpl = this;
        LibraryAbiReaderImpl libraryAbiReaderImpl2 = this;
        boolean bl = false;
        KlibLoaderResult klibLoadingResult = new KlibLoader((Function1<? super KlibLoaderSpec, Unit>)((Function1)arg_0 -> LibraryAbiReaderImpl.library$lambda$0$0(libraryFile, arg_0))).load();
        KlibLoaderResultKt.reportLoadingProblemsIfAny(klibLoadingResult, (Function2<? super KlibLoaderResult.ProblemSeverity, ? super String, Unit>)((Function2)LibraryAbiReaderImpl::library$lambda$0$1));
        KotlinLibrary library = (KotlinLibrary)CollectionsKt.single(klibLoadingResult.getLibrariesStdlibFirst());
        if (!(((CharSequence)KotlinLibraryKt.getUniqueName(library)).length() > 0)) {
            boolean $i$a$-check-LibraryAbiReaderImpl$library$1$42 = false;
            String $i$a$-check-LibraryAbiReaderImpl$library$1$42 = "Can't read unique name from manifest";
            throw new IllegalStateException($i$a$-check-LibraryAbiReaderImpl$library$1$42.toString());
        }
        Klib $this$ir$iv = library;
        boolean $i$f$getIr = false;
        if (!((KlibIrComponent)$this$ir$iv.getComponent(KlibIrComponent.Kind.Main.INSTANCE) != null)) {
            boolean bl2 = false;
            String string = "Library does not have IR";
            throw new IllegalStateException(string.toString());
        }
        libraryAbiReaderImpl2.library = library;
        this.compositeFilter = !((Collection)filters).isEmpty() ? new AbiReadingFilter.Composite(filters) : null;
    }

    @NotNull
    public final LibraryAbi readAbi() {
        Set<AbiSignatureVersion> supportedSignatureVersions = this.readSupportedSignatureVersions();
        Klib $this$irOrFail$iv = this.library;
        boolean $i$f$getIrOrFail = false;
        Klib $this$ir$iv$iv = $this$irOrFail$iv;
        boolean $i$f$getIr = false;
        KlibIrComponent klibIrComponent = (KlibIrComponent)$this$ir$iv$iv.getComponent(KlibIrComponent.Kind.Main.INSTANCE);
        if (klibIrComponent == null) {
            throw new IllegalStateException(("No 'ir' component in library " + $this$irOrFail$iv.getLocation()).toString());
        }
        return new LibraryAbi(this.readManifest(), KotlinLibraryKt.getUniqueName(this.library), supportedSignatureVersions, new LibraryDeserializer(klibIrComponent, KotlinLibraryKt.getBuiltInsPlatform(this.library), supportedSignatureVersions, this.compositeFilter).deserialize());
    }

    /*
     * WARNING - void declaration
     */
    private final LibraryManifest readManifest() {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv;
        void $this$readManifest_u24lambda_u240;
        List list;
        KotlinLibraryVersioning versions = this.library.getVersions();
        BuiltInsPlatform builtInsPlatform = KotlinLibraryKt.getBuiltInsPlatform(this.library);
        List list2 = list = CollectionsKt.createListBuilder();
        String string = builtInsPlatform != null ? builtInsPlatform.name() : null;
        boolean bl = false;
        Iterable iterable = CollectionsKt.sorted((Iterable)KotlinLibraryKt.getNativeTargets(this.library));
        Collection destination$iv = (Collection)$this$readManifest_u24lambda_u240;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string2 = (String)item$iv;
            collection = destination$iv;
            boolean bl2 = false;
            collection.add(new LibraryTarget.Native(p0));
        }
        $this$mapTo$iv = CollectionsKt.sorted((Iterable)KotlinLibraryKt.getWasmTargets(this.library));
        destination$iv = (Collection)$this$readManifest_u24lambda_u240;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            p0 = (String)item$iv;
            collection = destination$iv;
            boolean bl3 = false;
            collection.add(new LibraryTarget.WASM(p0));
        }
        KotlinAbiVersion kotlinAbiVersion = versions.getAbiVersion();
        String string3 = KotlinLibraryKt.getIrProviderName(this.library);
        String string4 = kotlinAbiVersion != null ? kotlinAbiVersion.toString() : null;
        String string5 = versions.getCompilerVersion();
        List list3 = CollectionsKt.build((List)list);
        String string6 = string;
        return new LibraryManifest(string6, list3, string5, string4, string3);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AbiSignatureVersion> readSupportedSignatureVersions() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.library.getVersions().getIrSignatureVersions();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KotlinIrSignatureVersion kotlinIrSignatureVersion = (KotlinIrSignatureVersion)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(AbiSignatureVersions.INSTANCE.resolveByVersionNumber(it.getNumber()));
        }
        return (Set)var2_2;
    }

    private static final Unit library$lambda$0$0(File $libraryFile, KlibLoaderSpec $this$KlibLoader) {
        Intrinsics.checkNotNullParameter((Object)$this$KlibLoader, (String)"$this$KlibLoader");
        File[] fileArray = new File[]{$libraryFile};
        $this$KlibLoader.libraryPaths(fileArray);
        return Unit.INSTANCE;
    }

    private static final Unit library$lambda$0$1(KlibLoaderResult.ProblemSeverity problemSeverity, String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)problemSeverity), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new IllegalStateException(message.toString());
    }
}

