/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.kotlin.org.eclipse.aether.SessionData;

public final class DefaultSessionData
implements SessionData {
    private final ConcurrentMap<Object, Object> data = new ConcurrentHashMap<Object, Object>();

    @Override
    public boolean set(Object key, Object oldValue, Object newValue) {
        Objects.requireNonNull(key, "key cannot be null");
        if (newValue != null) {
            if (oldValue == null) {
                return this.data.putIfAbsent(key, newValue) == null;
            }
            return this.data.replace(key, oldValue, newValue);
        }
        if (oldValue == null) {
            return !this.data.containsKey(key);
        }
        return this.data.remove(key, oldValue);
    }

    @Override
    public Object get(Object key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.data.get(key);
    }
}

