/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.noarg.diagnostic.ErrorsNoArg;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0015H\u0002R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "useIr", "", "<init>", "(Z)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportTarget", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtClass;", "getReportTarget", "(Lorg/jetbrains/kotlin/psi/KtClass;)Lcom/intellij/psi/PsiElement;", "isNoArgConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "kotlin-noarg-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nCliNoArgDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliNoArgDeclarationChecker.kt\norg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n2746#2,3:53\n1740#2,3:56\n*S KotlinDebug\n*F\n+ 1 CliNoArgDeclarationChecker.kt\norg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker\n*L\n41#1:53,3\n50#1:56,3\n*E\n"})
public abstract class AbstractNoArgDeclarationChecker
implements DeclarationChecker,
AnnotationBasedExtension {
    public AbstractNoArgDeclarationChecker(boolean useIr) {
    }

    public /* synthetic */ AbstractNoArgDeclarationChecker(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        ClassDescriptor superClass;
        block10: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClass)) {
                return;
            }
            if (((ClassDescriptor)descriptor).getKind() != ClassKind.CLASS) {
                return;
            }
            if (!this.hasSpecialAnnotation(descriptor, (KtModifierListOwner)declaration)) {
                return;
            }
            if (((ClassDescriptor)descriptor).isInner()) {
                context.getTrace().report((Diagnostic)ErrorsNoArg.NOARG_ON_INNER_CLASS_ERROR.on(this.getReportTarget((KtClass)declaration)));
            } else if (DescriptorUtils.isLocal((DeclarationDescriptor)descriptor)) {
                context.getTrace().report((Diagnostic)ErrorsNoArg.NOARG_ON_LOCAL_CLASS_ERROR.on(this.getReportTarget((KtClass)declaration)));
            }
            superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)((ClassDescriptor)descriptor));
            Collection collection = superClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getConstructors(...)");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isNoArgConstructor((ConstructorDescriptor)it)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl && !this.hasSpecialAnnotation((DeclarationDescriptor)superClass, (KtModifierListOwner)declaration)) {
            context.getTrace().report((Diagnostic)ErrorsNoArg.NO_NOARG_CONSTRUCTOR_IN_SUPERCLASS.on(this.getReportTarget((KtClass)declaration)));
        }
    }

    private final PsiElement getReportTarget(KtClass $this$reportTarget) {
        PsiElement psiElement = $this$reportTarget.getNameIdentifier();
        if (psiElement == null && (psiElement = $this$reportTarget.getClassOrInterfaceKeyword()) == null) {
            psiElement = (PsiElement)$this$reportTarget;
        }
        return psiElement;
    }

    private final boolean isNoArgConstructor(ConstructorDescriptor $this$isNoArgConstructor) {
        boolean bl;
        block3: {
            List list = $this$isNoArgConstructor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor p0 = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (p0.declaresDefaultValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public AbstractNoArgDeclarationChecker() {
        this(false, 1, null);
    }
}

