/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.maven.ParentClassLoaderProvider;

class ClassLoaderCache {
    private static volatile Cache<@NotNull ClassLoaderCacheKey, @NotNull ClassLoader> classLoaders;
    private static final Object lock;

    ClassLoaderCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cache<@NotNull ClassLoaderCacheKey, @NotNull ClassLoader> getCache(Long classLoaderCacheTimeoutInSeconds) {
        if (classLoaders == null) {
            Object object = lock;
            synchronized (object) {
                if (classLoaders == null) {
                    classLoaders = CacheBuilder.newBuilder().expireAfterAccess(classLoaderCacheTimeoutInSeconds.longValue(), TimeUnit.SECONDS).softValues().build();
                }
            }
        }
        return classLoaders;
    }

    static {
        lock = new Object();
    }

    static class ClassLoaderCacheKey {
        private final List<File> classpath;
        private final ParentClassLoaderProvider parentClassLoaderProvider;

        ClassLoaderCacheKey(List<File> classpath, ParentClassLoaderProvider parentClassLoaderProvider) {
            this.classpath = classpath;
            this.parentClassLoaderProvider = parentClassLoaderProvider;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassLoaderCacheKey key = (ClassLoaderCacheKey)o;
            return Objects.equals(this.classpath, key.classpath) && Objects.equals(this.parentClassLoaderProvider, key.parentClassLoaderProvider);
        }

        public int hashCode() {
            return Objects.hash(this.classpath, this.parentClassLoaderProvider);
        }

        public List<File> getClasspath() {
            return this.classpath;
        }

        public ParentClassLoaderProvider getParentClassLoaderProvider() {
            return this.parentClassLoaderProvider;
        }
    }
}

